/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl.util;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import pro.gravit.repackage.io.netty.handler.ssl.util.SelfSignedCertificate;

final class BouncyCastleSelfSignedCertGenerator {
    private static final Provider PROVIDER;

    static String[] generate(String string, KeyPair keyPair, SecureRandom secureRandom, Date date, Date date2, String string2) {
        PrivateKey privateKey = keyPair.getPrivate();
        X500Name x500Name = new X500Name("CN=" + string);
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(x500Name, new BigInteger(64, secureRandom), date, date2, x500Name, keyPair.getPublic());
        ContentSigner contentSigner = new JcaContentSignerBuilder(string2.equalsIgnoreCase("EC") ? "SHA256withECDSA" : "SHA256WithRSAEncryption").build(privateKey);
        X509CertificateHolder x509CertificateHolder = jcaX509v3CertificateBuilder.build(contentSigner);
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(x509CertificateHolder);
        x509Certificate.verify(keyPair.getPublic());
        return SelfSignedCertificate.newSelfSignedCertificate(string, privateKey, x509Certificate);
    }

    private BouncyCastleSelfSignedCertGenerator() {
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new RuntimeException("Neither BouncyCastleProvider nor BouncyCastleFipsProvider found");
            }
        }
        try {
            PROVIDER = (Provider)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate BouncyCastle provider", exception);
        }
    }
}

