/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import pro.gravit.repackage.io.netty.util.HashedWheelTimer$HashedWheelBucket;
import pro.gravit.repackage.io.netty.util.HashedWheelTimer$HashedWheelTimeout;
import pro.gravit.repackage.io.netty.util.HashedWheelTimer$Worker;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetector;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetectorFactory;
import pro.gravit.repackage.io.netty.util.ResourceLeakTracker;
import pro.gravit.repackage.io.netty.util.Timeout;
import pro.gravit.repackage.io.netty.util.Timer;
import pro.gravit.repackage.io.netty.util.TimerTask;
import pro.gravit.repackage.io.netty.util.concurrent.ImmediateExecutor;
import pro.gravit.repackage.io.netty.util.internal.MathUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class HashedWheelTimer
implements Timer {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(HashedWheelTimer.class);
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private static final AtomicBoolean WARNED_TOO_MANY_INSTANCES = new AtomicBoolean();
    private static final int INSTANCE_COUNT_LIMIT = 64;
    private static final long MILLISECOND_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ResourceLeakDetector<HashedWheelTimer> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(HashedWheelTimer.class, 1);
    private static final AtomicIntegerFieldUpdater<HashedWheelTimer> WORKER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HashedWheelTimer.class, "workerState");
    private final ResourceLeakTracker<HashedWheelTimer> leak;
    private final HashedWheelTimer$Worker worker = new HashedWheelTimer$Worker(this);
    private final Thread workerThread;
    public static final int WORKER_STATE_INIT = 0;
    public static final int WORKER_STATE_STARTED = 1;
    public static final int WORKER_STATE_SHUTDOWN = 2;
    private volatile int workerState;
    private final long tickDuration;
    private final HashedWheelTimer$HashedWheelBucket[] wheel;
    private final int mask;
    private final CountDownLatch startTimeInitialized = new CountDownLatch(1);
    private final Queue<HashedWheelTimer$HashedWheelTimeout> timeouts = PlatformDependent.newMpscQueue();
    private final Queue<HashedWheelTimer$HashedWheelTimeout> cancelledTimeouts = PlatformDependent.newMpscQueue();
    private final AtomicLong pendingTimeouts = new AtomicLong(0L);
    private final long maxPendingTimeouts;
    private final Executor taskExecutor;
    private volatile long startTime;

    public HashedWheelTimer() {
        this(Executors.defaultThreadFactory());
    }

    public HashedWheelTimer(long l, TimeUnit timeUnit) {
        this(Executors.defaultThreadFactory(), l, timeUnit);
    }

    public HashedWheelTimer(long l, TimeUnit timeUnit, int n) {
        this(Executors.defaultThreadFactory(), l, timeUnit, n);
    }

    public HashedWheelTimer(ThreadFactory threadFactory) {
        this(threadFactory, 100L, TimeUnit.MILLISECONDS);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l, TimeUnit timeUnit) {
        this(threadFactory, l, timeUnit, 512);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l, TimeUnit timeUnit, int n) {
        this(threadFactory, l, timeUnit, n, true);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l, TimeUnit timeUnit, int n, boolean bl) {
        this(threadFactory, l, timeUnit, n, bl, -1L);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l, TimeUnit timeUnit, int n, boolean bl, long l2) {
        this(threadFactory, l, timeUnit, n, bl, l2, ImmediateExecutor.INSTANCE);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l, TimeUnit timeUnit, int n, boolean bl, long l2, Executor executor) {
        ObjectUtil.checkNotNull(threadFactory, "threadFactory");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        ObjectUtil.checkPositive(l, "tickDuration");
        ObjectUtil.checkPositive(n, "ticksPerWheel");
        this.taskExecutor = ObjectUtil.checkNotNull(executor, "taskExecutor");
        this.wheel = HashedWheelTimer.createWheel(n);
        this.mask = this.wheel.length - 1;
        long l3 = timeUnit.toNanos(l);
        if (l3 >= Long.MAX_VALUE / (long)this.wheel.length) {
            throw new IllegalArgumentException(String.format("tickDuration: %d (expected: 0 < tickDuration in nanos < %d", l, Long.MAX_VALUE / (long)this.wheel.length));
        }
        if (l3 < MILLISECOND_NANOS) {
            logger.warn("Configured tickDuration {} smaller than {}, using 1ms.", (Object)l, (Object)MILLISECOND_NANOS);
            this.tickDuration = MILLISECOND_NANOS;
        } else {
            this.tickDuration = l3;
        }
        this.workerThread = threadFactory.newThread(this.worker);
        this.leak = bl || !this.workerThread.isDaemon() ? leakDetector.track(this) : null;
        this.maxPendingTimeouts = l2;
        if (INSTANCE_COUNTER.incrementAndGet() > 64 && WARNED_TOO_MANY_INSTANCES.compareAndSet(false, true)) {
            HashedWheelTimer.reportTooManyInstances();
        }
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        finally {
            if (WORKER_STATE_UPDATER.getAndSet(this, 2) != 2) {
                INSTANCE_COUNTER.decrementAndGet();
            }
        }
    }

    private static HashedWheelTimer$HashedWheelBucket[] createWheel(int n) {
        n = MathUtil.findNextPositivePowerOfTwo(n);
        HashedWheelTimer$HashedWheelBucket[] hashedWheelTimer$HashedWheelBucketArray = new HashedWheelTimer$HashedWheelBucket[n];
        for (int i = 0; i < hashedWheelTimer$HashedWheelBucketArray.length; ++i) {
            hashedWheelTimer$HashedWheelBucketArray[i] = new HashedWheelTimer$HashedWheelBucket(null);
        }
        return hashedWheelTimer$HashedWheelBucketArray;
    }

    public void start() {
        switch (WORKER_STATE_UPDATER.get(this)) {
            case 0: {
                if (!WORKER_STATE_UPDATER.compareAndSet(this, 0, 1)) break;
                this.workerThread.start();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("cannot be started once stopped");
            }
            default: {
                throw new Error("Invalid WorkerState");
            }
        }
        while (this.startTime == 0L) {
            try {
                this.startTimeInitialized.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public Set<Timeout> stop() {
        boolean bl;
        if (Thread.currentThread() == this.workerThread) {
            throw new IllegalStateException(HashedWheelTimer.class.getSimpleName() + ".stop() cannot be called from " + TimerTask.class.getSimpleName());
        }
        if (!WORKER_STATE_UPDATER.compareAndSet(this, 1, 2)) {
            if (WORKER_STATE_UPDATER.getAndSet(this, 2) != 2) {
                INSTANCE_COUNTER.decrementAndGet();
                if (this.leak != null) {
                    boolean bl2 = this.leak.close(this);
                    assert (bl2);
                }
            }
            return Collections.emptySet();
        }
        try {
            bl = false;
            while (this.workerThread.isAlive()) {
                this.workerThread.interrupt();
                try {
                    this.workerThread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            INSTANCE_COUNTER.decrementAndGet();
            if (this.leak != null) {
                bl = this.leak.close(this);
                assert (bl);
            }
        }
        Set<Timeout> set = this.worker.unprocessedTimeouts();
        HashSet<Timeout> hashSet = new HashSet<Timeout>(set.size());
        for (Timeout timeout : set) {
            if (!timeout.cancel()) continue;
            hashSet.add(timeout);
        }
        return hashSet;
    }

    @Override
    public Timeout newTimeout(TimerTask timerTask, long l, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(timerTask, "task");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        long l2 = this.pendingTimeouts.incrementAndGet();
        if (this.maxPendingTimeouts > 0L && l2 > this.maxPendingTimeouts) {
            this.pendingTimeouts.decrementAndGet();
            throw new RejectedExecutionException("Number of pending timeouts (" + l2 + ") is greater than or equal to maximum allowed pending timeouts (" + this.maxPendingTimeouts + ")");
        }
        this.start();
        long l3 = System.nanoTime() + timeUnit.toNanos(l) - this.startTime;
        if (l > 0L && l3 < 0L) {
            l3 = Long.MAX_VALUE;
        }
        HashedWheelTimer$HashedWheelTimeout hashedWheelTimer$HashedWheelTimeout = new HashedWheelTimer$HashedWheelTimeout(this, timerTask, l3);
        this.timeouts.add(hashedWheelTimer$HashedWheelTimeout);
        return hashedWheelTimer$HashedWheelTimeout;
    }

    public long pendingTimeouts() {
        return this.pendingTimeouts.get();
    }

    private static void reportTooManyInstances() {
        if (logger.isErrorEnabled()) {
            String string = StringUtil.simpleClassName(HashedWheelTimer.class);
            logger.error("You are creating too many " + string + " instances. " + string + " is a shared resource that must be reused across the JVM, so that only a few instances are created.");
        }
    }

    static /* synthetic */ long access$202(HashedWheelTimer hashedWheelTimer, long l) {
        hashedWheelTimer.startTime = l;
        return hashedWheelTimer.startTime;
    }

    static /* synthetic */ long access$200(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.startTime;
    }

    static /* synthetic */ CountDownLatch access$300(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.startTimeInitialized;
    }

    static /* synthetic */ int access$400(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.mask;
    }

    static /* synthetic */ HashedWheelTimer$HashedWheelBucket[] access$500(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.wheel;
    }

    static /* synthetic */ AtomicIntegerFieldUpdater access$600() {
        return WORKER_STATE_UPDATER;
    }

    static /* synthetic */ Queue access$700(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.timeouts;
    }

    static /* synthetic */ long access$900(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.tickDuration;
    }

    static /* synthetic */ Queue access$1000(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.cancelledTimeouts;
    }

    static /* synthetic */ AtomicLong access$1100(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.pendingTimeouts;
    }

    static /* synthetic */ Executor access$1200(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.taskExecutor;
    }
}

