/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal;

import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.internal.ObjectPool;
import pro.gravit.repackage.io.netty.util.internal.ObjectPool$Handle;
import pro.gravit.repackage.io.netty.util.internal.PendingWrite$1;

public final class PendingWrite {
    private static final ObjectPool<PendingWrite> RECYCLER = ObjectPool.newPool(new PendingWrite$1());
    private final ObjectPool$Handle<PendingWrite> handle;
    private Object msg;
    private Promise<Void> promise;

    public static PendingWrite newInstance(Object object, Promise<Void> promise) {
        PendingWrite pendingWrite = RECYCLER.get();
        pendingWrite.msg = object;
        pendingWrite.promise = promise;
        return pendingWrite;
    }

    private PendingWrite(ObjectPool$Handle<PendingWrite> objectPool$Handle) {
        this.handle = objectPool$Handle;
    }

    public boolean recycle() {
        this.msg = null;
        this.promise = null;
        this.handle.recycle(this);
        return true;
    }

    public boolean failAndRecycle(Throwable throwable) {
        ReferenceCountUtil.release(this.msg);
        if (this.promise != null) {
            this.promise.setFailure(throwable);
        }
        return this.recycle();
    }

    public boolean successAndRecycle() {
        if (this.promise != null) {
            this.promise.setSuccess(null);
        }
        return this.recycle();
    }

    public Object msg() {
        return this.msg;
    }

    public Promise<Void> promise() {
        return this.promise;
    }

    public Promise<Void> recycleAndGet() {
        Promise<Void> promise = this.promise;
        this.recycle();
        return promise;
    }

    /* synthetic */ PendingWrite(ObjectPool$Handle objectPool$Handle, PendingWrite$1 var2_2) {
        this(objectPool$Handle);
    }
}

