/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.init;

import com.phylogeny.extrabitmanipulation.armor.ChiseledArmorStackHandeler;
import com.phylogeny.extrabitmanipulation.armor.LayerChiseledArmor;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.reference.CustomNPCsReferences;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPC64x32;

public class RenderLayersExtraBitManipulation {
    private static List<LayerChiseledArmor> armorLayers = new ArrayList<LayerChiseledArmor>();
    private static List<LayerChiseledArmor> armorLayersMob = new ArrayList<LayerChiseledArmor>();
    private static List<LayerChiseledArmor> armorLayersPlayer = new ArrayList<LayerChiseledArmor>();
    private static boolean layersInitializedPlayerCNPC;

    public static void initLayers() {
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityArmorStand.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityVillager.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityZombieVillager.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityZombie.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityGiantZombie.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityPigZombie.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntitySkeleton.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityWitherSkeleton.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityHusk.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityStray.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityVex.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityVindicator.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityEvoker.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityIllusionIllager.class);
        armorLayers.addAll(armorLayersMob);
        for (RenderPlayer renderPlayer : ClientHelper.getRenderManager().getSkinMap().values()) {
            LayerChiseledArmor layer = new LayerChiseledArmor((RenderLivingBase<? extends EntityLivingBase>)renderPlayer);
            renderPlayer.func_177094_a((LayerRenderer)layer);
            armorLayersPlayer.add(layer);
        }
        armorLayers.addAll(armorLayersPlayer);
        if (CustomNPCsReferences.isLoaded) {
            MinecraftForge.EVENT_BUS.register((Object)new RenderLayersExtraBitManipulation());
        }
    }

    @SubscribeEvent
    public void initLayersCNPCs(RenderLivingEvent.Pre<EntityCustomNpc> event) {
        if (layersInitializedPlayerCNPC) {
            return;
        }
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityCustomNpc.class);
        RenderLayersExtraBitManipulation.addLayerChiseledArmorToEntityRender(EntityNPC64x32.class);
        layersInitializedPlayerCNPC = true;
    }

    private static <T extends EntityLivingBase> void addLayerChiseledArmorToEntityRender(Class<? extends Entity> entityClass) {
        Render renderer = ClientHelper.getRenderManager().func_78715_a(entityClass);
        LayerChiseledArmor layer = new LayerChiseledArmor((RenderLivingBase<? extends EntityLivingBase>)((RenderLivingBase)renderer));
        ((RenderLivingBase)renderer).func_177094_a((LayerRenderer)layer);
        armorLayersMob.add(layer);
    }

    public static void clearRenderMaps() {
        ChiseledArmorStackHandeler.clearModelMap();
        for (LayerChiseledArmor layer : armorLayers) {
            layer.clearDisplayListsMap();
        }
    }

    public static void removeFromRenderMaps(NBTTagCompound nbt) {
        ChiseledArmorStackHandeler.removeFromModelMap(nbt);
        for (LayerChiseledArmor layer : armorLayers) {
            layer.removeFromDisplayListsMap(nbt);
        }
    }

    public static void forceUpdateModels(boolean isPlayerModel) {
        for (LayerChiseledArmor layer : isPlayerModel ? armorLayersPlayer : armorLayersMob) {
            layer.updateModelAndRenderers(true);
        }
    }
}

