/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.shape;

import com.phylogeny.extrabitmanipulation.shape.Shape;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class AsymmetricalShape
extends Shape {
    protected float a;
    protected float b;
    protected float c;
    protected float aInset;
    protected float bInset;
    protected float cInset;
    protected boolean isEquilateral;

    public void init(float centerX, float centerY, float centerZ, float a, float b, float c, int direction, boolean sculptHollowShape, float wallThickness, boolean openEnds) {
        this.init(centerX, centerY, centerZ, direction, sculptHollowShape, wallThickness, openEnds);
        if (this.direction > 1) {
            if (this.direction > 3) {
                float v = a;
                a = b;
                b = v;
            } else {
                float v = c;
                c = b;
                b = v;
            }
        }
        this.a = a;
        this.b = b;
        this.c = c;
        this.aInset = this.reduceLength(this.a);
        this.bInset = this.reduceLength(this.b);
        this.cInset = this.reduceLength(this.c);
    }

    public void setEquilateral(boolean isEquilateral) {
        this.isEquilateral = isEquilateral;
    }

    @Override
    protected AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB((double)(this.centerX - this.a), (double)(this.centerY - this.b), (double)(this.centerZ - this.c), (double)(this.centerX + this.a), (double)(this.centerY + this.b), (double)(this.centerZ + this.c));
    }

    protected boolean isPointInEllipse(float dv1, float dv2, float s1, float s2) {
        float v1 = dv1 / s1;
        float v2 = dv2 / s2;
        return v1 * v1 + v2 * v2 <= 1.0f;
    }
}

