/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading;

import cam72cam.mod.config.ConfigFile;

@ConfigFile.Comment(value="Configuration File")
@ConfigFile.Name(value="general")
@ConfigFile.File(value="immersiverailroading_sound.cfg")
public class ConfigSound {
    @ConfigFile.Comment(value="Sound Distance Multiplier")
    @ConfigFile.Range(min=0.25, max=10.0)
    public static double soundDistanceScale = 1.0;
    @ConfigFile.Comment(value="Scales sound emitted by rolling stock to the gauge they are on.  Requres restart.")
    public static boolean scaleSoundToGauge = true;
    @ConfigFile.Comment(value="Re-configure the sound system to use more audo channels (fixes audio cutting out at high speed).  Disabled with a value less than 32")
    public static int customAudioChannels = 128;

    @ConfigFile.Name(value="Categories")
    public static class SoundCategories {
        @ConfigFile.Name(value="Immersive Railroading")
        @ConfigFile.Range(min=0.0, max=100.0)
        public static int immersive_railroading = 100;
        @ConfigFile.Name(value="Controls")
        @ConfigFile.Range(min=0.0, max=100.0)
        public static int controls = 100;
        @ConfigFile.Name(value="Animations")
        @ConfigFile.Range(min=0.0, max=100.0)
        public static int animations = 100;
        @ConfigFile.Name(value="Villager Whistle")
        @ConfigFile.Range(min=0.0, max=100.0)
        public static int passenger_whistle = 100;

        public static float controls() {
            return (float)immersive_railroading / 100.0f * (float)controls / 100.0f;
        }

        public static float animations() {
            return (float)immersive_railroading / 100.0f * (float)animations / 100.0f;
        }

        public static float passenger_whistle() {
            return (float)immersive_railroading / 100.0f * (float)passenger_whistle / 100.0f;
        }

        @ConfigFile.Name(value="Machines")
        public static class Machines {
            @ConfigFile.Name(value="Category Machines")
            @ConfigFile.Range(min=0.0, max=100.0)
            public static int machine_category = 100;

            public static float category() {
                return (float)immersive_railroading / 100.0f * (float)machine_category / 100.0f;
            }
        }

        @ConfigFile.Name(value="Locomotive")
        public static class Locomotive {
            @ConfigFile.Name(value="Category Locomotive")
            @ConfigFile.Range(min=0.0, max=100.0)
            public static int category = 100;
            @ConfigFile.Name(value="Bell")
            @ConfigFile.Range(min=0.0, max=100.0)
            public static int bell = 100;

            public static float bell() {
                return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)bell / 100.0f;
            }

            public static class Diesel {
                @ConfigFile.Name(value="Category Diesel Locomotive")
                @ConfigFile.Range(min=0.0, max=100.0)
                public static int diesel_category = 100;
                @ConfigFile.Name(value="Idle")
                @ConfigFile.Range(min=0.0, max=100.0)
                public static int idle = 100;
                @ConfigFile.Name(value="Horn")
                @ConfigFile.Range(min=0.0, max=100.0)
                public static int horn = 100;
                @ConfigFile.Name(value="Running")
                @ConfigFile.Range(min=0.0, max=100.0)
                public static int running = 100;

                public static float idle() {
                    return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)diesel_category / 100.0f * (float)idle / 100.0f;
                }

                public static float horn() {
                    return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)diesel_category / 100.0f * (float)horn / 100.0f;
                }

                public static float running() {
                    return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)diesel_category / 100.0f * (float)running / 100.0f;
                }
            }

            @ConfigFile.Name(value="Steam")
            public static class Steam {
                @ConfigFile.Name(value="Category Steam Locomotive")
                @ConfigFile.Range(min=0.0, max=100.0)
                public static int steam_category = 100;
                @ConfigFile.Name(value="Idle")
                @ConfigFile.Range(min=0.0, max=100.0)
                public static int idle = 100;
                @ConfigFile.Name(value="Pressure Valve")
                @ConfigFile.Range(min=0.0, max=100.0)
                public static int pressureValve = 100;
                @ConfigFile.Name(value="Chuff")
                @ConfigFile.Range(min=0.0, max=100.0)
                public static int chuff = 100;
                @ConfigFile.Name(value="Cylinder Drain")
                @ConfigFile.Range(min=0.0, max=100.0)
                public static int cylinder_drain = 100;
                @ConfigFile.Name(value="Whistle")
                @ConfigFile.Range(min=0.0, max=100.0)
                public static int whistle = 100;

                public static float idle() {
                    return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)steam_category / 100.0f * (float)idle / 100.0f;
                }

                public static float pressureValve() {
                    return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)steam_category / 100.0f * (float)pressureValve / 100.0f;
                }

                public static float chuff() {
                    return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)steam_category / 100.0f * (float)chuff / 100.0f;
                }

                public static float cylinder_drain() {
                    return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)steam_category / 100.0f * (float)cylinder_drain / 100.0f;
                }

                public static float whistle() {
                    return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)steam_category / 100.0f * (float)whistle / 100.0f;
                }
            }
        }

        @ConfigFile.Name(value="Rolling Stock")
        public static class RollingStock {
            @ConfigFile.Name(value="Category Rolling Stock")
            @ConfigFile.Range(min=0.0, max=100.0)
            public static int category = 100;
            @ConfigFile.Name(value="Wheel")
            @ConfigFile.Range(min=0.0, max=100.0)
            public static int wheel = 100;
            @ConfigFile.Name(value="Sliding")
            @ConfigFile.Range(min=0.0, max=100.0)
            public static int sliding = 100;
            @ConfigFile.Name(value="Flange")
            @ConfigFile.Range(min=0.0, max=100.0)
            public static int flange = 100;
            @ConfigFile.Name(value="Clack")
            @ConfigFile.Range(min=0.0, max=100.0)
            public static int clack = 100;
            @ConfigFile.Name(value="Couple")
            @ConfigFile.Range(min=0.0, max=100.0)
            public static int couple = 100;
            @ConfigFile.Name(value="Collision")
            @ConfigFile.Range(min=0.0, max=100.0)
            public static int collision = 100;

            public static float wheel() {
                return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)wheel / 100.0f;
            }

            public static float sliding() {
                return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)sliding / 100.0f;
            }

            public static float flange() {
                return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)flange / 100.0f;
            }

            public static float clack() {
                return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)clack / 100.0f;
            }

            public static float couple() {
                return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)couple / 100.0f;
            }

            public static float collision() {
                return (float)immersive_railroading / 100.0f * (float)category / 100.0f * (float)collision / 100.0f;
            }
        }
    }
}

