/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.items.ItemPlate;
import cam72cam.immersiverailroading.items.ItemRollingStock;
import cam72cam.immersiverailroading.items.ItemRollingStockComponent;
import cam72cam.immersiverailroading.library.AssemblyStep;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.net.BuildableStockSyncPacket;
import cam72cam.mod.entity.DamageType;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.custom.IWorldData;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.text.PlayerMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EntityBuildableRollingStock
extends EntityRollingStock
implements IWorldData {
    @TagField(value="isBuilt")
    private boolean isBuilt = false;
    @TagField(value="builtItems", typeHint=ItemComponentType.class)
    private List<ItemComponentType> builtItems = new ArrayList<ItemComponentType>();

    public void setComponents(List<ItemComponentType> items) {
        this.builtItems = new ArrayList<ItemComponentType>(items);
        this.isBuilt = false;
        this.isBuilt = this.getMissingItemComponents().isEmpty();
        if (this.getWorld().isServer) {
            new BuildableStockSyncPacket(this).sendToObserving((Entity)this);
        }
        if (this.isBuilt()) {
            this.onAssemble();
        } else {
            this.onDissassemble();
        }
        if (this instanceof EntityMoveableRollingStock) {
            ((EntityMoveableRollingStock)this).clearHeightMap();
        }
    }

    public List<ItemComponentType> getItemComponents() {
        return this.builtItems;
    }

    public boolean isBuilt() {
        return this.isBuilt;
    }

    public boolean areWheelsBuilt() {
        if (this.isBuilt) {
            return true;
        }
        for (ItemComponentType item : this.getMissingItemComponents()) {
            if (!item.isWheelPart()) continue;
            return false;
        }
        return true;
    }

    public List<ItemComponentType> getMissingItemComponents() {
        ArrayList<ItemComponentType> missing = new ArrayList<ItemComponentType>();
        if (this.isBuilt) {
            return missing;
        }
        missing.addAll(this.getDefinition().getItemComponents());
        for (ItemComponentType item : this.getItemComponents()) {
            missing.remove((Object)item);
        }
        return missing;
    }

    public void addComponent(ItemComponentType item) {
        this.builtItems.add(item);
        this.isBuilt = this.getMissingItemComponents().isEmpty();
        if (this.isBuilt) {
            this.onAssemble();
        }
        if (this instanceof EntityMoveableRollingStock) {
            ((EntityMoveableRollingStock)this).clearHeightMap();
        }
        new BuildableStockSyncPacket(this).sendToObserving((Entity)this);
    }

    public void addNextComponent(Player player) {
        if (this.isBuilt()) {
            player.sendMessage(ChatText.STOCK_BUILT.getMessage(this.getDefinition().name()));
            return;
        }
        ArrayList<ItemComponentType> toAdd = new ArrayList<ItemComponentType>();
        for (AssemblyStep step : AssemblyStep.values()) {
            for (ItemComponentType component : this.getMissingItemComponents()) {
                if (component.step != step) continue;
                toAdd.add(component);
            }
            if (toAdd.size() != 0) break;
        }
        for (int i = 0; i < player.getInventory().getSlotCount(); ++i) {
            ItemStack found = player.getInventory().get(i);
            if (!found.is((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT)) continue;
            ItemRollingStockComponent.Data data = new ItemRollingStockComponent.Data(found);
            if (!data.def.equals(this.getDefinition()) || !player.isCreative() && data.gauge != this.gauge || data.requiresHammering() || !toAdd.contains((Object)data.componentType)) continue;
            this.addComponent(data.componentType);
            player.getInventory().extract(i, 1, false);
            return;
        }
        int largePlates = 0;
        int mediumPlates = 0;
        int smallPlates = 0;
        int wood = 0;
        for (int i = 0; i < player.getInventory().getSlotCount(); ++i) {
            ItemStack found = player.getInventory().get(i);
            if (found.is((CustomItem)IRItems.ITEM_PLATE)) {
                ItemPlate.Data data = new ItemPlate.Data(found);
                if (data.gauge == this.gauge) {
                    switch (data.type) {
                        case LARGE: {
                            largePlates += found.getCount();
                            break;
                        }
                        case MEDIUM: {
                            mediumPlates += found.getCount();
                            break;
                        }
                        case SMALL: {
                            smallPlates += found.getCount();
                            break;
                        }
                    }
                }
            }
            if (!found.is(Fuzzy.WOOD_PLANK)) continue;
            wood += found.getCount();
        }
        for (ItemComponentType type : toAdd) {
            ItemStack itemUsed;
            ItemStack found;
            int woodUsed;
            if (!type.isWooden(this.getDefinition()) || wood < (woodUsed = type.getWoodCost(this.gauge, this.getDefinition()))) continue;
            for (int i = 0; !(i >= player.getInventory().getSlotCount() || (found = player.getInventory().get(i)).is(Fuzzy.WOOD_PLANK) && (woodUsed -= (itemUsed = player.getInventory().extract(i, woodUsed, false)).getCount()) <= 0); ++i) {
            }
            this.addComponent(type);
        }
        block20: for (ItemComponentType type : toAdd) {
            if (type.isWooden(this.getDefinition())) continue;
            int platesStart = 0;
            int platesUsed = 0;
            switch (type.crafting) {
                case PLATE_LARGE: {
                    platesStart = largePlates;
                    break;
                }
                case PLATE_MEDIUM: {
                    platesStart = mediumPlates;
                    break;
                }
                case PLATE_SMALL: {
                    platesStart = smallPlates;
                    break;
                }
                default: {
                    continue block20;
                }
            }
            platesUsed = type.getPlateCost(this.gauge, this.getDefinition());
            if (platesStart < platesUsed) continue;
            for (int i = 0; i < player.getInventory().getSlotCount(); ++i) {
                ItemStack itemUsed;
                ItemStack found = player.getInventory().get(i);
                if (!found.is((CustomItem)IRItems.ITEM_PLATE)) continue;
                ItemPlate.Data data = new ItemPlate.Data(found);
                if (data.gauge == this.gauge && data.type == type.getPlateType() && (platesUsed -= (itemUsed = player.getInventory().extract(i, platesUsed, false)).getCount()) <= 0) break;
            }
            this.addComponent(type);
            return;
        }
        HashMap<ItemComponentType, Integer> addMap = new HashMap<ItemComponentType, Integer>();
        for (ItemComponentType component : toAdd) {
            if (!addMap.containsKey((Object)component)) {
                addMap.put(component, 0);
            }
            addMap.put(component, (Integer)addMap.get((Object)component) + 1);
        }
        player.sendMessage(ChatText.STOCK_MISSING.getMessage(""));
        for (ItemComponentType component : addMap.keySet()) {
            String str = String.format("%d x %s", new Object[]{addMap.get((Object)component), component});
            if (!component.isWooden(this.getDefinition())) {
                switch (component.crafting) {
                    case CASTING: 
                    case CASTING_HAMMER: 
                    case PLATE_BOILER: {
                        str = str + String.format(" (%s)", component.crafting.toString());
                        break;
                    }
                    case PLATE_LARGE: 
                    case PLATE_MEDIUM: 
                    case PLATE_SMALL: {
                        str = str + String.format(" (%d x %s)", new Object[]{component.getPlateCost(this.gauge, this.getDefinition()) * (Integer)addMap.get((Object)component), component.getPlateType()});
                        break;
                    }
                }
            } else {
                str = str + String.format(" (%d x %s)", component.getWoodCost(this.gauge, this.getDefinition()), ChatText.WOOD_PLANKS.toString());
            }
            player.sendMessage(PlayerMessage.direct((String)str));
        }
    }

    public ItemComponentType removeNextComponent(Player player) {
        if (this.isBuilt) {
            this.onDissassemble();
        }
        this.isBuilt = false;
        if (this.builtItems.size() <= 1) {
            player.sendMessage(ChatText.STOCK_DISSASEMBLED.getMessage(this.getDefinition().name()));
            return null;
        }
        ItemComponentType toRemove = null;
        for (AssemblyStep step : AssemblyStep.reverse()) {
            for (ItemComponentType component : this.builtItems) {
                if (component == ItemComponentType.FRAME || component.step != step) continue;
                toRemove = component;
                break;
            }
            if (toRemove != null) break;
        }
        this.builtItems.remove((Object)toRemove);
        new BuildableStockSyncPacket(this).sendToObserving((Entity)this);
        ItemStack item = new ItemStack((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT, 1);
        ItemRollingStockComponent.Data data = new ItemRollingStockComponent.Data(item);
        data.def = this.getDefinition();
        data.gauge = this.gauge;
        data.componentType = toRemove;
        data.write();
        this.getWorld().dropItem(item, player.getBlockPosition());
        if (this instanceof EntityMoveableRollingStock) {
            ((EntityMoveableRollingStock)this).clearHeightMap();
        }
        return toRemove;
    }

    @Override
    public ClickResult onClick(Player player, Player.Hand hand) {
        ClickResult clickRes = super.onClick(player, hand);
        if (clickRes != ClickResult.PASS) {
            return clickRes;
        }
        if (this.getWorld().isServer && !player.hasPermission(Permissions.STOCK_ASSEMBLY)) {
            return ClickResult.PASS;
        }
        if (player.getHeldItem(hand).is((CustomItem)IRItems.ITEM_LARGE_WRENCH) || player.getHeldItem(hand).is((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT)) {
            if (this.getWorld().isServer) {
                if (!player.isCrouching()) {
                    this.addNextComponent(player);
                } else {
                    this.removeNextComponent(player);
                }
            }
            return ClickResult.ACCEPTED;
        }
        return ClickResult.PASS;
    }

    public void load(TagCompound tag) {
        this.onAssemble();
    }

    public void save(TagCompound data) {
    }

    @Override
    public void onDamage(DamageType type, Entity source, float amount, boolean bypassArmor) {
        super.onDamage(type, source, amount, bypassArmor);
        if (this.isDead() && this.getWorld().isServer) {
            this.onDissassemble();
        }
        if (this.isDead() && this.shouldDropItems(type, amount)) {
            if (this.isBuilt) {
                ItemStack item = new ItemStack((CustomItem)IRItems.ITEM_ROLLING_STOCK, 1);
                ItemRollingStock.Data data = new ItemRollingStock.Data(item);
                data.def = this.getDefinition();
                data.gauge = this.gauge;
                data.texture = this.getTexture();
                data.write();
                this.getWorld().dropItem(item, source != null ? source.getBlockPosition() : this.getBlockPosition());
            } else {
                for (ItemComponentType component : this.builtItems) {
                    ItemStack item = new ItemStack((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT, 1);
                    ItemRollingStockComponent.Data data = new ItemRollingStockComponent.Data(item);
                    data.def = this.getDefinition();
                    data.gauge = this.gauge;
                    data.componentType = component;
                    data.write();
                    System.out.println((Object)component);
                    System.out.println(item.getTagCompound());
                    this.getWorld().dropItem(item, source != null ? source.getBlockPosition() : this.getBlockPosition());
                }
            }
        }
    }

    public void onAssemble() {
    }

    public void onDissassemble() {
    }
}

