/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.inventory.FilteredStackHandler;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.registry.FreightDefinition;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Living;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.serialization.TagField;
import java.util.List;

public abstract class Freight
extends EntityCoupleableRollingStock {
    @TagField(value="items")
    public FilteredStackHandler cargoItems = new FilteredStackHandler(0);
    @TagSync
    @TagField(value="CARGO_ITEMS")
    private int itemCount = 0;
    @TagSync
    @TagField(value="PERCENT_FULL")
    private int percentFull = 0;

    public abstract int getInventorySize();

    public abstract int getInventoryWidth();

    @Override
    public FreightDefinition getDefinition() {
        return this.getDefinition(FreightDefinition.class);
    }

    @Override
    public void onAssemble() {
        super.onAssemble();
        List extras = this.cargoItems.setSize(this.getInventorySize());
        if (this.getWorld().isServer) {
            extras.forEach(stack -> this.getWorld().dropItem(stack, this.getPosition()));
            this.cargoItems.onChanged(slot -> this.handleMass());
            this.handleMass();
        }
        this.initContainerFilter();
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        if (this.getWorld().isServer) {
            for (int i = 0; i < this.cargoItems.getSlotCount(); ++i) {
                ItemStack stack = this.cargoItems.get(i);
                if (stack.isEmpty()) continue;
                this.getWorld().dropItem(stack.copy(), this.getPosition());
                stack.setCount(0);
                this.cargoItems.set(i, stack);
            }
        }
    }

    @Override
    public ClickResult onClick(Player player, Player.Hand hand) {
        ClickResult clickRes = super.onClick(player, hand);
        if (clickRes != ClickResult.PASS) {
            return clickRes;
        }
        if (!this.isBuilt()) {
            return ClickResult.PASS;
        }
        if (this.getDefinition().acceptsLivestock()) {
            List leashed = this.getWorld().getEntities(e -> e.getPosition().distanceTo(player.getPosition()) < 16.0 && e.isLeashedTo(player), Living.class);
            if (this.getWorld().isClient && !leashed.isEmpty()) {
                return ClickResult.ACCEPTED;
            }
            if (player.hasPermission(Permissions.BOARD_WITH_LEAD)) {
                for (Living entity : leashed) {
                    if (!this.canFitPassenger((Entity)entity)) continue;
                    entity.unleash(player);
                    this.addPassenger((Entity)entity);
                    return ClickResult.ACCEPTED;
                }
            }
            if (player.getHeldItem(hand).is(Fuzzy.LEAD)) {
                for (Entity passenger : this.getPassengers()) {
                    Living living;
                    if (!(passenger instanceof Living) || passenger.isVillager()) continue;
                    if (this.getWorld().isServer && (living = (Living)passenger).canBeLeashedTo(player)) {
                        this.removePassenger((Entity)living);
                        living.setLeashHolder(player);
                        player.getHeldItem(hand).shrink(1);
                    }
                    return ClickResult.ACCEPTED;
                }
            }
        }
        if ((player.getHeldItem(hand).isEmpty() || player.getRiding() != this) && (this.getWorld().isClient || this.openGui(player))) {
            return ClickResult.ACCEPTED;
        }
        return ClickResult.PASS;
    }

    protected boolean openGui(Player player) {
        if (this.getInventorySize() == 0) {
            return false;
        }
        if (player.hasPermission(Permissions.FREIGHT_INVENTORY)) {
            GuiTypes.FREIGHT.open(player, (Entity)this);
        }
        return true;
    }

    protected void handleMass() {
        int itemInsideCount = 0;
        int stacksWithStuff = 0;
        for (int slot = 0; slot < this.cargoItems.getSlotCount(); ++slot) {
            itemInsideCount += this.cargoItems.get(slot).getCount();
            if (this.cargoItems.get(slot).getCount() == 0) continue;
            ++stacksWithStuff;
        }
        this.itemCount = itemInsideCount;
        this.percentFull = this.getInventorySize() > 0 ? stacksWithStuff * 100 / this.getInventorySize() : 100;
    }

    public int getPercentCargoFull() {
        return this.percentFull;
    }

    protected void initContainerFilter() {
    }

    @Override
    public double getWeight() {
        double fLoad = Config.ConfigBalance.blockWeight * this.itemCount;
        return fLoad += super.getWeight();
    }

    @Override
    public double getMaxWeight() {
        return super.getMaxWeight() + (double)(Config.ConfigBalance.blockWeight * this.getInventorySize() * 64);
    }
}

