/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.physics.SimulationState;
import cam72cam.immersiverailroading.items.ItemRadioCtrlCard;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.library.PhysicalMaterials;
import cam72cam.immersiverailroading.model.part.Control;
import cam72cam.immersiverailroading.physics.MovementTrack;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.thirdparty.trackapi.ITrack;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.serialization.StrictTagMapper;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.world.World;
import java.util.OptionalDouble;
import java.util.UUID;

public abstract class Locomotive
extends FreightTank {
    private static final float throttleDelta = 0.04f;
    private static final float trainBrakeNotch = 0.04f;
    @TagField(value="deadMansSwitch")
    private boolean deadMansSwitch;
    private int deadManChangeTimeout;
    @TagSync
    @TagField(value="THROTTLE")
    private float throttle = 0.0f;
    @TagSync
    @TagField(value="REVERSER")
    private float reverser = 0.0f;
    @TagSync
    @TagField(value="AIR_BRAKE")
    private float trainBrake = 0.0f;
    @TagSync
    @TagField(value="HORN")
    protected int hornTime = 0;
    @TagSync
    @TagField(value="HORN_PLAYER", mapper=StrictTagMapper.class)
    protected UUID hornPlayer = null;
    @TagSync
    @TagField(value="HORN_PULL")
    public float hornPull;
    @TagSync
    @TagField(value="BELL")
    private int bellTime = 0;
    private boolean bellControl = false;
    private int bellKeyTimeout;
    @TagSync
    @TagField(value="cogging")
    private boolean cogging = false;
    protected boolean slipping = false;

    @Override
    public LocomotiveDefinition getDefinition() {
        return super.getDefinition(LocomotiveDefinition.class);
    }

    @Override
    public boolean openGui(Player player) {
        return false;
    }

    @Override
    public void handleKeyPress(Player source, KeyTypes key, boolean disableIndependentThrottle) {
        if (disableIndependentThrottle) {
            switch (key) {
                case THROTTLE_UP: {
                    key = KeyTypes.REVERSER_UP;
                    break;
                }
                case THROTTLE_ZERO: {
                    key = KeyTypes.REVERSER_ZERO;
                    break;
                }
                case THROTTLE_DOWN: {
                    key = KeyTypes.REVERSER_DOWN;
                    break;
                }
                case REVERSER_UP: 
                case REVERSER_ZERO: 
                case REVERSER_DOWN: {
                    return;
                }
            }
        } else if (this.getDefinition().isLinkedBrakeThrottle()) {
            switch (key) {
                case THROTTLE_UP: {
                    if (!(this.getTrainBrake() > 0.0f)) break;
                    key = KeyTypes.TRAIN_BRAKE_DOWN;
                    break;
                }
                case THROTTLE_ZERO: {
                    this.setTrainBrake(0.0f);
                    break;
                }
                case THROTTLE_DOWN: {
                    if (this.getThrottle() != 0.0f) break;
                    key = KeyTypes.TRAIN_BRAKE_UP;
                    break;
                }
                case TRAIN_BRAKE_UP: 
                case TRAIN_BRAKE_ZERO: 
                case TRAIN_BRAKE_DOWN: {
                    return;
                }
            }
        }
        boolean linkThrottleReverser = this.forceLinkThrottleReverser() || disableIndependentThrottle;
        switch (key) {
            case HORN: {
                this.setHorn(10, source.getUUID());
                break;
            }
            case BELL: {
                if (this.getDefinition().toggleBell) {
                    if (this.bellKeyTimeout != 0) break;
                    this.bellTime = this.bellTime != 0 ? 0 : 10;
                    this.bellKeyTimeout = 10;
                    break;
                }
                this.setBell(10);
                break;
            }
            case THROTTLE_UP: {
                this.setThrottle(this.getThrottle() + 0.04f);
                break;
            }
            case THROTTLE_ZERO: {
                this.setThrottle(0.0f);
                break;
            }
            case THROTTLE_DOWN: {
                this.setThrottle(this.getThrottle() - 0.04f);
                break;
            }
            case REVERSER_UP: {
                if (linkThrottleReverser) {
                    float mixed = this.getThrottle() * (float)(this.getReverser() >= 0.0f ? 1 : -1);
                    if (mixed < 0.0f) {
                        this.setRealThrottle(-mixed - 0.04f);
                        this.setReverser(-1.0f);
                        break;
                    }
                    this.setRealThrottle(mixed + 0.04f);
                    this.setReverser(1.0f);
                    break;
                }
                this.setReverser(this.getReverser() + this.getReverserDelta());
                break;
            }
            case REVERSER_ZERO: {
                if (linkThrottleReverser) {
                    this.setRealThrottle(0.0f);
                }
                this.setReverser(0.0f);
                break;
            }
            case REVERSER_DOWN: {
                if (linkThrottleReverser) {
                    float mixed = this.getThrottle() * (float)(this.getReverser() >= 0.0f ? 1 : -1);
                    if (mixed > 0.0f) {
                        this.setRealThrottle(mixed - 0.04f);
                        this.setReverser(1.0f);
                        break;
                    }
                    this.setRealThrottle(-mixed + 0.04f);
                    this.setReverser(-1.0f);
                    break;
                }
                this.setReverser(this.getReverser() - this.getReverserDelta());
                break;
            }
            case TRAIN_BRAKE_UP: {
                this.setTrainBrake(this.getTrainBrake() + 0.04f);
                break;
            }
            case TRAIN_BRAKE_ZERO: {
                this.setTrainBrake(0.0f);
                break;
            }
            case TRAIN_BRAKE_DOWN: {
                this.setTrainBrake(this.getTrainBrake() - 0.04f);
                break;
            }
            case DEAD_MANS_SWITCH: {
                if (this.deadManChangeTimeout != 0) break;
                boolean bl = this.deadMansSwitch = !this.deadMansSwitch;
                if (this.deadMansSwitch) {
                    source.sendMessage(ChatText.DEADMANS_SWITCH_ENABLED.getMessage(new Object[0]));
                } else {
                    source.sendMessage(ChatText.DEADMANS_SWITCH_DISABLED.getMessage(new Object[0]));
                }
                this.deadManChangeTimeout = 5;
                break;
            }
            default: {
                super.handleKeyPress(source, key, disableIndependentThrottle);
            }
        }
    }

    protected boolean forceLinkThrottleReverser() {
        return false;
    }

    protected float getReverserDelta() {
        return 0.04f;
    }

    @Override
    public void onDrag(Control<?> component, double newValue) {
        super.onDrag(component, newValue);
        switch (component.part.type) {
            case THROTTLE_X: {
                this.setThrottle(this.getControlPosition(component));
                break;
            }
            case TRAIN_BRAKE_X: {
                if (!this.getDefinition().isLinearBrakeControl()) break;
                this.setTrainBrake(this.getControlPosition(component));
                break;
            }
            case REVERSER_X: {
                this.setReverser((0.5f - this.getControlPosition(component)) * 2.0f);
                break;
            }
            case THROTTLE_BRAKE_X: {
                this.setTrainBrake(1.0f - this.getControlPosition(component) * 2.0f);
                this.setThrottle(this.getControlPosition(component) * 2.0f - 1.0f);
            }
        }
    }

    @Override
    public void onDragRelease(Control<?> control) {
        super.onDragRelease(control);
        if (!this.getDefinition().isLinearBrakeControl() && control.part.type == ModelComponentType.TRAIN_BRAKE_X) {
            this.setControlPosition(control, 0.5f);
        }
    }

    @Override
    protected float defaultControlPosition(Control<?> control) {
        switch (control.part.type) {
            case REVERSER_X: 
            case THROTTLE_BRAKE_X: {
                return 0.5f;
            }
            case TRAIN_BRAKE_X: {
                return this.getDefinition().isLinearBrakeControl() ? 0.0f : 0.5f;
            }
        }
        return super.defaultControlPosition(control);
    }

    @Override
    public boolean playerCanDrag(Player player, Control<?> control) {
        if (!super.playerCanDrag(player, control)) {
            return false;
        }
        switch (control.part.type) {
            case THROTTLE_X: 
            case TRAIN_BRAKE_X: 
            case REVERSER_X: 
            case THROTTLE_BRAKE_X: 
            case INDEPENDENT_BRAKE_X: 
            case BELL_CONTROL_X: 
            case WHISTLE_CONTROL_X: 
            case HORN_CONTROL_X: 
            case ENGINE_START_X: {
                return player.hasPermission(Permissions.LOCOMOTIVE_CONTROL);
            }
        }
        return true;
    }

    @Override
    public ClickResult onClick(Player player, Player.Hand hand) {
        if (player.getHeldItem(hand).is((CustomItem)IRItems.ITEM_RADIO_CONTROL_CARD) && player.hasPermission(Permissions.LOCOMOTIVE_CONTROL)) {
            if (this.getWorld().isClient) {
                return ClickResult.ACCEPTED;
            }
            if (this.gauge.isModel() || this.getDefinition().getRadioCapability() || !Config.ConfigBalance.RadioEquipmentRequired) {
                ItemRadioCtrlCard.Data data = new ItemRadioCtrlCard.Data(player.getHeldItem(hand));
                if (player.isCrouching()) {
                    player.sendMessage(data.linked == null ? ChatText.RADIO_NOLINK.getMessage(new Object[0]) : ChatText.RADIO_UNLINK.getMessage(new Object[0]));
                    data.linked = null;
                } else {
                    player.sendMessage(data.linked == null ? ChatText.RADIO_LINK.getMessage(new Object[0]) : ChatText.RADIO_RELINK.getMessage(new Object[0]));
                    data.linked = this.getUUID();
                }
                data.write();
            } else {
                player.sendMessage(ChatText.RADIO_CANT_LINK.getMessage(this.getDefinition().name()));
            }
            return ClickResult.ACCEPTED;
        }
        return super.onClick(player, hand);
    }

    @Override
    public boolean canFitPassenger(Entity passenger) {
        if (passenger instanceof Player && !((Player)passenger).hasPermission(Permissions.BOARD_LOCOMOTIVE)) {
            return false;
        }
        return super.canFitPassenger(passenger);
    }

    @Override
    public void onTick() {
        ITrack found;
        SimulationState state;
        super.onTick();
        if (this.getWorld().isServer) {
            OptionalDouble control;
            boolean hasDriver;
            this.sync.setInterval(5);
            for (Control<?> control2 : this.getDefinition().getModel().getControls()) {
                if (this.getDefinition().isLinearBrakeControl() || control2.part.type != ModelComponentType.TRAIN_BRAKE_X) continue;
                this.setTrainBrake(Math.max(0.0f, Math.min(1.0f, this.getTrainBrake() + (this.getControlPosition(control2) - 0.5f) / 8.0f)));
            }
            if (this.deadManChangeTimeout > 0) {
                --this.deadManChangeTimeout;
            }
            if (this.bellKeyTimeout > 0) {
                --this.bellKeyTimeout;
            }
            if (this.deadMansSwitch && !this.getCurrentSpeed().isZero() && !(hasDriver = this.getPassengers().stream().anyMatch(Entity::isPlayer))) {
                this.setThrottle(0.0f);
                this.setTrainBrake(1.0f);
            }
            if (this.hornTime > 0) {
                --this.hornTime;
            } else if (this.hornPlayer != null) {
                this.hornPlayer = null;
            }
            if (this.hornTime == 0) {
                this.hornPull = 0.0f;
            }
            if ((control = this.getDefinition().getModel().getControls().stream().filter(x -> x.part.type == ModelComponentType.BELL_CONTROL_X).mapToDouble(this::getControlPosition).max()).isPresent() && control.getAsDouble() > 0.0) {
                this.bellTime = 10;
                this.bellControl = true;
            }
            if (this.bellTime > 0 && (!this.getDefinition().toggleBell || this.bellControl)) {
                --this.bellTime;
                if (this.bellTime == 0) {
                    this.bellControl = false;
                }
            }
        }
        this.distanceTraveled += this.simulateWheelSlip();
        if (this.getWorld().isServer) {
            this.setControlPosition("REVERSERFORWARD", this.getReverser() > 0.0f ? 1.0f : 0.0f);
            this.setControlPosition("REVERSERNEUTRAL", this.getReverser() == 0.0f ? 1.0f : 0.0f);
            this.setControlPosition("REVERSERBACKWARD", this.getReverser() < 0.0f ? 1.0f : 0.0f);
        }
        if (this.getWorld().isServer && this.getDefinition().isCog() && this.getTickCount() % 20 == 0 && (state = this.getCurrentState()) != null && (found = MovementTrack.findTrack(this.getWorld(), state.couplerPositionFront, state.yaw, this.gauge.value())) instanceof TileRailBase) {
            TileRailBase onTrack = (TileRailBase)found;
            this.cogging = onTrack.isCog();
        }
    }

    public abstract double getAppliedTractiveEffort(Speed var1);

    protected final double getStaticTractiveEffort(Speed speed) {
        return (Config.ConfigBalance.FuelRequired ? this.getWeight() : this.getMaxWeight()) * 9.8 * (double)(this.slipping ? PhysicalMaterials.STEEL.kineticFriction(PhysicalMaterials.STEEL) / 2.0f : PhysicalMaterials.STEEL.staticFriction(PhysicalMaterials.STEEL)) * this.slipCoefficient(speed) * (4.0 / this.getDefinition().factorOfAdhesion()) * Config.ConfigBalance.tractionMultiplier;
    }

    protected double simulateWheelSlip() {
        if (this.cogging) {
            return 0.0;
        }
        double adhesionFactor = Math.abs(this.getAppliedTractiveEffort(this.getCurrentSpeed())) / this.getStaticTractiveEffort(this.getCurrentSpeed());
        boolean bl = this.slipping = adhesionFactor > 1.0;
        if (this.slipping) {
            return Math.copySign((adhesionFactor - 1.0) / 5.0, (double)this.getReverser());
        }
        return 0.0;
    }

    public double getTractiveEffortNewtons(Speed speed) {
        if (!this.isBuilt()) {
            return 0.0;
        }
        if (Math.abs(speed.minecraft()) > this.getDefinition().getMaxSpeed(this.gauge).minecraft()) {
            return 0.0;
        }
        double appliedTractiveEffort = this.getAppliedTractiveEffort(speed);
        if (!this.cogging && Math.abs(appliedTractiveEffort) > 0.0) {
            double staticTractiveEffort = this.getStaticTractiveEffort(speed);
            if (Math.abs(appliedTractiveEffort) > staticTractiveEffort) {
                double tractiveEffortNewtons = staticTractiveEffort / (double)PhysicalMaterials.STEEL.staticFriction(PhysicalMaterials.STEEL) * (double)PhysicalMaterials.STEEL.kineticFriction(PhysicalMaterials.STEEL);
                tractiveEffortNewtons *= staticTractiveEffort / tractiveEffortNewtons;
                return Math.copySign(tractiveEffortNewtons, appliedTractiveEffort);
            }
        }
        return appliedTractiveEffort;
    }

    @Override
    public double getBrakeSystemEfficiency() {
        if (this.cogging) {
            return 10.0;
        }
        return super.getBrakeSystemEfficiency();
    }

    @Override
    public double getBrakeAdhesionEfficiency() {
        if (this.cogging) {
            return 10.0;
        }
        return super.getBrakeAdhesionEfficiency();
    }

    private void copySettings(EntityRollingStock stock, boolean direction) {
        if (stock instanceof Locomotive && ((Locomotive)stock).getDefinition().muliUnitCapable) {
            ((Locomotive)stock).setRealThrottle(this.getThrottle());
            ((Locomotive)stock).setRealReverser(this.getReverser() * (float)(direction ? 1 : -1));
            ((Locomotive)stock).setRealTrainBrake(this.getTrainBrake());
            ((Locomotive)stock).setRealIndependentBrake(this.getIndependentBrake());
        }
    }

    public float getThrottle() {
        return this.throttle;
    }

    public void setThrottle(float newThrottle) {
        this.setRealThrottle(newThrottle);
        if (this.getDefinition().muliUnitCapable) {
            this.mapTrain(this, true, false, this::copySettings);
        }
    }

    private void setRealThrottle(float newThrottle) {
        newThrottle = Math.min(1.0f, Math.max(0.0f, newThrottle));
        if (this.getThrottle() != newThrottle) {
            this.setControlPositions(ModelComponentType.THROTTLE_X, newThrottle);
            this.throttle = newThrottle;
            this.setControlPositions(ModelComponentType.THROTTLE_BRAKE_X, this.getThrottle() / 2.0f + (1.0f - this.getTrainBrake()) / 2.0f);
        }
    }

    public float getReverser() {
        return this.reverser;
    }

    public void setReverser(float newReverser) {
        this.setRealReverser(newReverser);
        if (this.getDefinition().muliUnitCapable) {
            this.mapTrain(this, true, false, this::copySettings);
        }
    }

    private void setRealReverser(float newReverser) {
        newReverser = Math.min(1.0f, Math.max(-1.0f, newReverser));
        if (this.getReverser() != newReverser) {
            this.setControlPositions(ModelComponentType.REVERSER_X, newReverser / -2.0f + 0.5f);
            this.reverser = newReverser;
        }
    }

    public void setHorn(int val, UUID uuid) {
        if (uuid == null) {
            this.hornPull = 1.0f;
        }
        if (this.hornPlayer == null && uuid != null) {
            this.hornPlayer = uuid;
        }
        if (this.hornPlayer == null || this.hornPlayer.equals(uuid)) {
            this.hornTime = val;
        }
    }

    public void setHorn(int time, float value) {
        this.hornTime = time;
        this.hornPull = value;
    }

    public int getHornTime() {
        return this.hornTime;
    }

    public Entity getHornPlayer() {
        for (Entity pass : this.getPassengers()) {
            if (!pass.getUUID().equals(this.hornPlayer)) continue;
            return pass;
        }
        return null;
    }

    public float getHornPull() {
        if (this.getHornPlayer() != null) {
            return (this.getHornPlayer().getRotationPitch() + 90.0f) / 180.0f;
        }
        double control = this.getDefinition().getModel().getControls().stream().filter(x -> x.part.type == ModelComponentType.WHISTLE_CONTROL_X).mapToDouble(this::getControlPosition).max().orElse(0.0);
        return Math.max((float)control, this.hornPull);
    }

    @Deprecated
    public float getAirBrake() {
        return this.getTrainBrake();
    }

    public float getTrainBrake() {
        return this.trainBrake;
    }

    @Deprecated
    public void setAirBrake(float value) {
        this.setTrainBrake(value);
    }

    public void setTrainBrake(float newTrainBrake) {
        this.setRealTrainBrake(newTrainBrake);
        if (this.getDefinition().muliUnitCapable) {
            this.mapTrain(this, true, false, this::copySettings);
        }
    }

    private void setRealTrainBrake(float newTrainBrake) {
        newTrainBrake = Math.min(1.0f, Math.max(0.0f, newTrainBrake));
        if (this.getTrainBrake() != newTrainBrake) {
            if (this.getDefinition().isLinearBrakeControl()) {
                this.setControlPositions(ModelComponentType.TRAIN_BRAKE_X, newTrainBrake);
            }
            this.trainBrake = newTrainBrake;
            this.setControlPositions(ModelComponentType.THROTTLE_BRAKE_X, this.getThrottle() / 2.0f + (1.0f - this.getTrainBrake()) / 2.0f);
        }
    }

    @Override
    public void setIndependentBrake(float newIndependentBrake) {
        this.setRealIndependentBrake(newIndependentBrake);
        if (this.getDefinition().muliUnitCapable) {
            this.mapTrain(this, true, false, this::copySettings);
        }
    }

    private void setRealIndependentBrake(float newIndependentBrake) {
        super.setIndependentBrake(newIndependentBrake);
    }

    public int getBell() {
        return this.bellTime;
    }

    public void setBell(int newBell) {
        this.bellTime = newBell;
    }

    public double slipCoefficient(Speed speed) {
        double slipMult = 0.5;
        World world = this.getWorld();
        if (world.isPrecipitating() && world.canSeeSky(this.getBlockPosition())) {
            if (world.isRaining(this.getBlockPosition())) {
                slipMult *= 0.6;
            }
            if (world.isSnowing(this.getBlockPosition())) {
                slipMult *= 0.4;
            }
        }
        return slipMult;
    }

    public abstract boolean providesElectricalPower();

    @Override
    public boolean hasElectricalPower() {
        return super.hasElectricalPower() || this.providesElectricalPower();
    }

    public float ambientTemperature() {
        return this.internal != null ? this.getWorld().getTemperature(this.getBlockPosition()) : 0.0f;
    }
}

