/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.gui.ClickListHelper;
import cam72cam.immersiverailroading.gui.CraftPicker;
import cam72cam.immersiverailroading.items.ItemRailAugment;
import cam72cam.immersiverailroading.items.ItemRollingStock;
import cam72cam.immersiverailroading.items.ItemRollingStockComponent;
import cam72cam.immersiverailroading.library.CraftingMachineMode;
import cam72cam.immersiverailroading.library.CraftingType;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.multiblock.CastingMultiblock;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.util.ItemCastingCost;
import cam72cam.mod.entity.Player;
import cam72cam.mod.fluid.Fluid;
import cam72cam.mod.gui.screen.Button;
import cam72cam.mod.gui.screen.IScreen;
import cam72cam.mod.gui.screen.IScreenBuilder;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.resource.Identifier;
import java.util.Collections;
import java.util.List;

public class CastingGUI
implements IScreen {
    public static final Identifier CASTING_GUI_TEXTURE = new Identifier("immersiverailroading:gui/casting_gui.png");
    private Button gaugeButton;
    private Gauge gauge;
    private Button pickerButton;
    private Button singleCastButton;
    private Button repeatCastButton;
    private TileMultiblock tile;
    private ItemStack currentItem;

    public CastingGUI(TileMultiblock te) {
        this.tile = te;
        this.currentItem = ((CastingMultiblock.CastingInstance)te.getMultiblock()).getCraftItem();
        this.gauge = new ItemRollingStockComponent.Data((ItemStack)this.currentItem).gauge;
    }

    private void updatePickerButton() {
        if (this.currentItem.isEmpty()) {
            this.pickerButton.setText(GuiText.SELECTOR_TYPE.toString(""));
        } else {
            this.pickerButton.setText(this.currentItem.getDisplayName());
        }
    }

    public void init(final IScreenBuilder screen) {
        this.pickerButton = new Button(screen, -100, -30, GuiText.SELECTOR_TYPE.toString("")){

            public void onClick(Player.Hand hand) {
                CraftPicker.showCraftPicker(screen, CastingGUI.this.currentItem, CraftingType.CASTING, item -> {
                    if (item != null) {
                        EntityRollingStockDefinition def;
                        CastingGUI.this.currentItem = item;
                        EntityRollingStockDefinition entityRollingStockDefinition = def = CastingGUI.this.currentItem.is((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT) ? new ItemRollingStockComponent.Data((ItemStack)((CastingGUI)CastingGUI.this).currentItem).def : new ItemRollingStock.Data((ItemStack)((CastingGUI)CastingGUI.this).currentItem).def;
                        if (def != null && !CastingGUI.this.gauge.isModel() && CastingGUI.this.gauge.value() != def.recommended_gauge.value()) {
                            CastingGUI.this.gauge = def.recommended_gauge;
                            CastingGUI.this.gaugeButton.setText(GuiText.SELECTOR_GAUGE.toString(CastingGUI.this.gauge));
                        }
                        CastingGUI.this.updatePickerButton();
                        CastingGUI.this.sendItemPacket();
                    }
                });
            }
        };
        this.updatePickerButton();
        this.gaugeButton = new Button(screen, 0, -10, 100, 20, GuiText.SELECTOR_GAUGE.toString(this.gauge)){

            public void onClick(Player.Hand hand) {
                if (!CastingGUI.this.currentItem.isEmpty()) {
                    EntityRollingStockDefinition def = new ItemRollingStockComponent.Data((ItemStack)((CastingGUI)CastingGUI.this).currentItem).def;
                    if (def != null && Config.ConfigBalance.DesignGaugeLock) {
                        List<Gauge> validGauges = Collections.singletonList(Gauge.from(def.recommended_gauge.value()));
                        CastingGUI.this.gauge = ClickListHelper.next(validGauges, CastingGUI.this.gauge, hand);
                    } else {
                        CastingGUI.this.gauge = ClickListHelper.next(Gauge.values(), CastingGUI.this.gauge, hand);
                    }
                }
                CastingGUI.this.gaugeButton.setText(GuiText.SELECTOR_GAUGE.toString(CastingGUI.this.gauge));
                CastingGUI.this.sendItemPacket();
            }
        };
        this.singleCastButton = new Button(screen, 0, 10, 100, 20, GuiText.SELECTOR_CAST_SINGLE.toString()){

            public void onClick(Player.Hand hand) {
                if (CastingGUI.this.tile.getCraftMode() != CraftingMachineMode.SINGLE) {
                    CastingGUI.this.tile.setCraftMode(CraftingMachineMode.SINGLE);
                } else {
                    CastingGUI.this.tile.setCraftMode(CraftingMachineMode.STOPPED);
                }
            }

            public void onUpdate() {
                CastingGUI.this.singleCastButton.setTextColor(CastingGUI.this.tile.getCraftMode() == CraftingMachineMode.SINGLE ? 0xCC4334 : 0);
            }
        };
        this.repeatCastButton = new Button(screen, 0, 30, 100, 20, GuiText.SELECTOR_CAST_REPEAT.toString()){

            public void onClick(Player.Hand hand) {
                if (CastingGUI.this.tile.getCraftMode() != CraftingMachineMode.REPEAT) {
                    CastingGUI.this.tile.setCraftMode(CraftingMachineMode.REPEAT);
                } else {
                    CastingGUI.this.tile.setCraftMode(CraftingMachineMode.STOPPED);
                }
            }

            public void onUpdate() {
                CastingGUI.this.repeatCastButton.setTextColor(CastingGUI.this.tile.getCraftMode() == CraftingMachineMode.REPEAT ? 0xCC4334 : 0);
            }
        };
    }

    public void onEnterKey(IScreenBuilder b) {
    }

    public void onClose() {
    }

    public void draw(IScreenBuilder builder) {
        float cost;
        double fluidPercent = ((CastingMultiblock.CastingInstance)this.tile.getMultiblock()).getSteelLevel();
        int progress = this.tile.getCraftProgress();
        if (this.currentItem.is((CustomItem)IRItems.ITEM_ROLLING_STOCK)) {
            cost = IRItems.ITEM_ROLLING_STOCK.getCastableComponents(this.currentItem).stream().mapToInt(ItemCastingCost::getCastCost).sum();
        } else {
            cost = ItemCastingCost.getCastCost(this.currentItem);
            if (cost == -999.0f) {
                cost = 0.0f;
            }
        }
        builder.drawImage(CASTING_GUI_TEXTURE, -100, 0, 200, 100);
        builder.drawTank(-95, 3, 57, 60, Fluid.LAVA, (float)fluidPercent, false, -1711571435);
        builder.drawTank(-29, 67, 126, 30, Fluid.LAVA, (float)progress / cost, false, -1718871783);
        String fillStr = String.format("%s/%s", (int)(fluidPercent * 810.0), 810);
        String castStr = String.format("%s/%s", progress, (int)cost);
        builder.drawCenteredString(fillStr, -67, 28, 0xE0E0E0);
        builder.drawCenteredString(castStr, 32, 77, 0xE0E0E0);
    }

    private void sendItemPacket() {
        this.currentItem.setCount(1);
        if (this.currentItem.is((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT) || this.currentItem.is((CustomItem)IRItems.ITEM_CAST_RAIL)) {
            ItemRollingStockComponent.Data data = new ItemRollingStockComponent.Data(this.currentItem);
            data.gauge = this.gauge;
            data.rawCast = data.componentType.crafting == CraftingType.CASTING_HAMMER;
            data.write();
        } else if (this.currentItem.is((CustomItem)IRItems.ITEM_AUGMENT)) {
            ItemRailAugment.Data data = new ItemRailAugment.Data(this.currentItem);
            data.gauge = this.gauge;
            data.write();
        } else if (this.currentItem.is((CustomItem)IRItems.ITEM_ROLLING_STOCK)) {
            ItemRollingStock.Data data = new ItemRollingStock.Data(this.currentItem);
            data.gauge = this.gauge;
            data.write();
        } else {
            this.currentItem.clearTagCompound();
        }
        this.tile.setCraftItem(this.currentItem);
    }
}

