/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.gui.overlay.Readouts;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.ValveGearConfig;
import cam72cam.immersiverailroading.model.FreightTankModel;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.Bell;
import cam72cam.immersiverailroading.model.part.CargoFill;
import cam72cam.immersiverailroading.model.part.Control;
import cam72cam.immersiverailroading.model.part.Door;
import cam72cam.immersiverailroading.model.part.DrivingAssembly;
import cam72cam.immersiverailroading.model.part.LightFlare;
import cam72cam.immersiverailroading.model.part.Readout;
import cam72cam.immersiverailroading.model.part.TrackFollower;
import cam72cam.immersiverailroading.model.part.WheelSet;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.FreightDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import java.util.List;
import util.Matrix4;

public class LocomotiveModel<ENTITY extends Locomotive, DEFINITION extends LocomotiveDefinition>
extends FreightTankModel<ENTITY, DEFINITION> {
    private List<ModelComponent> components;
    private Bell bell;
    private ModelComponent frameFront;
    private ModelComponent frameRear;
    protected DrivingAssembly drivingWheelsFront;
    protected DrivingAssembly drivingWheelsRear;
    private CargoFill cargoFillFront;
    private CargoFill cargoFillRear;
    private ModelComponent shellFront;
    private ModelComponent shellRear;
    protected ModelState frontLocomotive;
    protected ModelState frontLocomotiveRocking;
    protected ModelState rearLocomotive;
    protected ModelState rearLocomotiveRocking;
    private final TrackFollower.TrackFollowers frontTrackers = new TrackFollower.TrackFollowers(s -> new TrackFollower((EntityMoveableRollingStock)((Object)s), this.frameFront, this.drivingWheelsFront != null ? this.drivingWheelsFront.wheels : null, true));
    private final TrackFollower.TrackFollowers rearTrackers = new TrackFollower.TrackFollowers(s -> new TrackFollower((EntityMoveableRollingStock)((Object)s), this.frameRear, this.drivingWheelsRear != null ? this.drivingWheelsRear.wheels : null, false));

    public LocomotiveModel(DEFINITION def) throws Exception {
        super(def);
    }

    @Override
    protected void addGauge(ComponentProvider provider, ModelComponentType type, Readouts value) {
        this.gauges.addAll(Readout.getReadouts(provider, this.frontLocomotiveRocking, type, ModelComponentType.ModelPosition.FRONT_LOCOMOTIVE, value));
        this.gauges.addAll(Readout.getReadouts(provider, this.rearLocomotiveRocking, type, ModelComponentType.ModelPosition.REAR_LOCOMOTIVE, value));
        super.addGauge(provider, type, value);
    }

    @Override
    protected void addControl(ComponentProvider provider, ModelComponentType type) {
        this.controls.addAll(Control.get(provider, this.frontLocomotiveRocking, type, ModelComponentType.ModelPosition.FRONT_LOCOMOTIVE));
        this.controls.addAll(Control.get(provider, this.rearLocomotiveRocking, type, ModelComponentType.ModelPosition.REAR_LOCOMOTIVE));
        super.addControl(provider, type);
    }

    @Override
    protected void addDoor(ComponentProvider provider) {
        this.doors.addAll(Door.get(provider, this.frontLocomotiveRocking, ModelComponentType.ModelPosition.FRONT_LOCOMOTIVE));
        this.doors.addAll(Door.get(provider, this.rearLocomotiveRocking, ModelComponentType.ModelPosition.REAR_LOCOMOTIVE));
        super.addDoor(provider);
    }

    @Override
    protected void addHeadlight(DEFINITION def, ComponentProvider provider, ModelComponentType type) {
        this.headlights.addAll(LightFlare.get(def, provider, this.frontLocomotiveRocking, type, ModelComponentType.ModelPosition.FRONT_LOCOMOTIVE));
        this.headlights.addAll(LightFlare.get(def, provider, this.rearLocomotiveRocking, type, ModelComponentType.ModelPosition.REAR_LOCOMOTIVE));
        this.headlights.addAll(LightFlare.get(def, provider, this.frontLocomotiveRocking, type, ModelComponentType.ModelPosition.FRONT));
        this.headlights.addAll(LightFlare.get(def, provider, this.rearLocomotiveRocking, type, ModelComponentType.ModelPosition.REAR));
        super.addHeadlight(def, provider, type);
    }

    @Override
    protected void parseControllable(ComponentProvider provider, DEFINITION def) {
        this.gauges.addAll(Readout.getReadouts(provider, this.frontLocomotiveRocking, ModelComponentType.COUPLED_X, ModelComponentType.ModelPosition.FRONT_LOCOMOTIVE, Readouts.COUPLED_FRONT));
        this.gauges.addAll(Readout.getReadouts(provider, this.rearLocomotiveRocking, ModelComponentType.COUPLED_X, ModelComponentType.ModelPosition.REAR_LOCOMOTIVE, Readouts.COUPLED_REAR));
        super.parseControllable(provider, def);
        this.addGauge(provider, ModelComponentType.GAUGE_SPEED_X, Readouts.SPEED);
        this.addGauge(provider, ModelComponentType.GAUGE_THROTTLE_X, Readouts.THROTTLE);
        this.addGauge(provider, ModelComponentType.GAUGE_REVERSER_X, Readouts.REVERSER);
        this.addGauge(provider, ModelComponentType.GAUGE_TRAIN_BRAKE_X, Readouts.TRAIN_BRAKE);
        if (((EntityRollingStockDefinition)def).hasIndependentBrake()) {
            this.addGauge(provider, ModelComponentType.GAUGE_INDEPENDENT_BRAKE_X, Readouts.INDEPENDENT_BRAKE);
        }
        this.addControl(provider, ModelComponentType.BELL_CONTROL_X);
        this.addControl(provider, ModelComponentType.THROTTLE_BRAKE_X);
        this.addControl(provider, ModelComponentType.THROTTLE_X);
        this.addControl(provider, ModelComponentType.REVERSER_X);
        this.addControl(provider, ModelComponentType.TRAIN_BRAKE_X);
        if (((EntityRollingStockDefinition)def).hasIndependentBrake()) {
            this.addControl(provider, ModelComponentType.INDEPENDENT_BRAKE_X);
        }
    }

    @Override
    protected void initStates() {
        super.initStates();
        this.frontLocomotive = this.base.push(settings -> settings.add((s, partialTicks) -> this.getFrontLocomotiveMatrix(s)));
        this.frontLocomotiveRocking = this.addRoll(this.frontLocomotive);
        this.rearLocomotive = this.base.push(settings -> settings.add((s, partialTicks) -> this.getRearLocomotiveMatrix(s)));
        this.rearLocomotiveRocking = this.addRoll(this.rearLocomotive);
    }

    @Override
    protected void parseComponents(ComponentProvider provider, DEFINITION def) {
        ValveGearConfig type = ((EntityRollingStockDefinition)def).getValveGear();
        boolean showCurrentLoadOnly = ((FreightDefinition)def).shouldShowCurrentLoadOnly();
        this.frameFront = provider.parse(ModelComponentType.FRONT_FRAME);
        this.shellFront = provider.parse(ModelComponentType.FRONT_SHELL);
        this.frontLocomotiveRocking.include(this.frameFront);
        this.frontLocomotiveRocking.include(this.shellFront);
        this.cargoFillFront = CargoFill.get(provider, this.frontLocomotiveRocking, showCurrentLoadOnly, ModelComponentType.ModelPosition.FRONT);
        this.drivingWheelsFront = DrivingAssembly.get(type, provider, this.frontLocomotive, ModelComponentType.ModelPosition.FRONT, 0.0f, new WheelSet[0]);
        this.frameRear = provider.parse(ModelComponentType.REAR_FRAME);
        this.shellRear = provider.parse(ModelComponentType.REAR_SHELL);
        this.rearLocomotiveRocking.include(this.frameRear);
        this.rearLocomotiveRocking.include(this.shellRear);
        this.cargoFillRear = CargoFill.get(provider, this.rearLocomotiveRocking, showCurrentLoadOnly, ModelComponentType.ModelPosition.REAR);
        this.drivingWheelsRear = DrivingAssembly.get(type, provider, this.rearLocomotive, ModelComponentType.ModelPosition.REAR, 45.0f, new WheelSet[0]);
        this.components = provider.parse(new ModelComponentType[]{ModelComponentType.CAB});
        this.rocking.include(this.components);
        this.bell = Bell.get(provider, this.rocking, ((LocomotiveDefinition)def).bell);
        super.parseComponents(provider, def);
    }

    @Override
    protected void effects(ENTITY stock) {
        super.effects(stock);
        this.bell.effects((EntityMoveableRollingStock)((Object)stock), ((Locomotive)((Object)stock)).getBell() > 0 ? 0.8f : 0.0f);
    }

    @Override
    protected void removed(ENTITY stock) {
        super.removed(stock);
        if (this.frontTrackers != null) {
            this.frontTrackers.remove((EntityMoveableRollingStock)((Object)stock));
        }
        if (this.rearTrackers != null) {
            this.rearTrackers.remove((EntityMoveableRollingStock)((Object)stock));
        }
        this.bell.removed((EntityMoveableRollingStock)((Object)stock));
    }

    private Matrix4 getFrontLocomotiveMatrix(EntityMoveableRollingStock s) {
        return this.frontTrackers.get(s).getMatrix();
    }

    public float getFrontLocomotiveYaw(EntityMoveableRollingStock s) {
        return this.frontTrackers.get(s).getYawReadout();
    }

    private Matrix4 getRearLocomotiveMatrix(EntityMoveableRollingStock s) {
        return this.rearTrackers.get(s).getMatrix();
    }

    public float getRearLocomotiveYaw(EntityMoveableRollingStock s) {
        return this.rearTrackers.get(s).getYawReadout();
    }
}

