/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.ValveGear;
import cam72cam.immersiverailroading.model.part.WheelSet;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import java.util.stream.Collectors;
import util.Matrix4;

public class ConnectingRodValveGear
extends ValveGear {
    protected Vec3d centerOfWheels;
    protected final ModelComponent connectingRod;

    public static ConnectingRodValveGear get(WheelSet wheels, ComponentProvider provider, ModelState state, ModelComponentType.ModelPosition pos, float angleOffset) {
        ModelComponent connectingRod = provider.parse(ModelComponentType.SIDE_ROD_SIDE, pos);
        return connectingRod != null ? new ConnectingRodValveGear(wheels, state, connectingRod, angleOffset) : null;
    }

    public ConnectingRodValveGear(WheelSet wheels, ModelState state, ModelComponent connectingRod, float angleOffset) {
        super(wheels, state, angleOffset);
        this.connectingRod = connectingRod;
        this.centerOfWheels = ModelComponent.center(wheels.wheels.stream().map(x -> x.wheel).collect(Collectors.toList()));
        state.push(settings -> settings.add((stock, partialTicks) -> {
            Vec3d connRodMovment = this.connRodMovement(stock);
            return new Matrix4().translate(-this.connRodRadius(), 0.0, 0.0).translate(connRodMovment.x, connRodMovment.z, 0.0);
        })).include(connectingRod);
    }

    public Vec3d connRodMovement(EntityMoveableRollingStock stock) {
        return VecUtil.fromWrongYaw(this.connRodRadius(), this.angle(stock.distanceTraveled));
    }

    public double connRodRadius() {
        Vec3d connRodPos = this.connectingRod.center;
        return connRodPos.x - this.centerOfWheels.x;
    }
}

