/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.model.TrackModel;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.render.ExpireableMap;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.render.obj.OBJRender;
import cam72cam.mod.render.opengl.RenderState;
import cam72cam.mod.render.opengl.VBO;
import java.util.List;
import java.util.stream.Collectors;
import util.Matrix4;

public class RailBuilderRender {
    private static final ExpireableMap<String, VBO> cache = new ExpireableMap<String, VBO>(){

        @Override
        public void onRemove(String key, VBO value) {
            value.free();
        }
    };

    public static void renderRailBuilder(RailInfo info, List<BuilderBase.VecYawPitch> renderData, RenderState state) {
        TrackModel model = DefinitionManager.getTrack(info.settings.track, info.settings.gauge.value());
        if (model == null) {
            return;
        }
        VBO cached = cache.get(info.uniqueID);
        if (cached == null) {
            OBJRender.Builder builder = model.binder().builder();
            for (BuilderBase.VecYawPitch piece : renderData) {
                Matrix4 m = new Matrix4();
                m.translate(piece.x, piece.y, piece.z);
                m.rotate(Math.toRadians(piece.getYaw()), 0.0, 1.0, 0.0);
                m.rotate(Math.toRadians(piece.getPitch()), 1.0, 0.0, 0.0);
                m.rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0);
                if (piece.getLength() != -1.0f) {
                    m.scale((double)piece.getLength() / info.settings.gauge.scale(), 1.0, 1.0);
                }
                double scale = info.settings.gauge.scale();
                m.scale(scale, scale, scale);
                if (piece.getGroups().size() != 0) {
                    List groups = model.groups().stream().filter(group -> piece.getGroups().stream().anyMatch(group::contains)).collect(Collectors.toList());
                    builder.draw(groups, m);
                    continue;
                }
                builder.draw(m);
            }
            cached = builder.build();
            cache.put(info.uniqueID, cached);
        }
        MinecraftClient.startProfiler((String)"irTrackModel");
        VBO.Binding vbo = cached.bind(state, info.settings.type == TrackItems.TURNTABLE);
        Object object = null;
        try {
            vbo.draw();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (vbo != null) {
                if (object != null) {
                    try {
                        vbo.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    vbo.close();
                }
            }
        }
        MinecraftClient.endProfiler();
    }
}

