/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.render.rail.RailRender;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.render.opengl.BlendMode;
import util.Matrix4;

public class RailPreviewRender {
    public static StandardModel render(TileRailPreview te) {
        RailInfo info = te.getRailRenderInfo();
        if (info == null) {
            return null;
        }
        StandardModel model = new StandardModel();
        model.addCustom((state, pt) -> {
            MinecraftClient.startProfiler((String)"tile_rail_preview");
            state.blend(new BlendMode(32771, 1).constantColor(1.0f, 1.0f, 1.0f, 0.7f)).lightmap(1.0f, 1.0f);
            if (te.isAboveRails()) {
                state.translate(0.0, -1.0, 0.0);
            }
            Vec3d placementPosition = info.placementInfo.placementPosition;
            state.translate(placementPosition.x, placementPosition.y, placementPosition.z);
            if (!te.isMulti()) {
                RailRender.render(info, te.getWorld(), te.isAboveRails() ? te.getPos().down() : te.getPos(), true, state);
            }
            MinecraftClient.endProfiler();
        });
        model.addItem(new ItemStack((CustomItem)IRItems.ITEM_GOLDEN_SPIKE, 1), new Matrix4().translate(0.5, 0.5, 0.5).scale(1.0, 1.0, 1.0));
        return model;
    }
}

