/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.IIterableTrack;
import cam72cam.immersiverailroading.track.PosStep;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.track.TrackGag;
import cam72cam.immersiverailroading.track.TrackRail;
import cam72cam.immersiverailroading.util.MathUtil;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.SerializationException;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagSerializer;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BuilderIterator
extends BuilderBase
implements IIterableTrack {
    protected HashSet<Pair<Integer, Integer>> positions = new HashSet();

    public BuilderIterator(RailInfo info, World world, Vec3i pos) {
        this(info, world, pos, false);
    }

    @Override
    public abstract List<PosStep> getPath(double var1);

    public BuilderIterator(RailInfo info, World world, Vec3i pos, boolean endOfTrack) {
        super(info, world, pos);
        HashMap<Pair, Float> bedHeights = new HashMap<Pair, Float>();
        HashMap<Pair, Float> railHeights = new HashMap<Pair, Float>();
        HashMap<Pair, Integer> yOffset = new HashMap<Pair, Integer>();
        HashSet<Pair> flexPositions = new HashSet<Pair>();
        double horiz = info.settings.gauge.scale() * 1.1;
        if (Config.ConfigDebug.oldNarrowWidth && info.settings.gauge.value() < 1.0) {
            horiz /= 2.0;
        }
        if (info.settings.isGradeCrossing) {
            horiz += 2.0 * info.settings.gauge.scale();
        }
        double clamp = 0.17 * info.settings.gauge.scale();
        float heightOffset = (float)(info.placementInfo.placementPosition.y % 1.0);
        List<PosStep> path = this.getPath(0.25);
        PosStep start = path.get(0);
        PosStep end = path.get(path.size() - 1);
        Vec3d placeOff = new Vec3d(Math.abs(MathUtil.trueModulus(info.placementInfo.placementPosition.x, 1.0)), 0.0, Math.abs(MathUtil.trueModulus(info.placementInfo.placementPosition.z, 1.0)));
        int mainX = (int)Math.floor(path.get((int)(path.size() / 2)).x + placeOff.x);
        int mainZ = (int)Math.floor(path.get((int)(path.size() / 2)).z + placeOff.z);
        int flexDist = (int)Math.max(1.0, 3.0 * (0.5 + info.settings.gauge.scale() / 2.0));
        for (PosStep cur : path) {
            PosStep gagPos = cur;
            boolean isFlex = gagPos.distanceTo(start) < (double)flexDist || gagPos.distanceTo(end) < (double)flexDist;
            gagPos = gagPos.add(0.0, heightOffset, 0.0);
            for (double q = -horiz; q <= horiz; q += 0.1) {
                Pair gag;
                Vec3d nextUp = VecUtil.fromYaw(q, 90.0f + cur.yaw);
                int posX = (int)Math.floor(gagPos.x + nextUp.x + placeOff.x);
                int posZ = (int)Math.floor(gagPos.z + nextUp.z + placeOff.z);
                double height = 0.0;
                if (info.settings.isGradeCrossing) {
                    height = (1.0 - (double)Math.abs((int)q) / horiz) / 3.0 - 0.05;
                    height *= info.settings.gauge.scale();
                    height = Math.min(height, clamp);
                }
                double relHeight = gagPos.y % 1.0;
                if (gagPos.y < 0.0) {
                    relHeight += 1.0;
                }
                if (!this.positions.contains(gag = Pair.of((Object)posX, (Object)posZ))) {
                    this.positions.add((Pair<Integer, Integer>)gag);
                    bedHeights.put(gag, Float.valueOf((float)(height + Math.max(0.0, relHeight - 0.1))));
                    railHeights.put(gag, Float.valueOf((float)relHeight));
                    yOffset.put(gag, (int)(gagPos.y - relHeight));
                }
                if (!isFlex && !(Math.abs(q) > info.settings.gauge.value())) continue;
                flexPositions.add(gag);
            }
            if (isFlex || !endOfTrack) continue;
            mainX = (int)Math.floor(gagPos.x + placeOff.x);
            mainZ = (int)Math.floor(gagPos.z + placeOff.z);
        }
        if (!yOffset.containsKey(Pair.of((Object)mainX, (Object)mainZ))) {
            for (Facing value : Facing.values()) {
                if (!yOffset.containsKey(Pair.of((Object)(mainX + value.getXMultiplier()), (Object)(mainZ + value.getZMultiplier())))) continue;
                mainX += value.getXMultiplier();
                mainZ += value.getZMultiplier();
                break;
            }
        }
        if (!yOffset.containsKey(Pair.of((Object)mainX, (Object)mainZ))) {
            TagCompound debug = new TagCompound();
            try {
                TagSerializer.serialize((TagCompound)debug, (Object)info, (Class[])new Class[0]);
            }
            catch (SerializationException e) {
                throw new RuntimeException("Invalid track builder", e);
            }
            throw new RuntimeException("Invalid track builder " + debug.toString());
        }
        Vec3i mainPos = new Vec3i(mainX, ((Integer)yOffset.get(Pair.of((Object)mainX, (Object)mainZ))).intValue(), mainZ);
        this.setParentPos(mainPos);
        TrackRail main = new TrackRail(this, mainPos);
        this.tracks.add(main);
        main.setRailHeight(((Float)railHeights.get(Pair.of((Object)mainX, (Object)mainZ))).floatValue());
        main.setBedHeight(((Float)bedHeights.get(Pair.of((Object)mainX, (Object)mainZ))).floatValue());
        for (Pair<Integer, Integer> pair : this.positions) {
            if ((Integer)pair.getLeft() == mainX && (Integer)pair.getRight() == mainZ) continue;
            TrackGag tg = new TrackGag(this, new Vec3i(((Integer)pair.getLeft()).intValue(), ((Integer)yOffset.get(pair)).intValue(), ((Integer)pair.getRight()).intValue()));
            if (flexPositions.contains(pair)) {
                tg.setFlexible();
            }
            tg.setRailHeight(((Float)railHeights.get(pair)).floatValue());
            tg.setBedHeight(((Float)bedHeights.get(pair)).floatValue());
            this.tracks.add(tg);
        }
    }

    @Override
    public List<TrackBase> getTracksForRender() {
        return this.tracks;
    }

    private static float delta(float a, float b) {
        float angle = (float)Math.toDegrees(Math.toRadians(a) - Math.toRadians(b));
        if (angle > 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    @Override
    public List<BuilderBase.VecYawPitch> getRenderData() {
        PosStep cur;
        int i;
        ArrayList<BuilderBase.VecYawPitch> data = new ArrayList<BuilderBase.VecYawPitch>();
        double scale = this.info.settings.gauge.scale();
        List<PosStep> points = this.getPath(scale * this.info.getTrackModel().spacing);
        boolean switchStraight = this.info.switchState == SwitchState.STRAIGHT;
        int switchSize = 0;
        TrackDirection direction = this.info.placementInfo.direction;
        if (switchStraight) {
            for (i = 0; i < points.size(); ++i) {
                cur = points.get(i);
                Vec3d flatPos = VecUtil.rotateYaw(cur, -this.info.placementInfo.yaw);
                if (!(Math.abs(flatPos.z) >= 0.5 * scale)) continue;
                switchSize = i;
                break;
            }
        }
        for (i = 0; i < points.size(); ++i) {
            PosStep next;
            float angle;
            double switchOffset;
            PosStep switchPos = cur = points.get(i);
            if (switchStraight && (switchOffset = 1.0 - (double)i / (double)switchSize) > 0.0) {
                double dist = 0.2 * switchOffset * scale * this.info.getTrackModel().spacing;
                Vec3d offset = VecUtil.fromYaw(dist, cur.yaw + 90.0f + this.info.placementInfo.direction.toYaw());
                double offsetAngle = Math.toDegrees(0.2 / (double)switchSize);
                if (direction == TrackDirection.RIGHT) {
                    offsetAngle = -offsetAngle;
                }
                switchPos = new PosStep(cur.add(offset), cur.yaw + (float)offsetAngle, cur.pitch);
            }
            if (points.size() == 1) {
                angle = 0.0f;
            } else if (i + 1 == points.size()) {
                next = points.get(i - 1);
                angle = BuilderIterator.delta(next.yaw, cur.yaw);
                angle *= 2.0f;
            } else if (i == 0) {
                next = points.get(i + 1);
                angle = BuilderIterator.delta(cur.yaw, next.yaw);
                angle *= 2.0f;
            } else {
                PosStep prev = points.get(i - 1);
                PosStep next2 = points.get(i + 1);
                angle = BuilderIterator.delta(prev.yaw, next2.yaw);
            }
            if (angle != 0.0f) {
                if (direction == TrackDirection.RIGHT) {
                    data.add(new BuilderBase.VecYawPitch((BuilderBase)this, switchPos.x, switchPos.y, switchPos.z, switchPos.yaw, switchPos.pitch, (1.0f - angle / 180.0f) * (float)this.info.settings.gauge.scale(), "RAIL_LEFT"));
                    data.add(new BuilderBase.VecYawPitch((BuilderBase)this, cur.x, cur.y, cur.z, cur.yaw, cur.pitch, (1.0f + angle / 180.0f) * (float)this.info.settings.gauge.scale(), "RAIL_RIGHT"));
                } else {
                    data.add(new BuilderBase.VecYawPitch((BuilderBase)this, cur.x, cur.y, cur.z, cur.yaw, cur.pitch, (1.0f - angle / 180.0f) * (float)this.info.settings.gauge.scale(), "RAIL_LEFT"));
                    data.add(new BuilderBase.VecYawPitch((BuilderBase)this, switchPos.x, switchPos.y, switchPos.z, switchPos.yaw, switchPos.pitch, (1.0f + angle / 180.0f) * (float)this.info.settings.gauge.scale(), "RAIL_RIGHT"));
                }
                data.add(new BuilderBase.VecYawPitch((BuilderBase)this, cur.x, cur.y, cur.z, cur.yaw, cur.pitch, "RAIL_BASE"));
                continue;
            }
            data.add(new BuilderBase.VecYawPitch((BuilderBase)this, cur.x, cur.y, cur.z, cur.yaw, cur.pitch, new String[0]));
        }
        return data;
    }
}

