/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.util.DataBlock;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSON {
    public static DataBlock parse(InputStream stream) throws IOException {
        try {
            DataBlock dataBlock = JSON.wrapObject(new JsonParser().parse((Reader)new InputStreamReader(stream)).getAsJsonObject());
            return dataBlock;
        }
        finally {
            stream.close();
        }
    }

    private static DataBlock wrapObject(JsonObject obj) {
        final LinkedHashMap primitives = new LinkedHashMap();
        final LinkedHashMap blocks = new LinkedHashMap();
        for (Map.Entry entry : obj.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                primitives.put(entry.getKey(), JSON.wrapValue(((JsonElement)entry.getValue()).getAsJsonPrimitive()));
            }
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            blocks.put(entry.getKey(), JSON.wrapObject(((JsonElement)entry.getValue()).getAsJsonObject()));
        }
        final LinkedHashMap<String, List> primitiveSets = new LinkedHashMap<String, List>();
        final LinkedHashMap<String, List> blockSets = new LinkedHashMap<String, List>();
        for (Map.Entry entry : obj.entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
            for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                if (element.isJsonPrimitive()) {
                    primitiveSets.computeIfAbsent((String)entry.getKey(), key -> new ArrayList()).add(JSON.wrapValue(element.getAsJsonPrimitive()));
                }
                if (!element.isJsonObject()) continue;
                blockSets.computeIfAbsent((String)entry.getKey(), key -> new ArrayList()).add(JSON.wrapObject(element.getAsJsonObject()));
            }
        }
        return new DataBlock(){

            @Override
            public Map<String, DataBlock.Value> getValueMap() {
                return primitives;
            }

            @Override
            public Map<String, List<DataBlock.Value>> getValuesMap() {
                return primitiveSets;
            }

            @Override
            public Map<String, DataBlock> getBlockMap() {
                return blocks;
            }

            @Override
            public Map<String, List<DataBlock>> getBlocksMap() {
                return blockSets;
            }
        };
    }

    private static DataBlock.Value wrapValue(final JsonPrimitive primitive) {
        return new DataBlock.Value(){

            @Override
            public Boolean asBoolean() {
                return primitive == null ? null : Boolean.valueOf(primitive.getAsBoolean());
            }

            @Override
            public Integer asInteger() {
                return primitive == null ? null : Integer.valueOf(primitive.getAsInt());
            }

            @Override
            public Float asFloat() {
                return primitive == null ? null : Float.valueOf(primitive.getAsFloat());
            }

            @Override
            public Double asDouble() {
                return primitive == null ? null : Double.valueOf(primitive.getAsDouble());
            }

            @Override
            public String asString() {
                return primitive == null ? null : primitive.getAsString();
            }
        };
    }
}

