/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.mod.ctm;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CTMManager {
    public static final String ctmID = "ctm";
    private static boolean isinstalled = Loader.isModLoaded((String)"ctm");
    private static Field worldField = ReflectionHelper.findField(ChunkCache.class, (String[])new String[]{"world", "field_72815_e"});
    private static Class optifineChunkCache;
    private static Field chunkCacheField;
    private static Class regionCacheClass;
    private static Field passthrough;
    private static Field stateCache;

    public static boolean isInstalled() {
        return isinstalled;
    }

    public static IBlockAccess getRealWorld(IBlockAccess world) {
        IBlockAccess realWorld;
        if (regionCacheClass.isInstance(world)) {
            try {
                ((Map)stateCache.get(world)).clear();
                Object object = passthrough.get(world);
                if (object instanceof IBlockAccess) {
                    realWorld = (IBlockAccess)object;
                }
                realWorld = (IBlockAccess)((WeakReference)object).get();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return null;
            }
        } else if (optifineChunkCache != null && optifineChunkCache.isInstance(world)) {
            try {
                realWorld = (IBlockAccess)chunkCacheField.get(world);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return null;
            }
        } else if (world instanceof ChunkCache) {
            try {
                realWorld = (IBlockAccess)worldField.get(world);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return null;
            }
        } else {
            return world;
        }
        return CTMManager.getRealWorld(realWorld);
    }

    public static IBlockState getCorrectStateOrigin(IBlockAccess world, BlockPos pos) {
        if (regionCacheClass == null) {
            try {
                regionCacheClass = Class.forName("team.chisel.ctm.client.util.RegionCache");
                passthrough = ReflectionHelper.findField((Class)regionCacheClass, (String[])new String[]{"passthrough"});
                stateCache = ReflectionHelper.findField((Class)regionCacheClass, (String[])new String[]{"stateCache"});
                optifineChunkCache = Class.forName("net.optifine.override");
                chunkCacheField = ReflectionHelper.findField((Class)optifineChunkCache, (String[])new String[]{"chunkCache"});
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return CTMManager.getRealWorld(world).func_180495_p(pos);
    }

    static {
        regionCacheClass = null;
        passthrough = null;
        stateCache = null;
    }
}

