/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.mod.lux;

import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.zeitheron.hammercore.api.lighting.ColoredLight;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.zeith.lux.api.LuxManager;
import org.zeith.lux.api.event.ReloadLuxManagerEvent;
import org.zeith.lux.api.light.ILightBlockHandler;

public class LuxExtension {
    @SubscribeEvent
    public static void reloadLux(ReloadLuxManagerEvent event) {
        ILightBlockHandler handler = (world, pos, state, e) -> {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityLittleTiles) {
                TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
                for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                    LittleTile tile = (LittleTile)pair.value;
                    ArrayList lights = LuxManager.getLights((World)world, (BlockPos)pos, (IBlockState)tile.getBlockState(), null, (float)e.getPartialTicks());
                    if (lights.isEmpty()) continue;
                    for (ColoredLight light : lights) {
                        int color = ColorUtils.RGBAToInt((float)light.r, (float)light.g, (float)light.b, (float)light.a);
                        if (tile instanceof LittleTileColored) {
                            color = ColorUtils.blend((int)color, (int)((LittleTileColored)tile).color);
                        }
                        e.add(ColoredLight.builder().pos(tile.getCompleteBox().getBox(te.getContext(), te.func_174877_v()).func_189972_c()).color(ColorUtils.getRedDecimal((int)color), ColorUtils.getGreenDecimal((int)color), ColorUtils.getBlueDecimal((int)color), ColorUtils.getAlphaDecimal((int)color)).radius((float)((double)light.radius * tile.getPercentVolume(te.getContext()))));
                    }
                }
            }
        };
        event.registerBlockLight(LittleTiles.blockTileNoTicking, handler);
        event.registerBlockLight(LittleTiles.blockTileNoTickingRendered, handler);
        event.registerBlockLight(LittleTiles.blockTileTicking, handler);
        event.registerBlockLight(LittleTiles.blockTileTickingRendered, handler);
    }
}

