/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.event.LittleEventHandler;
import com.creativemd.littletiles.common.packet.LittleUpdateStructurePacket;
import com.creativemd.littletiles.common.structure.IAnimatedStructure;
import com.creativemd.littletiles.common.structure.connection.ChildrenList;
import com.creativemd.littletiles.common.structure.connection.IWorldPositionProvider;
import com.creativemd.littletiles.common.structure.connection.StructureChildConnection;
import com.creativemd.littletiles.common.structure.connection.StructureChildFromSubWorldConnection;
import com.creativemd.littletiles.common.structure.connection.StructureChildToSubWorldConnection;
import com.creativemd.littletiles.common.structure.directional.StructureDirectionalField;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.MissingBlockException;
import com.creativemd.littletiles.common.structure.exception.MissingChildException;
import com.creativemd.littletiles.common.structure.exception.MissingParentException;
import com.creativemd.littletiles.common.structure.exception.MissingStructureException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.exception.RemovedStructureException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.component.ISignalStructureComponent;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.signal.input.InternalSignalInput;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.structure.signal.output.SignalExternalOutputHandler;
import com.creativemd.littletiles.common.structure.signal.schedule.ISignalSchedulable;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.tile.math.vec.RelativeBlockPos;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.parent.StructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviewsStructureHolder;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.outdated.identifier.LittleIdentifierRelative;
import com.creativemd.littletiles.common.util.vec.SurroundingBox;
import com.creativemd.littletiles.common.world.LittleNeighborUpdateCollector;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleStructure
implements ISignalSchedulable,
IWorldPositionProvider {
    private static final Iterator<LittleTile> EMPTY_ITERATOR = new Iterator<LittleTile>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public LittleTile next() {
            return null;
        }
    };
    private static final HashMapList<BlockPos, LittleTile> EMPTY_HASHMAPLIST = new HashMapList();
    public final LittleStructureType type;
    public final IStructureTileList mainBlock;
    private final List<StructureBlockConnector> blocks = new ArrayList<StructureBlockConnector>();
    public String name;
    private StructureChildConnection parent;
    protected ChildrenList children;
    private HashMap<Integer, SignalExternalOutputHandler> externalHandler;
    private final InternalSignalInput[] inputs;
    private final InternalSignalOutput[] outputs;
    private boolean signalChanged = false;

    public LittleStructure(LittleStructureType type, IStructureTileList mainBlock) {
        this.type = type;
        this.mainBlock = mainBlock;
        this.inputs = type.createInputs(this);
        this.outputs = type.createOutputs(this);
    }

    @Override
    public World getWorld() {
        if (this.mainBlock.isRemoved()) {
            return null;
        }
        return this.mainBlock.getWorld();
    }

    public boolean hasWorld() {
        return this.mainBlock != null && !this.mainBlock.isRemoved() && this.mainBlock.getWorld() != null;
    }

    public boolean isClient() {
        return this.getWorld().field_72995_K;
    }

    @Override
    public BlockPos getPos() {
        return this.mainBlock.getPos();
    }

    public int getIndex() {
        return this.mainBlock.getIndex();
    }

    public int getAttribute() {
        return this.type.attribute;
    }

    public boolean hasAttribute(int attribute) {
        return (this.getAttribute() & attribute) != 0;
    }

    public boolean hasAttributeIncludeChildren(int attribute) throws CorruptedConnectionException, NotYetConnectedException {
        if ((this.getAttribute() & attribute) != 0) {
            return true;
        }
        for (StructureChildConnection child : this.children) {
            if (!child.getStructure().hasAttribute(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeIncludeChildrenSameWorldOnly(int attribute) throws CorruptedConnectionException, NotYetConnectedException {
        if ((this.getAttribute() & attribute) != 0) {
            return true;
        }
        for (StructureChildConnection child : this.children) {
            if (child.isLinkToAnotherWorld() || !child.getStructure().hasAttribute(attribute)) continue;
            return true;
        }
        return false;
    }

    public StructureLocation getStructureLocation() {
        return new StructureLocation(this);
    }

    public void load() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.mainBlock.isRemoved()) {
            throw new RemovedStructureException();
        }
        for (StructureBlockConnector block : this.blocks) {
            block.connect();
        }
        try {
            if (this.parent != null) {
                this.parent.checkConnection();
            }
        }
        catch (CorruptedConnectionException e) {
            throw new MissingParentException(this.parent, e);
        }
        for (StructureChildConnection child : this.children) {
            try {
                child.getStructure().load();
            }
            catch (CorruptedConnectionException e) {
                throw new MissingChildException(child, e);
            }
        }
    }

    public void tryAttributeChangeForBlocks() throws CorruptedConnectionException, NotYetConnectedException {
        int attribute = this.getAttribute();
        this.mainBlock.setAttribute(attribute);
        for (StructureBlockConnector block : this.blocks) {
            try {
                block.getList().setAttribute(attribute);
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        }
    }

    public int count() throws CorruptedConnectionException, NotYetConnectedException {
        int count = this.mainBlock.size();
        for (StructureBlockConnector block : this.blocks) {
            count += block.count();
        }
        return count;
    }

    public boolean isChildOf(LittleStructure structure) throws CorruptedConnectionException, NotYetConnectedException {
        if (structure == this) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.getStructure().isChildOf(structure);
        }
        return false;
    }

    public void removeParent() {
        if (!this.parent.dynamic) {
            throw new RuntimeException("Cannot remove non dynamic child");
        }
        this.parent = null;
    }

    public void updateChildConnection(int i, LittleStructure child, boolean dynamic) {
        StructureChildConnection connector;
        World world = this.getWorld();
        World childWorld = child.getWorld();
        if (childWorld == world) {
            connector = new StructureChildConnection(this, false, dynamic, i, child.getPos().func_177973_b((Vec3i)this.getPos()), child.getIndex(), child.getAttribute());
        } else if (childWorld instanceof SubWorld && ((SubWorld)childWorld).parent != null) {
            connector = new StructureChildToSubWorldConnection((IWorldPositionProvider)this, dynamic, i, child.getPos().func_177973_b((Vec3i)this.getPos()), child.getIndex(), child.getAttribute(), ((SubWorld)childWorld).parent.func_110124_au());
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        this.children.set(connector);
    }

    public void updateParentConnection(int i, LittleStructure parent, boolean dynamic) {
        StructureChildConnection connector;
        World world = this.getWorld();
        World parentWorld = parent.getWorld();
        if (parentWorld == world) {
            connector = new StructureChildConnection(this, true, dynamic, i, parent.getPos().func_177973_b((Vec3i)this.getPos()), parent.getIndex(), parent.getAttribute());
        } else if (world instanceof SubWorld && ((SubWorld)world).parent != null) {
            connector = new StructureChildFromSubWorldConnection(this, dynamic, i, parent.getPos().func_177973_b((Vec3i)this.getPos()), parent.getIndex(), parent.getAttribute());
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        this.parent = connector;
    }

    public StructureChildConnection generateConnection(IWorldPositionProvider parent) {
        StructureChildConnection connector;
        World world = this.getWorld();
        World parentWorld = parent.getWorld();
        if (parentWorld == world) {
            connector = new StructureChildConnection(parent, true, false, 0, this.getPos().func_177973_b((Vec3i)parent.getPos()), this.getIndex(), this.getAttribute());
        } else if (world instanceof SubWorld && ((SubWorld)world).parent != null) {
            connector = new StructureChildToSubWorldConnection(parent, false, 0, this.getPos().func_177973_b((Vec3i)parent.getPos()), this.getIndex(), this.getAttribute(), ((SubWorld)world).parent.func_110124_au());
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        return connector;
    }

    public void removeDynamicChild(int i) throws CorruptedConnectionException, NotYetConnectedException {
        this.children.remove(i);
    }

    public StructureChildConnection getParent() {
        return this.parent;
    }

    public LittleStructure findTopStructure() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.parent != null) {
            return this.parent.getStructure().findTopStructure();
        }
        return this;
    }

    public int countChildren() {
        return this.children.size();
    }

    public Iterable<StructureChildConnection> getChildren() {
        return this.children;
    }

    public StructureChildConnection getChild(int index) throws CorruptedConnectionException, NotYetConnectedException {
        return this.children.get(index);
    }

    public void addBlock(StructureTileList block) {
        this.blocks.add(new StructureBlockConnector(block.getPos().func_177973_b((Vec3i)this.getPos())));
    }

    public Iterable<BlockPos> positions() {
        return new Iterable<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new Iterator<BlockPos>(){
                    boolean first = true;
                    Iterator<StructureBlockConnector> iterator;
                    {
                        this.iterator = LittleStructure.this.blocks.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.first || this.iterator.hasNext();
                    }

                    @Override
                    public BlockPos next() {
                        if (this.first) {
                            this.first = false;
                            return LittleStructure.this.mainBlock.getPos();
                        }
                        return this.iterator.next().getAbsolutePos();
                    }
                };
            }
        };
    }

    public Iterable<TileEntityLittleTiles> blocks() throws CorruptedConnectionException, NotYetConnectedException {
        this.load();
        return new Iterable<TileEntityLittleTiles>(){

            @Override
            public Iterator<TileEntityLittleTiles> iterator() {
                return new Iterator<TileEntityLittleTiles>(){
                    boolean first = true;
                    Iterator<StructureBlockConnector> iterator;
                    {
                        this.iterator = LittleStructure.this.blocks.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.first || this.iterator.hasNext();
                    }

                    @Override
                    public TileEntityLittleTiles next() {
                        if (this.first) {
                            this.first = false;
                            return LittleStructure.this.mainBlock.getTe();
                        }
                        try {
                            return this.iterator.next().getTileEntity();
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    public Iterable<IStructureTileList> blocksList() throws CorruptedConnectionException, NotYetConnectedException {
        this.load();
        return new Iterable<IStructureTileList>(){

            @Override
            public Iterator<IStructureTileList> iterator() {
                return new Iterator<IStructureTileList>(){
                    boolean first = true;
                    Iterator<StructureBlockConnector> iterator;
                    {
                        this.iterator = LittleStructure.this.blocks.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.first || this.iterator.hasNext();
                    }

                    @Override
                    public IStructureTileList next() {
                        if (this.first) {
                            this.first = false;
                            return LittleStructure.this.mainBlock;
                        }
                        try {
                            return this.iterator.next().getList();
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    public Iterable<Pair<IStructureTileList, LittleTile>> tiles() throws CorruptedConnectionException, NotYetConnectedException {
        final Iterator<IStructureTileList> iterator = this.blocksList().iterator();
        return new Iterable<Pair<IStructureTileList, LittleTile>>(){

            @Override
            public Iterator<Pair<IStructureTileList, LittleTile>> iterator() {
                return new Iterator<Pair<IStructureTileList, LittleTile>>(){
                    Iterator<LittleTile> inBlock = null;
                    Pair<IStructureTileList, LittleTile> pair = null;

                    @Override
                    public boolean hasNext() {
                        while (this.inBlock == null || !this.inBlock.hasNext()) {
                            if (!iterator.hasNext()) {
                                return false;
                            }
                            IStructureTileList list = (IStructureTileList)iterator.next();
                            this.pair = new Pair((Object)list, null);
                            this.inBlock = list.iterator();
                        }
                        return true;
                    }

                    @Override
                    public Pair<IStructureTileList, LittleTile> next() {
                        this.pair.setValue((Object)this.inBlock.next());
                        return this.pair;
                    }
                };
            }
        };
    }

    public HashMapList<BlockPos, IStructureTileList> collectAllBlocksListSameWorld() throws CorruptedConnectionException, NotYetConnectedException {
        return this.collectAllBlocksListSameWorld((HashMapList<BlockPos, IStructureTileList>)new HashMapList());
    }

    protected HashMapList<BlockPos, IStructureTileList> collectAllBlocksListSameWorld(HashMapList<BlockPos, IStructureTileList> map) throws CorruptedConnectionException, NotYetConnectedException {
        for (IStructureTileList list : this.blocksList()) {
            map.add((Object)list.getPos(), (Object)list);
        }
        for (StructureChildConnection child : this.children) {
            if (child.isLinkToAnotherWorld()) continue;
            child.getStructure().collectAllBlocksListSameWorld(map);
        }
        return map;
    }

    public void placedStructure(@Nullable ItemStack stack) {
        NBTTagCompound nbt;
        if (this.name == null && stack != null && (nbt = stack.func_179543_a("display")) != null && nbt.func_150297_b("Name", 8)) {
            this.name = nbt.func_74779_i("Name");
        }
        if (!this.isClient()) {
            this.schedule();
        }
    }

    public void notifyAfterPlaced() {
        this.afterPlaced();
        for (StructureChildConnection child : this.children) {
            try {
                child.getStructure().notifyAfterPlaced();
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        }
    }

    protected void afterPlaced() {
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        Object pos;
        int i;
        this.blocks.clear();
        if (nbt.func_74764_b("count")) {
            int count = nbt.func_74762_e("count");
            for (i = 0; i < count; ++i) {
                LittleIdentifierRelative coord = null;
                if (nbt.func_74764_b("i" + i + "coX")) {
                    pos = new LittleTile.LittleTilePosition("i" + i, nbt);
                    coord = new LittleIdentifierRelative(((LittleTile.LittleTilePosition)pos).coord.func_177958_n() - this.getPos().func_177958_n(), ((LittleTile.LittleTilePosition)pos).coord.func_177956_o() - this.getPos().func_177956_o(), ((LittleTile.LittleTilePosition)pos).coord.func_177952_p() - this.getPos().func_177952_p(), LittleGridContext.get(), new int[]{((LittleTile.LittleTilePosition)pos).position.x, ((LittleTile.LittleTilePosition)pos).position.y, ((LittleTile.LittleTilePosition)pos).position.z});
                } else {
                    coord = LittleIdentifierRelative.loadIdentifierOld("i" + i, nbt);
                }
                this.blocks.add(new StructureBlockConnector(coord.coord));
            }
        } else if (nbt.func_74764_b("tiles")) {
            NBTTagList list = nbt.func_150295_c("tiles", 11);
            for (i = 0; i < list.func_74745_c(); ++i) {
                int[] array = list.func_150306_c(i);
                if (array.length == 4) {
                    pos = new RelativeBlockPos(array);
                    if (((RelativeBlockPos)pos).getRelativePos().equals((Object)BlockPos.field_177992_a)) continue;
                    this.blocks.add(new StructureBlockConnector(((RelativeBlockPos)pos).getRelativePos()));
                    continue;
                }
                System.out.println("Found invalid array! " + nbt);
            }
        } else if (nbt.func_74764_b("blocks")) {
            this.blocks.clear();
            int[] array = nbt.func_74759_k("blocks");
            i = 0;
            while (i + 2 < array.length) {
                this.blocks.add(new StructureBlockConnector(new BlockPos(array[i], array[i + 1], array[i + 2])));
                i += 3;
            }
        }
        this.name = nbt.func_74764_b("name") ? nbt.func_74779_i("name") : null;
        this.parent = nbt.func_74764_b("parent") ? StructureChildConnection.loadFromNBT(this, nbt.func_74775_l("parent"), true) : null;
        if (nbt.func_74764_b("children")) {
            NBTTagList list = nbt.func_150295_c("children", 10);
            this.children = new ChildrenList();
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.children.set(StructureChildConnection.loadFromNBT(this, list.func_150305_b(i), false));
            }
            if (this instanceof IAnimatedStructure && ((IAnimatedStructure)((Object)this)).isAnimated()) {
                for (StructureChildConnection child : this.children) {
                    if (!(child instanceof StructureChildToSubWorldConnection) || !((StructureChildToSubWorldConnection)child).entityUUID.equals(((IAnimatedStructure)((Object)this)).getAnimation().func_110124_au())) continue;
                    throw new RuntimeException("Something went wrong during loading!");
                }
            }
        } else {
            this.children = new ChildrenList();
        }
        for (StructureDirectionalField field : this.type.directional) {
            if (nbt.func_74764_b(field.saveKey)) {
                field.createAndSet(this, nbt);
                continue;
            }
            field.set(this, this.failedLoadingRelative(nbt, field));
        }
        if (nbt.func_74764_b("signal")) {
            NBTTagList list = nbt.func_150295_c("signal", 10);
            this.externalHandler = new HashMap();
            for (int i2 = 0; i2 < list.func_74745_c(); ++i2) {
                try {
                    SignalExternalOutputHandler handler = new SignalExternalOutputHandler(this, list.func_150305_b(i2));
                    this.externalHandler.put(handler.index, handler);
                    continue;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        this.loadFromNBTExtra(nbt);
        if (this.inputs != null) {
            for (int i3 = 0; i3 < this.inputs.length; ++i3) {
                this.inputs[i3].load(nbt);
            }
        }
        if (this.outputs != null) {
            for (int i4 = 0; i4 < this.outputs.length; ++i4) {
                this.outputs[i4].load(nbt.func_74775_l(((LittleStructureType.InternalComponentOutput)this.outputs[i4].component).identifier));
            }
        }
    }

    protected Object failedLoadingRelative(NBTTagCompound nbt, StructureDirectionalField field) {
        return field.getDefault();
    }

    protected abstract void loadFromNBTExtra(NBTTagCompound var1);

    public NBTTagCompound writeToNBTPreview(NBTTagCompound nbt, BlockPos newCenter) {
        LittleVecContext vec = new LittleVecContext(new LittleVec(this.mainBlock.getContext(), (Vec3i)this.getPos().func_177973_b((Vec3i)newCenter)), this.mainBlock.getContext());
        LittleVec inverted = vec.getVec().copy();
        inverted.invert();
        for (StructureDirectionalField field : this.type.directional) {
            Object value = field.get(this);
            field.move(value, vec.getContext(), vec.getVec());
            field.save(nbt, value);
            field.move(value, vec.getContext(), inverted);
        }
        this.writeToNBTExtraInternal(nbt, true);
        return nbt;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.parent != null) {
            nbt.func_74782_a("parent", (NBTBase)this.parent.writeToNBT(new NBTTagCompound()));
        }
        if (this.children != null && !this.children.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (StructureChildConnection child : this.children) {
                list.func_74742_a((NBTBase)child.writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("children", (NBTBase)list);
        }
        int[] array = new int[this.blocks.size() * 3];
        for (int i = 0; i < this.blocks.size(); ++i) {
            StructureBlockConnector block = this.blocks.get(i);
            array[i * 3] = block.pos.func_177958_n();
            array[i * 3 + 1] = block.pos.func_177956_o();
            array[i * 3 + 2] = block.pos.func_177952_p();
        }
        nbt.func_74783_a("blocks", array);
        for (StructureDirectionalField field : this.type.directional) {
            Object value = field.get(this);
            field.save(nbt, value);
        }
        this.writeToNBTExtraInternal(nbt, false);
    }

    protected void writeToNBTExtraInternal(NBTTagCompound nbt, boolean preview) {
        nbt.func_74778_a("id", this.type.id);
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        } else {
            nbt.func_82580_o("name");
        }
        if (this.externalHandler != null && !this.externalHandler.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (SignalExternalOutputHandler handler : this.externalHandler.values()) {
                list.func_74742_a((NBTBase)handler.write(preview));
            }
            nbt.func_74782_a("signal", (NBTBase)list);
        }
        if (this.inputs != null) {
            for (int i = 0; i < this.inputs.length; ++i) {
                this.inputs[i].write(preview, nbt);
            }
        }
        if (this.outputs != null) {
            for (int i = 0; i < this.outputs.length; ++i) {
                nbt.func_74782_a(((LittleStructureType.InternalComponentOutput)this.outputs[i].component).identifier, (NBTBase)this.outputs[i].write(preview, new NBTTagCompound()));
            }
        }
        this.writeToNBTExtra(nbt);
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);

    public void unload() {
    }

    public void onLittleTileDestroy() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.parent != null) {
            this.parent.getStructure().onLittleTileDestroy();
            return;
        }
        this.load();
        LittleNeighborUpdateCollector neighbor = new LittleNeighborUpdateCollector(this.getWorld());
        this.removeStructure(neighbor);
        neighbor.process();
    }

    public void removeStructure(LittleNeighborUpdateCollector neighbor) throws CorruptedConnectionException, NotYetConnectedException {
        this.load();
        this.onStructureDestroyed();
        for (StructureChildConnection child : this.children) {
            child.destroyStructure(neighbor);
        }
        if (this instanceof IAnimatedStructure && ((IAnimatedStructure)((Object)this)).isAnimated()) {
            ((IAnimatedStructure)((Object)this)).destroyAnimation();
        } else {
            neighbor.add(this.mainBlock.getPos());
            for (StructureBlockConnector block : this.blocks) {
                neighbor.add(block.getAbsolutePos());
                block.remove();
            }
            this.mainBlock.getTe().updateTilesSecretly(x -> x.removeStructure(this.getIndex()));
        }
    }

    public void callStructureDestroyedToSameWorld() {
        for (StructureChildConnection child : this.children) {
            if (child.isLinkToAnotherWorld()) continue;
            try {
                child.getStructure().callStructureDestroyedToSameWorld();
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        }
        this.onStructureDestroyed();
    }

    @Override
    public void onStructureDestroyed() {
        this.unload();
    }

    public Iterable<ISignalStructureComponent> inputs() {
        return new Iterable<ISignalStructureComponent>(){

            @Override
            public Iterator<ISignalStructureComponent> iterator() {
                return new Iterator<ISignalStructureComponent>(){
                    Iterator<StructureChildConnection> iterator;
                    ISignalStructureComponent next;
                    {
                        this.iterator = LittleStructure.this.children.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            while (this.iterator.hasNext()) {
                                StructureChildConnection connection = this.iterator.next();
                                try {
                                    if (!(connection.getStructure() instanceof ISignalStructureComponent) || ((ISignalStructureComponent)((Object)connection.getStructure())).getType() != SignalComponentType.INPUT) continue;
                                    this.next = (ISignalStructureComponent)((Object)connection.getStructure());
                                    break;
                                }
                                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                                }
                            }
                        }
                        return this.next != null;
                    }

                    @Override
                    public ISignalStructureComponent next() {
                        ISignalStructureComponent result = this.next;
                        this.next = null;
                        return result;
                    }
                };
            }
        };
    }

    public Iterable<ISignalStructureComponent> outputs() {
        return new Iterable<ISignalStructureComponent>(){

            @Override
            public Iterator<ISignalStructureComponent> iterator() {
                return new Iterator<ISignalStructureComponent>(){
                    Iterator<StructureChildConnection> iterator;
                    ISignalStructureComponent next;
                    {
                        this.iterator = LittleStructure.this.children.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            while (this.iterator.hasNext()) {
                                StructureChildConnection connection = this.iterator.next();
                                try {
                                    if (!(connection.getStructure() instanceof ISignalStructureComponent) || ((ISignalStructureComponent)((Object)connection.getStructure())).getType() != SignalComponentType.OUTPUT) continue;
                                    this.next = (ISignalStructureComponent)((Object)connection.getStructure());
                                    break;
                                }
                                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                                }
                            }
                        }
                        return this.next != null;
                    }

                    @Override
                    public ISignalStructureComponent next() {
                        ISignalStructureComponent result = this.next;
                        this.next = null;
                        return result;
                    }
                };
            }
        };
    }

    @Override
    public void notifyChange() {
        if (this.parent != null) {
            try {
                this.parent.getStructure().notifyChange();
                return;
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }
        this.processSignalChanges();
    }

    protected void processSignalChanges() {
        if (this.externalHandler != null && !this.externalHandler.isEmpty()) {
            for (SignalExternalOutputHandler handler : this.externalHandler.values()) {
                handler.update();
            }
        }
        if (this.outputs != null) {
            for (int i = 0; i < this.outputs.length; ++i) {
                this.outputs[i].update();
            }
        }
        for (StructureChildConnection child : this.children) {
            try {
                child.getStructure().processSignalChanges();
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        }
    }

    @Override
    public boolean isStillAvailable() {
        return !this.mainBlock.isRemoved();
    }

    @Override
    public boolean hasChanged() {
        return this.signalChanged;
    }

    @Override
    public void markChanged() {
        this.signalChanged = true;
    }

    @Override
    public void markUnchanged() {
        this.signalChanged = false;
    }

    public void changed(ISignalComponent changed) {
        this.schedule();
    }

    public InternalSignalInput getInput(int id) {
        if (this.inputs != null && id < this.inputs.length) {
            return this.inputs[id];
        }
        return null;
    }

    public InternalSignalOutput getOutput(int id) {
        if (this.outputs != null && id < this.outputs.length) {
            return this.outputs[id];
        }
        return null;
    }

    public void performInternalOutputChange(InternalSignalOutput output) {
    }

    public void receiveInternalOutputChange(InternalSignalOutput output) {
    }

    public void setExternalHandler(HashMap<Integer, SignalExternalOutputHandler> handlers) {
        this.externalHandler = handlers;
    }

    public LittleAbsolutePreviews getAbsolutePreviews(BlockPos pos) throws CorruptedConnectionException, NotYetConnectedException {
        NBTTagCompound structureNBT = new NBTTagCompound();
        this.writeToNBTPreview(structureNBT, pos);
        LittleAbsolutePreviews previews = new LittleAbsolutePreviews(structureNBT, pos, LittleGridContext.getMin());
        for (Pair<IStructureTileList, LittleTile> pair : this.tiles()) {
            previews.addTile((IParentTileList)pair.key, (LittleTile)pair.value);
        }
        for (StructureChildConnection child : this.children) {
            previews.addChild(child.getStructure().getPreviews(pos), child.dynamic);
        }
        previews.convertToSmallest();
        return previews;
    }

    public LittlePreviews getPreviews(BlockPos pos) throws CorruptedConnectionException, NotYetConnectedException {
        NBTTagCompound structureNBT = new NBTTagCompound();
        this.writeToNBTPreview(structureNBT, pos);
        LittlePreviews previews = new LittlePreviews(structureNBT, LittleGridContext.getMin());
        for (Pair<IStructureTileList, LittleTile> pair : this.tiles()) {
            LittlePreview preview = previews.addTile((IParentTileList)pair.key, (LittleTile)pair.value);
            preview.box.add(new LittleVec(previews.getContext(), (Vec3i)((IStructureTileList)pair.key).getPos().func_177973_b((Vec3i)pos)));
        }
        for (StructureChildConnection child : this.children) {
            previews.addChild(child.getStructure().getPreviews(pos), child.dynamic);
        }
        previews.convertToSmallest();
        return previews;
    }

    public LittleAbsolutePreviews getAbsolutePreviewsSameWorldOnly(BlockPos pos) throws CorruptedConnectionException, NotYetConnectedException {
        NBTTagCompound structureNBT = new NBTTagCompound();
        this.writeToNBTPreview(structureNBT, pos);
        LittleAbsolutePreviews previews = new LittleAbsolutePreviews(structureNBT, pos, LittleGridContext.getMin());
        for (Pair<IStructureTileList, LittleTile> pair : this.tiles()) {
            previews.addTile((IParentTileList)pair.key, (LittleTile)pair.value);
        }
        for (StructureChildConnection child : this.children) {
            if (!child.isLinkToAnotherWorld()) {
                previews.addChild(child.getStructure().getPreviewsSameWorldOnly(pos), child.dynamic);
                continue;
            }
            previews.addChild(new LittlePreviewsStructureHolder(child.getStructure()), child.dynamic);
        }
        previews.convertToSmallest();
        return previews;
    }

    public LittlePreviews getPreviewsSameWorldOnly(BlockPos pos) throws CorruptedConnectionException, NotYetConnectedException {
        NBTTagCompound structureNBT = new NBTTagCompound();
        this.writeToNBTPreview(structureNBT, pos);
        LittlePreviews previews = new LittlePreviews(structureNBT, LittleGridContext.getMin());
        for (Pair<IStructureTileList, LittleTile> pair : this.tiles()) {
            LittlePreview preview = previews.addTile((IParentTileList)pair.key, (LittleTile)pair.value);
            preview.box.add(new LittleVec(previews.getContext(), (Vec3i)((IStructureTileList)pair.key).getPos().func_177973_b((Vec3i)pos)));
        }
        for (StructureChildConnection child : this.children) {
            if (!child.isLinkToAnotherWorld()) {
                previews.addChild(child.getStructure().getPreviews(pos), child.dynamic);
                continue;
            }
            previews.addChild(new LittlePreviewsStructureHolder(child.getStructure()), child.dynamic);
        }
        previews.convertToSmallest();
        return previews;
    }

    public BlockPos.MutableBlockPos getMinPos(BlockPos.MutableBlockPos pos) throws CorruptedConnectionException, NotYetConnectedException {
        for (BlockPos tePos : this.positions()) {
            pos.func_181079_c(Math.min(pos.func_177958_n(), tePos.func_177958_n()), Math.min(pos.func_177956_o(), tePos.func_177956_o()), Math.min(pos.func_177952_p(), tePos.func_177952_p()));
        }
        for (StructureChildConnection child : this.children) {
            child.getStructure().getMinPos(pos);
        }
        return pos;
    }

    public void transferChildrenToAnimation(EntityAnimation animation) throws CorruptedConnectionException, NotYetConnectedException {
        for (StructureChildConnection child : this.children) {
            LittleStructure childStructure = child.getStructure();
            if (child.isLinkToAnotherWorld()) {
                EntityAnimation subAnimation = ((IAnimatedStructure)((Object)childStructure)).getAnimation();
                int l1 = subAnimation.field_70176_ah;
                int i2 = subAnimation.field_70164_aj;
                World world = this.getWorld();
                if (subAnimation.field_70175_ag) {
                    Chunk chunk = world.func_72964_e(l1, i2);
                    if (chunk != null) {
                        chunk.func_76622_b((Entity)subAnimation);
                    }
                    subAnimation.field_70175_ag = false;
                }
                world.field_72996_f.remove(subAnimation);
                subAnimation.setParentWorld((World)animation.fakeWorld);
                animation.fakeWorld.func_72838_d((Entity)subAnimation);
                subAnimation.updateTickState();
                childStructure.updateParentConnection(child.childId, this, child.dynamic);
                this.updateChildConnection(child.childId, childStructure, child.dynamic);
                continue;
            }
            childStructure.transferChildrenToAnimation(animation);
        }
    }

    public void transferChildrenFromAnimation(EntityAnimation animation) throws CorruptedConnectionException, NotYetConnectedException {
        World parentWorld = animation.fakeWorld.getParent();
        for (StructureChildConnection child : this.children) {
            LittleStructure childStructure = child.getStructure();
            if (child.isLinkToAnotherWorld()) {
                EntityAnimation subAnimation = ((IAnimatedStructure)((Object)childStructure)).getAnimation();
                int l1 = subAnimation.field_70176_ah;
                int i2 = subAnimation.field_70164_aj;
                if (subAnimation.field_70175_ag) {
                    Chunk chunk = animation.fakeWorld.func_72964_e(l1, i2);
                    if (chunk != null) {
                        chunk.func_76622_b((Entity)subAnimation);
                    }
                    subAnimation.field_70175_ag = false;
                }
                animation.fakeWorld.field_72996_f.remove(subAnimation);
                subAnimation.setParentWorld(parentWorld);
                parentWorld.func_72838_d((Entity)subAnimation);
                subAnimation.updateTickState();
                continue;
            }
            childStructure.transferChildrenFromAnimation(animation);
        }
    }

    public SurroundingBox getSurroundingBox() throws CorruptedConnectionException, NotYetConnectedException {
        SurroundingBox box = new SurroundingBox(true, this.getWorld());
        box.add(this.mainBlock);
        for (StructureBlockConnector block : this.blocks) {
            box.add(block.getList());
        }
        return box;
    }

    public double getPercentVolume() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getSurroundingBox().getPercentVolume();
    }

    public Vec3d getHighestCenterVec() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getSurroundingBox().getHighestCenterVec();
    }

    public LittleAbsoluteVec getHighestCenterPoint() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getSurroundingBox().getHighestCenterPoint();
    }

    public void updateStructure() {
        if (this.getWorld() == null || this.getWorld().field_72995_K) {
            return;
        }
        LittleEventHandler.queueStructureForUpdatePacket(this);
    }

    public void sendUpdatePacket() {
        if (this.mainBlock.isRemoved()) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new LittleUpdateStructurePacket(this.getStructureLocation(), nbt), (World)this.getWorld(), (BlockPos)this.getPos(), null);
    }

    public ItemStack getStructureDrop() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.parent != null) {
            return this.parent.getStructure().getStructureDrop();
        }
        this.load();
        BlockPos.MutableBlockPos pos = this.getMinPos(new BlockPos.MutableBlockPos(this.getPos()));
        ItemStack stack = new ItemStack(LittleTiles.multiTiles);
        LittlePreviews previews = this.getPreviews((BlockPos)pos);
        LittlePreview.savePreview(previews, stack);
        if (this.name != null) {
            NBTTagCompound display = new NBTTagCompound();
            display.func_74778_a("Name", this.name);
            stack.func_77978_p().func_74782_a("display", (NBTBase)display);
        }
        return stack;
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        return false;
    }

    public boolean isBed(EntityLivingBase player) {
        return false;
    }

    public void onEntityCollidedWithBlockAnimation(EntityAnimation animation, HashMap<Entity, AxisAlignedBB> entities) {
    }

    public void checkForAnimationCollision(EntityAnimation animation, HashMap<Entity, AxisAlignedBB> entities) throws CorruptedConnectionException, NotYetConnectedException {
        if (!this.hasAttributeIncludeChildrenSameWorldOnly(131072)) {
            return;
        }
        AxisAlignedBB box = this.getSurroundingBox().getAABB();
        HashMap<Entity, AxisAlignedBB> collided = new HashMap<Entity, AxisAlignedBB>();
        for (Map.Entry<Entity, AxisAlignedBB> entry : entities.entrySet()) {
            if (!entry.getValue().func_72326_a(box)) continue;
            collided.put(entry.getKey(), entry.getValue());
        }
        if (!collided.isEmpty()) {
            this.onEntityCollidedWithBlockAnimation(animation, collided);
        }
        for (StructureChildConnection child : this.children) {
            LittleStructure structure = child.getStructure();
            if (child.isLinkToAnotherWorld() || !this.hasAttributeIncludeChildrenSameWorldOnly(131072)) continue;
            structure.checkForAnimationCollision(animation, entities);
        }
    }

    public void onEntityCollidedWithBlock(World worldIn, IParentTileList parent, BlockPos pos, Entity entityIn) {
    }

    public void onUpdatePacketReceived() {
    }

    public int getLightValue(BlockPos pos) {
        return 0;
    }

    public float getExplosionResistance() {
        return 0.0f;
    }

    public boolean hasStructureColor() {
        return false;
    }

    public int getStructureColor() {
        return -1;
    }

    public int getDefaultColor() {
        return -1;
    }

    public void paint(int color) {
    }

    public void tick() {
    }

    public void queueForNextTick() {
        LittleEventHandler.queueStructureForNextTick(this);
    }

    public boolean queueTick() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTick(BlockPos pos, double x, double y, double z, float partialTickTime) {
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void getRenderingCubes(BlockPos pos, BlockRenderLayer layer, List<LittleRenderBox> cubes) {
    }

    public void addCollisionBoxes(BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
    }

    public void neighbourChanged() {
    }

    @Deprecated
    public void flipForWarpDrive(LittleGridContext context, EnumFacing.Axis axis) {
        ArrayList<StructureBlockConnector> newBlocks = new ArrayList<StructureBlockConnector>(this.blocks.size());
        for (StructureBlockConnector block : this.blocks) {
            newBlocks.add(new StructureBlockConnector(RotationUtils.flip((BlockPos)block.pos, (EnumFacing.Axis)axis)));
        }
        this.blocks.clear();
        this.blocks.addAll(newBlocks);
        for (StructureDirectionalField relative : this.type.directional) {
            relative.flip(relative.get(this), context, axis, context.rotationCenter);
        }
    }

    @Deprecated
    public void rotateForWarpDrive(LittleGridContext context, Rotation rotation, int steps) {
        ArrayList<StructureBlockConnector> newBlocks = new ArrayList<StructureBlockConnector>(this.blocks.size());
        for (StructureBlockConnector block : this.blocks) {
            BlockPos pos = block.pos;
            for (int rotationStep = 0; rotationStep < steps; ++rotationStep) {
                pos = RotationUtils.rotate((BlockPos)pos, (Rotation)rotation);
            }
            newBlocks.add(new StructureBlockConnector(pos));
        }
        this.blocks.clear();
        this.blocks.addAll(newBlocks);
        for (StructureDirectionalField relative : this.type.directional) {
            relative.rotate(relative.get(this), context, rotation, context.rotationCenter);
        }
    }

    public String info() {
        ArrayList<String> infos = new ArrayList<String>();
        if (this.inputs != null) {
            for (int i = 0; i < this.inputs.length; ++i) {
                infos.add("a" + i + ":" + BooleanUtils.print((boolean[])this.inputs[i].getState()));
            }
        }
        for (ISignalStructureComponent component : this.inputs()) {
            try {
                infos.add("i" + component.getId() + ":" + BooleanUtils.print((boolean[])component.getState()) + component.getNetwork());
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                infos.add("i" + component.getId() + ":broken");
            }
        }
        if (this.outputs != null) {
            for (int i = 0; i < this.outputs.length; ++i) {
                infos.add("b" + i + ":" + BooleanUtils.print((boolean[])this.outputs[i].getState()));
            }
        }
        for (ISignalStructureComponent component : this.outputs()) {
            try {
                infos.add("o" + component.getId() + ":" + BooleanUtils.print((boolean[])component.getState()) + component.getNetwork());
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                infos.add("o" + component.getId() + ":broken");
            }
        }
        return String.join((CharSequence)",", infos);
    }

    public class StructureBlockConnector {
        public final BlockPos pos;
        private TileEntityLittleTiles cachedTe;

        public StructureBlockConnector(BlockPos pos) {
            this.pos = pos;
        }

        public BlockPos getAbsolutePos() {
            return LittleStructure.this.getPos().func_177971_a((Vec3i)this.pos);
        }

        public TileEntityLittleTiles getTileEntity() throws CorruptedConnectionException, NotYetConnectedException {
            BlockPos absoluteCoord;
            World world;
            Chunk chunk;
            if (this.cachedTe != null) {
                if (this.cachedTe.func_145837_r()) {
                    this.cachedTe = null;
                } else {
                    return this.cachedTe;
                }
            }
            if (WorldUtils.checkIfChunkExists((Chunk)(chunk = (world = LittleStructure.this.getWorld()).func_175726_f(absoluteCoord = this.getAbsolutePos())))) {
                TileEntity te = world.func_175625_s(absoluteCoord);
                if (te instanceof TileEntityLittleTiles) {
                    this.cachedTe = (TileEntityLittleTiles)te;
                    return this.cachedTe;
                }
                throw new MissingBlockException(absoluteCoord);
            }
            throw new NotYetConnectedException();
        }

        public void connect() throws CorruptedConnectionException, NotYetConnectedException {
            TileEntityLittleTiles te = this.getTileEntity();
            if (!te.hasLoaded()) {
                throw new NotYetConnectedException();
            }
            IStructureTileList structure = te.getStructure(LittleStructure.this.getIndex());
            if (structure == null) {
                throw new MissingStructureException(te.func_174877_v());
            }
        }

        public IStructureTileList getList() throws CorruptedConnectionException, NotYetConnectedException {
            TileEntityLittleTiles te = this.getTileEntity();
            if (!te.hasLoaded()) {
                throw new NotYetConnectedException();
            }
            IStructureTileList structure = te.getStructure(LittleStructure.this.getIndex());
            if (structure != null) {
                return structure;
            }
            throw new MissingStructureException(te.func_174877_v());
        }

        public int count() throws CorruptedConnectionException, NotYetConnectedException {
            return this.getList().size();
        }

        public void remove() throws CorruptedConnectionException, NotYetConnectedException {
            this.getTileEntity().updateTiles(x -> x.removeStructure(LittleStructure.this.getIndex()));
        }
    }
}

