/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.entity.EntitySit;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.connection.StructureChildConnection;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleChair
extends LittleStructure {
    private UUID sitUUID;
    private EntityPlayer player;

    public LittleChair(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.sitUUID = nbt.func_74764_b("sit") ? UUID.fromString(nbt.func_74779_i("sit")) : null;
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        if (this.sitUUID != null) {
            nbt.func_74778_a("sit", this.sitUUID.toString());
        } else {
            nbt.func_82580_o("sit");
        }
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
        if (!this.getWorld().field_72995_K) {
            this.getInput(0).updateState(BooleanUtils.asArray((player != null ? 1 : 0) != 0));
        }
        if (this.player == null) {
            this.sitUUID = null;
        }
    }

    @Override
    protected void afterPlaced() {
        super.afterPlaced();
        if (this.sitUUID != null) {
            World world = this.getWorld();
            if (world instanceof IOrientatedWorld) {
                if (world instanceof CreativeWorld && ((CreativeWorld)world).parent == null) {
                    return;
                }
                world = ((IOrientatedWorld)world).getRealWorld();
            }
            for (Entity entity : world.field_72996_f) {
                if (!entity.func_110124_au().equals(this.sitUUID) || !(entity instanceof EntitySit)) continue;
                EntitySit sit = (EntitySit)entity;
                StructureChildConnection temp = this.generateConnection(sit);
                sit.func_184212_Q().func_187227_b(EntitySit.CONNECTION, (Object)temp.writeToNBT(new NBTTagCompound()));
                break;
            }
        }
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (!world.field_72995_K) {
            if (this.player != null) {
                return true;
            }
            try {
                LittleAbsoluteVec vec = this.getHighestCenterPoint();
                if (vec != null) {
                    if (world instanceof IOrientatedWorld) {
                        world = ((IOrientatedWorld)world).getRealWorld();
                    }
                    EntitySit sit = new EntitySit(this, world, vec.getPosX(), vec.getPosY() - 0.25, vec.getPosZ());
                    this.sitUUID = sit.getPersistentID();
                    player.func_184220_m((Entity)sit);
                    world.func_72838_d((Entity)sit);
                    this.setPlayer(player);
                }
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static class LittleChairParser
    extends LittleStructureGuiParser {
        public LittleChairParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, LittleStructure structure) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleStructure parseStructure(LittlePreviews previews) {
            return this.createStructure(LittleChair.class, null);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleChair.class);
        }
    }
}

