/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.parent;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.IStructureConnection;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.CorruptedLinkException;
import com.creativemd.littletiles.common.structure.exception.MissingBlockException;
import com.creativemd.littletiles.common.structure.exception.MissingStructureException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.LittleFixedStructure;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.parent.ParentTileList;
import com.creativemd.littletiles.common.tile.parent.TileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.security.InvalidParameterException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class StructureTileList
extends ParentTileList
implements IStructureTileList,
IStructureConnection {
    private TileList parent;
    private Object cache;
    private int structureIndex;
    private int attribute;
    private BlockPos relativePos;

    public StructureTileList(TileList parent, int index, int attribute) {
        this.parent = parent;
        this.structureIndex = index;
        this.attribute = attribute;
    }

    public StructureTileList(TileList parent, NBTTagCompound nbt) {
        this.parent = parent;
        this.read(nbt);
    }

    public void setParent(TileList parent) {
        this.parent = parent;
    }

    @Override
    protected void readExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b("structure")) {
            NBTTagCompound structureNBT = nbt.func_74775_l("structure");
            this.cache = StructureTileList.create(structureNBT, this);
        } else {
            int[] array = nbt.func_74759_k("coord");
            if (array.length == 3) {
                this.relativePos = new BlockPos(array[0], array[1], array[2]);
            } else {
                throw new InvalidParameterException("No valid coord given " + nbt);
            }
        }
        this.attribute = nbt.func_74762_e("type");
        this.structureIndex = nbt.func_74762_e("index");
    }

    @Override
    protected void writeExtra(NBTTagCompound nbt) {
        if (this.isMain()) {
            NBTTagCompound structureNBT = new NBTTagCompound();
            ((LittleStructure)this.cache).writeToNBT(structureNBT);
            nbt.func_74782_a("structure", (NBTBase)structureNBT);
        } else {
            nbt.func_74783_a("coord", new int[]{this.relativePos.func_177958_n(), this.relativePos.func_177956_o(), this.relativePos.func_177952_p()});
        }
        nbt.func_74768_a("type", this.attribute);
        nbt.func_74768_a("index", this.structureIndex);
    }

    @Override
    public boolean isStructure() {
        return true;
    }

    @Override
    public boolean isStructureChild(LittleStructure structure) throws CorruptedConnectionException, NotYetConnectedException {
        return this.getStructure().isChildOf(structure);
    }

    @Override
    public TileEntityLittleTiles getTe() {
        return this.parent.te;
    }

    @Override
    public int getAttribute() {
        if (this.isMain()) {
            return this.attribute;
        }
        return this.attribute & 0xFF00FF;
    }

    @Override
    public void setAttribute(int attribute) {
        this.attribute = attribute;
        this.getTe().updateTiles(false);
    }

    @Override
    public BlockPos getStructurePosition() {
        return this.relativePos.func_177971_a((Vec3i)this.getPos());
    }

    public LittleStructure setStructureNBT(NBTTagCompound nbt) {
        if (this.cache instanceof LittleStructure && ((LittleStructure)this.cache).type.id.equals(nbt.func_74779_i("id"))) {
            ((LittleStructure)this.cache).loadFromNBT(nbt);
        } else {
            if (this.cache instanceof LittleStructure) {
                ((LittleStructure)this.cache).unload();
            }
            this.cache = StructureTileList.create(nbt, this);
        }
        return (LittleStructure)this.cache;
    }

    @Override
    public LittleStructure getStructure() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.isMain()) {
            return (LittleStructure)this.cache;
        }
        TileEntityLittleTiles te = this.getTileEntity();
        if (!te.hasLoaded()) {
            throw new NotYetConnectedException();
        }
        IStructureTileList structure = te.getStructure(this.structureIndex);
        if (structure != null) {
            if (structure == this || !structure.isMain()) {
                throw new CorruptedLinkException();
            }
            return structure.getStructure();
        }
        throw new MissingStructureException(te.func_174877_v());
    }

    protected TileEntityLittleTiles getTileEntity() throws CorruptedConnectionException, NotYetConnectedException {
        BlockPos absoluteCoord;
        if (this.isMain()) {
            throw new RuntimeException("Main block cannot look for tileentity");
        }
        if (this.cache instanceof TileEntityLittleTiles && !((TileEntityLittleTiles)this.cache).func_145837_r()) {
            return (TileEntityLittleTiles)this.cache;
        }
        if (this.relativePos == null) {
            throw new CorruptedLinkException();
        }
        World world = this.getTe().func_145831_w();
        Chunk chunk = world.func_175726_f(absoluteCoord = this.getStructurePosition());
        if (WorldUtils.checkIfChunkExists((Chunk)chunk)) {
            TileEntity te = world.func_175625_s(absoluteCoord);
            if (te instanceof TileEntityLittleTiles) {
                this.cache = te;
                return (TileEntityLittleTiles)this.cache;
            }
            throw new MissingBlockException(absoluteCoord);
        }
        throw new NotYetConnectedException();
    }

    @Override
    public boolean isMain() {
        return this.relativePos == null;
    }

    @Override
    public boolean isClient() {
        return this.parent.isClient();
    }

    @Override
    public int getIndex() {
        return this.structureIndex;
    }

    @Override
    public boolean isRemoved() {
        return this.parent == null;
    }

    public void removed() {
        if (this.isMain()) {
            ((LittleStructure)this.cache).unload();
        }
        this.parent = null;
    }

    public void remove() {
        this.parent.removeStructure(this.structureIndex);
    }

    @Override
    public void unload() {
        super.unload();
        if (this.isMain()) {
            ((LittleStructure)this.cache).unload();
        }
    }

    @Override
    public int totalSize() {
        return this.size();
    }

    @Deprecated
    public void flipForWarpDrive(EnumFacing.Axis axis) {
        this.relativePos = RotationUtils.flip((BlockPos)this.relativePos, (EnumFacing.Axis)axis);
    }

    @Deprecated
    public void rotateForWarpDrive(Rotation rotation, int steps) {
        for (int rotationStep = 0; rotationStep < steps; ++rotationStep) {
            this.relativePos = RotationUtils.rotate((BlockPos)this.relativePos, (Rotation)rotation);
        }
    }

    public static void setRelativePos(StructureTileList list, BlockPos pos) {
        list.relativePos = pos;
    }

    public static void updateStatus(StructureTileList list) {
        if (list.cache != null) {
            list.relativePos = null;
        }
    }

    public static LittleStructure create(NBTTagCompound nbt, StructureTileList mainBlock) {
        if (nbt == null) {
            return null;
        }
        String id = nbt.func_74779_i("id");
        LittleStructureType type = LittleStructureRegistry.getStructureType(id);
        if (type != null) {
            LittleStructure structure = type.createStructure(mainBlock);
            structure.loadFromNBT(nbt);
            return structure;
        }
        System.out.println("Could not find structureID=" + id);
        LittleFixedStructure structure = new LittleFixedStructure(LittleStructureRegistry.getStructureType(LittleFixedStructure.class), mainBlock);
        structure.loadFromNBT(nbt);
        return structure;
    }
}

