/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.preview;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.combine.BasicCombiner;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleVolumes;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.registry.LittleTileRegistry;
import com.creativemd.littletiles.common.util.compression.LittleNBTCompressionTools;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class LittlePreviews
implements Iterable<LittlePreview>,
IGridBased {
    protected LittleGridContext context;
    protected LittlePreviews parent;
    protected final List<LittlePreviews> children;
    protected final List<LittlePreview> previews;
    public final NBTTagCompound structureNBT;

    public LittlePreviews(LittleGridContext context) {
        this(null, context);
    }

    public LittlePreviews(NBTTagCompound nbt, LittleGridContext context) {
        this.context = context;
        this.previews = new ArrayList<LittlePreview>();
        this.structureNBT = nbt;
        this.children = new ArrayList<LittlePreviews>();
    }

    public LittlePreviews(LittlePreviews previews) {
        this.context = previews.getContext();
        this.previews = new ArrayList<LittlePreview>(previews.previews);
        this.children = new ArrayList<LittlePreviews>(previews.children);
        this.structureNBT = null;
    }

    public LittlePreviews(NBTTagCompound nbt, LittlePreviews previews) {
        this.context = previews.getContext();
        this.previews = new ArrayList<LittlePreview>(previews.previews);
        this.children = new ArrayList<LittlePreviews>(previews.children);
        this.structureNBT = nbt;
    }

    public boolean isAbsolute() {
        return false;
    }

    public BlockPos getBlockPos() {
        return null;
    }

    public boolean hasStructure() {
        return this.structureNBT != null && this.structureNBT.func_186856_d() > 0;
    }

    public boolean hasStructureIncludeChildren() {
        if (this.hasStructure()) {
            return true;
        }
        for (LittlePreviews child : this.children) {
            if (!child.hasStructureIncludeChildren()) continue;
            return true;
        }
        return false;
    }

    public String getStructureName() {
        if (!this.hasStructure()) {
            return null;
        }
        return this.structureNBT.func_74764_b("name") ? this.structureNBT.func_74779_i("name") : null;
    }

    public String getStructureId() {
        if (this.hasStructure()) {
            return this.structureNBT.func_74779_i("id");
        }
        return null;
    }

    public LittleStructureType getStructureType() {
        if (this.hasStructure()) {
            return LittleStructureRegistry.getStructureType(this.structureNBT.func_74779_i("id"));
        }
        return null;
    }

    public boolean containsIngredients() {
        if (this.hasStructure()) {
            return !LittleStructureAttribute.premade(this.getStructureType().attribute);
        }
        return true;
    }

    public List<PlacePreview> getPlacePreviews(LittleVec offset) {
        ArrayList<PlacePreview> placePreviews = new ArrayList<PlacePreview>();
        for (LittlePreview preview : this) {
            placePreviews.add(preview.getPlaceableTile(offset));
        }
        this.getStructureTiles(placePreviews, offset);
        return placePreviews;
    }

    protected void getStructureTiles(List<PlacePreview> placePreviews, LittleVec offset) {
        if (this.hasStructure()) {
            for (PlacePreview placePreviewTile : this.getStructureType().getSpecialTiles(this)) {
                if (offset != null) {
                    placePreviewTile.add(offset);
                }
                placePreviews.add(placePreviewTile);
            }
        }
    }

    public List<PlacePreview> getPlacePreviewsIncludingChildren(LittleVec offset) {
        ArrayList<PlacePreview> placePreviews = new ArrayList<PlacePreview>();
        for (LittlePreview preview : this) {
            placePreviews.add(preview.getPlaceableTile(offset));
        }
        this.getStructureTiles(placePreviews, offset);
        if (this.hasChildren()) {
            for (LittlePreviews child : this.children) {
                placePreviews.addAll(child.getPlacePreviewsIncludingChildren(offset));
            }
        }
        return placePreviews;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public LittlePreviews getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Iterable<LittlePreviews> getChildren() {
        return this.children;
    }

    public int childrenCount() {
        return this.children.size();
    }

    public LittlePreviews getChild(int index) {
        return this.children.get(index);
    }

    public void updateChild(int index, LittlePreviews child) {
        child.parent = this;
        this.children.set((int)index, (LittlePreviews)child).parent = null;
    }

    public void addChild(LittlePreviews child, boolean dynamic) {
        if (child.isAbsolute()) {
            throw new RuntimeException("Absolute previews cannot be added as a child!");
        }
        child.parent = this;
        if (child.structureNBT != null) {
            child.structureNBT.func_74757_a("dynamic", true);
        }
        this.children.add(child);
        if (this.context.size < child.getSmallestContext().size) {
            this.convertToSmallest();
        } else if (child.context != this.context) {
            child.convertTo(this.context);
        }
    }

    public boolean isDynamic() {
        return this.structureNBT != null && this.structureNBT.func_74767_n("dynamic");
    }

    @Override
    public LittleGridContext getContext() {
        return this.context;
    }

    @Override
    public void convertToSmallest() {
        LittleGridContext context = this.getSmallestContext();
        if (context != this.context) {
            this.convertTo(context);
        }
    }

    public void movePreviews(LittleGridContext context, LittleVec offset) {
        if (context.size > this.context.size) {
            this.convertTo(context);
        } else if (context.size < this.context.size) {
            offset.convertTo(context, this.context);
        }
        context = this.context;
        for (LittlePreview preview : this.previews) {
            preview.box.add(offset);
        }
        if (this.hasStructure()) {
            this.getStructureType().move(this, context, offset);
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.children) {
                child.movePreviews(context, offset);
            }
        }
    }

    public void flipPreviews(EnumFacing.Axis axis, LittleVec doubledCenter) {
        for (LittlePreview preview : this.previews) {
            preview.flipPreview(axis, doubledCenter);
        }
        if (this.hasStructure()) {
            this.getStructureType().flip(this, this.context, axis, doubledCenter);
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.children) {
                child.flipPreviews(axis, doubledCenter);
            }
        }
    }

    public void rotatePreviews(Rotation rotation, LittleVec doubledCenter) {
        for (LittlePreview preview : this.previews) {
            preview.rotatePreview(rotation, doubledCenter);
        }
        if (this.hasStructure()) {
            this.getStructureType().rotate(this, this.context, rotation, doubledCenter);
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.children) {
                child.rotatePreviews(rotation, doubledCenter);
            }
        }
    }

    protected LittleGridContext getSmallestContext() {
        int size = LittleGridContext.minSize;
        for (LittlePreview preview : this.previews) {
            size = Math.max(size, preview.getSmallestContext(this.context));
        }
        LittleGridContext context = LittleGridContext.get(size);
        if (this.hasStructure()) {
            context = LittleGridContext.max(this.context, this.getStructureType().getMinContext(this));
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.children) {
                context = LittleGridContext.max(child.getSmallestContext(), context);
            }
        }
        return context;
    }

    @Override
    public void convertTo(LittleGridContext to) {
        if (this.context != to) {
            for (LittlePreview preview : this.previews) {
                preview.convertTo(this.context, to);
            }
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.children) {
                child.convertTo(to);
            }
        }
        this.context = to;
    }

    public LittlePreviews copy() {
        LittlePreviews previews = new LittlePreviews(this.structureNBT == null ? null : this.structureNBT.func_74737_b(), this.context);
        for (LittlePreview preview : this.previews) {
            previews.previews.add(preview.copy());
        }
        for (LittlePreviews child : this.children) {
            previews.children.add(child.copy());
        }
        return previews;
    }

    protected LittlePreview getPreview(LittleTile tile, IParentTileList parent) {
        LittlePreview preview = tile.getPreviewTile();
        LittleGridContext context = parent.getContext();
        if (this.context != context) {
            if (this.context.size > context.size) {
                preview.convertTo(context, this.context);
            } else {
                this.convertTo(context);
            }
        }
        return preview;
    }

    public LittlePreview addPreview(BlockPos pos, LittlePreview preview, LittleGridContext context) {
        if (this.context != context) {
            if (this.context.size > context.size) {
                preview.convertTo(context, this.context);
            } else {
                this.convertTo(context);
            }
        }
        this.previews.add(preview);
        return preview;
    }

    public LittlePreview addTile(IParentTileList parent, LittleTile tile) {
        LittlePreview preview = this.getPreview(tile, parent);
        this.previews.add(preview);
        return preview;
    }

    public LittlePreview addTile(IParentTileList parent, LittleTile tile, LittleVec offset) {
        LittlePreview preview = this.getPreview(tile, parent);
        preview.box.add(offset);
        return this.addPreview(null, tile.getPreviewTile(), parent.getContext());
    }

    @Override
    public Iterator<LittlePreview> iterator() {
        return this.previews.iterator();
    }

    protected Iterator<LittlePreview> allPreviewsIterator() {
        if (this.hasChildren()) {
            return new Iterator<LittlePreview>(){
                public Iterator<LittlePreview> subIterator;
                public Iterator<LittlePreviews> children;
                {
                    this.subIterator = LittlePreviews.this.iterator();
                    this.children = LittlePreviews.this.getChildren().iterator();
                }

                @Override
                public boolean hasNext() {
                    while (!this.subIterator.hasNext()) {
                        if (!this.children.hasNext()) {
                            return false;
                        }
                        this.subIterator = this.children.next().allPreviewsIterator();
                    }
                    return true;
                }

                @Override
                public LittlePreview next() {
                    return this.subIterator.next();
                }

                @Override
                public void remove() {
                    this.subIterator.remove();
                }
            };
        }
        return this.iterator();
    }

    public Iterable<LittlePreview> allPreviews() {
        return new Iterable<LittlePreview>(){

            @Override
            public Iterator<LittlePreview> iterator() {
                return LittlePreviews.this.allPreviewsIterator();
            }
        };
    }

    public static LittlePreviews getChild(LittleGridContext context, NBTTagCompound nbt) {
        LittlePreviews previews = nbt.func_74764_b("structure") ? new LittlePreviews(nbt.func_74775_l("structure"), context) : new LittlePreviews(context);
        previews = LittleNBTCompressionTools.readPreviews(previews, nbt.func_150295_c("tiles", 10));
        if (nbt.func_74764_b("children")) {
            NBTTagList list = nbt.func_150295_c("children", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound child = list.func_150305_b(i);
                previews.addChild(LittlePreviews.getChild(context, child), child.func_74767_n("dynamic"));
            }
        }
        return previews;
    }

    public static LittlePreviews getPreview(ItemStack stack, boolean allowLowResolution) {
        if (!stack.func_77942_o()) {
            return new LittlePreviews(LittleGridContext.get());
        }
        LittleGridContext context = LittleGridContext.get(stack.func_77978_p());
        if (stack.func_77978_p().func_74781_a("tiles") instanceof NBTTagInt) {
            LittlePreviews previews = new LittlePreviews(context);
            int tiles = stack.func_77978_p().func_74762_e("tiles");
            for (int i = 0; i < tiles; ++i) {
                NBTTagCompound nbt = stack.func_77978_p().func_74775_l("tile" + i);
                LittlePreview preview = LittleTileRegistry.loadPreview(nbt);
                if (preview == null) continue;
                previews.previews.add(preview);
            }
            if (stack.func_77978_p().func_74764_b("structure")) {
                return new LittlePreviews(stack.func_77978_p().func_74775_l("structure"), previews);
            }
            return previews;
        }
        if (allowLowResolution && stack.func_77978_p().func_74764_b("pos")) {
            int i;
            LittlePreviews previews = new LittlePreviews(context);
            NBTTagCompound tileData = new NBTTagCompound();
            LittleTile tile = new LittleTile(LittleTiles.dyeableBlock, 0);
            tile.saveTileExtra(tileData);
            NBTTagList list = stack.func_77978_p().func_150295_c("pos", 11);
            for (i = 0; i < list.func_74745_c(); ++i) {
                int[] array = list.func_150306_c(i);
                previews.previews.add(new LittlePreview(new LittleBox(array[0] * context.size, array[1] * context.size, array[2] * context.size, array[0] * context.size + context.maxPos, array[1] * context.size + context.maxPos, array[2] * context.size + context.maxPos), tileData));
            }
            if (stack.func_77978_p().func_74764_b("children")) {
                list = stack.func_77978_p().func_150295_c("children", 10);
                for (i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound child = list.func_150305_b(i);
                    previews.addChild(LittlePreviews.getChild(context, child), child.func_74767_n("dynamic"));
                }
            }
            return previews;
        }
        LittlePreviews previews = stack.func_77978_p().func_74764_b("structure") ? new LittlePreviews(stack.func_77978_p().func_74775_l("structure"), context) : new LittlePreviews(context);
        previews = LittleNBTCompressionTools.readPreviews(previews, stack.func_77978_p().func_150295_c("tiles", 10));
        if (stack.func_77978_p().func_74764_b("children")) {
            NBTTagList list = stack.func_77978_p().func_150295_c("children", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound child = list.func_150305_b(i);
                previews.addChild(LittlePreviews.getChild(context, child), child.func_74767_n("dynamic"));
            }
        }
        return previews;
    }

    public LittlePreview get(int index) {
        return this.previews.get(index);
    }

    public int size() {
        return this.previews.size();
    }

    public int totalSize() {
        if (!this.hasChildren()) {
            return this.size();
        }
        int size = this.size();
        for (LittlePreviews child : this.children) {
            size += child.totalSize();
        }
        return size;
    }

    public boolean isEmptyIncludeChildren() {
        if (!this.isEmpty()) {
            return false;
        }
        for (LittlePreviews child : this.children) {
            if (child.isEmptyIncludeChildren()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.previews.isEmpty();
    }

    public void addWithoutCheckingPreview(LittlePreview preview) {
        this.previews.add(preview);
    }

    public double getVolume() {
        double volume = 0.0;
        for (LittlePreview preview : this) {
            volume += preview.getPercentVolume(this.context);
        }
        return volume;
    }

    public double getVolumeIncludingChildren() {
        double volume = 0.0;
        for (LittlePreview preview : this.allPreviews()) {
            volume += preview.getPercentVolume(this.context);
        }
        return volume;
    }

    public LittleVolumes getVolumes() {
        LittleVolumes volumes = new LittleVolumes(this.context);
        volumes.addPreviews(this);
        return volumes;
    }

    public boolean isVolumeEqual(LittlePreviews previews) {
        return this.getVolumes().equals(previews.getVolumes());
    }

    public void combinePreviewBlocks() {
        HashMapList chunked = new HashMapList();
        for (int i = 0; i < this.previews.size(); ++i) {
            chunked.add((Object)this.previews.get((int)i).box.getMinVec().getBlockPos(this.context), (Object)this.previews.get(i));
        }
        this.previews.clear();
        for (ArrayList list : chunked.values()) {
            BasicCombiner.combine(list);
            this.previews.addAll(list);
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.children) {
                child.combinePreviewBlocks();
            }
        }
    }

    protected void advancedScale(int from, int to) {
        for (LittlePreview preview : this.previews) {
            preview.convertTo(from, to);
        }
        if (this.hasStructure()) {
            this.getStructureType().advancedScale(this, from, to);
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.children) {
                child.advancedScale(from, to);
            }
        }
    }

    public LittleBox getSurroundingBox() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittlePreview preview : this.allPreviews()) {
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public LittleVec getMinVec() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittlePreview preview : this.allPreviews()) {
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        return new LittleVec(minX, minY, minZ);
    }

    public LittleVec getSize() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittlePreview preview : this.allPreviews()) {
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        return new LittleVec(maxX - minX, maxY - minY, maxZ - minZ);
    }

    public static void advancedScale(LittlePreviews previews, int from, int to) {
        previews.advancedScale(from, to);
    }

    public void removeOffset() {
        LittleVec min = this.getMinVec();
        min.x = this.context.toGrid(this.context.toBlockOffset(min.x));
        min.y = this.context.toGrid(this.context.toBlockOffset(min.y));
        min.z = this.context.toGrid(this.context.toBlockOffset(min.z));
        min.invert();
        this.movePreviews(this.context, min);
    }

    @Deprecated
    public static void setLittlePreviewsContextSecretly(LittlePreviews previews, LittleGridContext context) {
        if (previews.hasStructure()) {
            previews.getStructureType().advancedScale(previews, context.size, previews.context.size);
        }
        previews.context = context;
        if (previews.hasChildren()) {
            for (LittlePreviews child : previews.getChildren()) {
                LittlePreviews.setLittlePreviewsContextSecretly(child, context);
            }
        }
    }
}

