/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.ingredient;

import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BlockIngredientEntry {
    public Block block;
    public int meta;
    public double value;

    BlockIngredientEntry(Block block, int meta, double value) {
        this.block = block;
        this.meta = meta;
        this.value = value;
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.block, 1, this.meta);
    }

    public ItemStack getTileItemStack() {
        ItemStack stack = new ItemStack(LittleTiles.blockTileNoTicking);
        NBTTagCompound nbt = new NBTTagCompound();
        new LittleVec(1, 1, 1).writeToNBT("size", nbt);
        LittleTile tile = new LittleTile(this.block, this.meta);
        tile.saveTileExtra(nbt);
        nbt.func_74778_a("tID", "BlockTileBlock");
        stack.func_77982_d(nbt);
        int count = (int)(this.value / LittleGridContext.get().pixelVolume);
        if (count == 0) {
            LittleGridContext.getMax().set(stack.func_77978_p());
            count = (int)(this.value / LittleGridContext.getMax().pixelVolume);
        }
        stack.func_190920_e(count);
        return stack;
    }

    public int hashCode() {
        return this.block.hashCode() + this.meta;
    }

    public boolean equals(Object object) {
        return object instanceof BlockIngredientEntry && ((BlockIngredientEntry)object).block == this.block && ((BlockIngredientEntry)object).meta == this.meta;
    }

    public IBlockState getState() {
        return BlockUtils.getState((Block)this.block, (int)this.meta);
    }

    public boolean is(ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) == this.block && stack.func_77960_j() == this.meta;
    }

    public BlockIngredientEntry copy() {
        return new BlockIngredientEntry(this.block, this.meta, this.value);
    }

    public BlockIngredientEntry copy(double value) {
        return new BlockIngredientEntry(this.block, this.meta, value);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("block", this.block.getRegistryName().toString());
        nbt.func_74768_a("meta", this.meta);
        nbt.func_74780_a("volume", this.value);
        return nbt;
    }

    public boolean isEmpty() {
        return this.value <= 0.0;
    }

    public void scale(int count) {
        this.value *= (double)count;
    }

    public void scaleAdvanced(double scale) {
        this.value = (int)Math.ceil(this.value * scale);
    }

    public String toString() {
        return "[" + this.block.getRegistryName() + "," + this.meta + "," + this.value + "]";
    }
}

