/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.block.MiniatureBlockState;
import jp.ngt.mcte.block.TileEntityMiniature;
import jp.ngt.mcte.item.ItemMiniature;
import jp.ngt.ngtlib.block.BlockArgHolder;
import jp.ngt.ngtlib.block.BlockContainerCustom;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.math.NGTMath;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMiniature
extends BlockContainerCustom {
    public BlockMiniature() {
        super(Material.field_151576_e);
        this.func_149713_g(0);
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityMiniature();
    }

    public boolean onBlockActivated(BlockArgHolder holder, float hitX, float hitY, float hitZ) {
        ItemStack stack = holder.getPlayer().field_71071_by.func_70448_g();
        if (stack == null || stack.func_77973_b() != MCTE.itemMiniature) {
            if (!holder.getWorld().field_72995_K) {
                TileEntityMiniature tile = this.getMiniatureTileEntity((IBlockAccess)holder.getWorld(), holder.getBlockPos());
                tile.setRotation((float)NGTMath.normalizeAngle((double)(tile.getRotation() + MCTE.rotationInterval)), true);
            }
            return true;
        }
        return false;
    }

    private TileEntityMiniature getMiniatureTileEntity(IBlockAccess world, BlockPos pos) {
        return (TileEntityMiniature)world.func_175625_s(pos);
    }

    protected void neighborChanged(BlockArgHolder holder) {
        if (!holder.getWorld().field_72995_K) {
            TileEntityMiniature te = this.getMiniatureTileEntity((IBlockAccess)holder.getWorld(), holder.getBlockPos());
            te.port.onNeighborBlockChange(te);
        }
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        return this.getMiniatureTileEntity((IBlockAccess)world, (BlockPos)pos).getMBState().hardness;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        List<AxisAlignedBB> aabbList = this.getMiniatureTileEntity((IBlockAccess)world, pos).getCollisionBoxes(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (aabbList.isEmpty()) {
            AxisAlignedBB aabb = this.func_180646_a(state, (IBlockAccess)world, pos);
            if (aabb != null && entityBox.func_72326_a(aabb)) {
                collidingBoxes.add(aabb);
            }
        } else {
            for (AxisAlignedBB aabb : aabbList) {
                if (aabb == null || !entityBox.func_72326_a(aabb)) continue;
                collidingBoxes.add(aabb);
            }
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityMiniature tile = this.getMiniatureTileEntity(world, pos);
        return tile == null ? super.func_180646_a(state, world, pos) : tile.getSelectBox(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBox(World world, BlockPos pos) {
        return this.func_180646_a(null, (IBlockAccess)world, pos);
    }

    protected int getWeakPower(BlockArgHolder holder) {
        return this.getStrongPower(holder);
    }

    protected int getStrongPower(BlockArgHolder holder) {
        TileEntityMiniature te = this.getMiniatureTileEntity(holder.getBlockAccess(), holder.getBlockPos());
        if (te == null) {
            return 0;
        }
        int power = te.port.isProvidingPower(te, holder.getFacing());
        return power > 0 ? power : (int)this.getMiniatureTileEntity((IBlockAccess)holder.getBlockAccess(), (BlockPos)holder.getBlockPos()).getMBState().redstonePower;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    protected boolean shouldCheckWeakPower(BlockArgHolder holder) {
        return false;
    }

    protected boolean canConnectRedstone(BlockArgHolder holder) {
        return this.getStrongPower(holder) > 0;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityMiniature miniature = this.getMiniatureTileEntity(world, pos);
        return miniature != null ? (int)miniature.getMBState().lightValue : 0;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return this.getMiniatureTileEntity(world, pos).getMBState().isLadder();
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return this.getMiniatureTileEntity(world, pos).getMBState().isBurning();
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.getMiniatureTileEntity((IBlockAccess)world, pos).getMBState().isFireSource();
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(this.getMiniatureItem(world, pos));
        return ret;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.getMiniatureTileEntity((IBlockAccess)world, (BlockPos)pos).getMBState().explosionResistance;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getMiniatureItem((IBlockAccess)world, pos);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    private ItemStack getMiniatureItem(IBlockAccess world, BlockPos pos) {
        TileEntityMiniature tile = this.getMiniatureTileEntity(world, pos);
        NGTObject ngto = tile.blocksObject;
        float scale = tile.scale;
        float mx = tile.offsetX;
        float my = tile.offsetY;
        float mz = tile.offsetZ;
        ItemMiniature.MiniatureMode mode = tile.mode;
        MiniatureBlockState state = tile.getMBState();
        return ItemMiniature.createMiniatureItem(ngto, scale, mx, my, mz, mode, state);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }
}

