/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.block;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import jp.ngt.mcte.block.TileEntityMiniature;
import jp.ngt.ngtlib.io.NGTJson;
import jp.ngt.ngtlib.util.NGTUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;

public class MiniatureBlockState {
    private static final Map<Object, MiniatureBlockState> STATE_CACHE = new HashMap<Object, MiniatureBlockState>();
    public String name = "no_name";
    public float hardness = 2.0f;
    public byte redstonePower = 0;
    public byte lightValue = 0;
    private int boolStates = 0;
    public float explosionResistance = 10.0f;
    public MiniatureBB mbb = new MiniatureBB();
    public MiniatureMotion mm = new MiniatureMotion();
    private static final long DAY_MILS = 86400000L;
    private float prevMotion;

    private MiniatureBlockState() {
    }

    public static MiniatureBlockState create(TileEntityMiniature key) {
        return MiniatureBlockState.getState((Object)key, true);
    }

    public static MiniatureBlockState create(@Nullable ItemStack key) {
        return MiniatureBlockState.getState(key, key != null);
    }

    private static MiniatureBlockState getState(Object key, boolean useCache) {
        if (NGTUtil.isServer()) {
            return new MiniatureBlockState();
        }
        if (STATE_CACHE.containsKey(key)) {
            return STATE_CACHE.get(key);
        }
        MiniatureBlockState state = new MiniatureBlockState();
        STATE_CACHE.put(key, state);
        return state;
    }

    public boolean isLadder() {
        return (this.boolStates & 1) > 0;
    }

    public void setLadder(boolean par1) {
        this.boolStates = par1 ? (this.boolStates |= 1) : (this.boolStates ^= 1);
    }

    public boolean isBurning() {
        return (this.boolStates & 2) > 0;
    }

    public boolean isFireSource() {
        return (this.boolStates & 4) > 0;
    }

    public boolean isBed() {
        return (this.boolStates & 8) > 0;
    }

    public void setBed(boolean par1) {
        this.boolStates = par1 ? (this.boolStates |= 8) : (this.boolStates ^= 8);
    }

    public boolean hasCustomAABB() {
        return (this.boolStates & 0x10) > 0;
    }

    public void setCustomAABB(boolean par1) {
        this.boolStates = par1 ? (this.boolStates |= 0x10) : (this.boolStates ^= 0x10);
    }

    public AxisAlignedBB getSelectBox() {
        return this.getAABB(this.mbb.selectBox);
    }

    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        if (this.hasCustomAABB()) {
            for (int i = 0; i < this.mbb.collisionBoxes.length; ++i) {
                list.add(this.getAABB(this.mbb.collisionBoxes[i]));
            }
        }
        return list;
    }

    private AxisAlignedBB getAABB(float[] fa) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)fa[0], (double)fa[1], (double)fa[2], (double)fa[3], (double)fa[4], (double)fa[5]);
        return aabb;
    }

    public byte getMotionType() {
        return this.mm.motionType;
    }

    public float getMotion() {
        int time = (int)(System.currentTimeMillis() % 86400000L);
        float rotation = (float)time * 0.001f * this.mm.rotationSpeed + this.mm.rotationOffset;
        return rotation;
    }

    public float getPrevMotion() {
        return this.prevMotion;
    }

    public void setPrevMotion(float par1) {
        this.prevMotion = par1;
    }

    public float getTranslationScale() {
        return this.mm.translationScale;
    }

    public float getTranslationOffset() {
        return this.mm.translationOffset;
    }

    public void setAABB(String par1) {
        try {
            this.mbb = (MiniatureBB)NGTJson.getObjectFromJson((String)par1, MiniatureBB.class);
        }
        catch (IOException e) {
            this.mbb = new MiniatureBB();
        }
    }

    public void setMotion(String par1) {
        try {
            this.mm = (MiniatureMotion)NGTJson.getObjectFromJson((String)par1, MiniatureMotion.class);
        }
        catch (IOException e) {
            this.mm = new MiniatureMotion();
        }
    }

    public String getAabbAsJson() {
        String s = NGTJson.getJsonFromObject((Object)this.mbb);
        s = s.replaceAll(" ", "");
        s = s.replaceAll("\n", "");
        s = s.replaceAll(",", ", ");
        return s;
    }

    public String getMotionAsJson() {
        String s = NGTJson.getJsonFromObject((Object)this.mm);
        s = s.replaceAll(" ", "");
        s = s.replaceAll("\n", "");
        s = s.replaceAll(",", ", ");
        return s;
    }

    public static MiniatureBlockState readFromNBT(NBTTagCompound nbt, Object obj) {
        MiniatureBlockState state = obj instanceof ItemStack ? MiniatureBlockState.create((ItemStack)obj) : MiniatureBlockState.create((TileEntityMiniature)((Object)obj));
        state.name = nbt.func_74779_i("Name");
        state.hardness = nbt.func_74760_g("Hardness");
        state.redstonePower = nbt.func_74771_c("RSPower");
        state.lightValue = nbt.func_74771_c("LightValue");
        state.boolStates = nbt.func_74762_e("BoolStates");
        state.explosionResistance = nbt.func_74760_g("Resistance");
        state.mbb = MiniatureBB.readFromNBT(nbt.func_74775_l("MiniatureBB"));
        state.mm = MiniatureMotion.readFromNBT(nbt.func_74775_l("MiniatureMotion"));
        return state;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Name", this.name);
        nbt.func_74776_a("Hardness", this.hardness);
        nbt.func_74774_a("RSPower", this.redstonePower);
        nbt.func_74774_a("LightValue", this.lightValue);
        nbt.func_74768_a("BoolStates", this.boolStates);
        nbt.func_74776_a("Resistance", this.explosionResistance);
        nbt.func_74782_a("MiniatureBB", (NBTBase)this.mbb.writeToNBT());
        nbt.func_74782_a("MiniatureMotion", (NBTBase)this.mm.writeToNBT());
        return nbt;
    }

    public static class MiniatureMotion {
        public byte motionType;
        public float rotationSpeed;
        public float rotationOffset;
        public float translationScale;
        public float translationOffset;

        public static MiniatureMotion readFromNBT(NBTTagCompound nbt) {
            MiniatureMotion mm = new MiniatureMotion();
            mm.motionType = nbt.func_74771_c("MotionType");
            mm.rotationSpeed = nbt.func_74760_g("RotationSpeed");
            mm.rotationOffset = nbt.func_74760_g("RotationOffset");
            mm.translationScale = nbt.func_74760_g("TranslationScale");
            mm.translationOffset = nbt.func_74760_g("TranslationOffset");
            return mm;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("MotionType", this.motionType);
            nbt.func_74776_a("RotationSpeed", this.rotationSpeed);
            nbt.func_74776_a("RotationOffset", this.rotationOffset);
            nbt.func_74776_a("TranslationScale", this.translationScale);
            nbt.func_74776_a("TranslationOffset", this.translationOffset);
            return nbt;
        }
    }

    public static class MiniatureBB {
        public float[] selectBox = new float[]{-0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f};
        public float[][] collisionBoxes = new float[][]{{-0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f}};

        public static MiniatureBB readFromNBT(NBTTagCompound nbt) {
            MiniatureBB mbb = new MiniatureBB();
            mbb.selectBox = new float[6];
            int[] ia = nbt.func_74759_k("SelectBox");
            for (int j = 0; j < 6; ++j) {
                mbb.selectBox[j] = Float.intBitsToFloat(ia[j]);
            }
            NBTTagList tagList = nbt.func_150295_c("CollisionBoxes", 11);
            mbb.collisionBoxes = new float[tagList.func_74745_c()][6];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int[] ia2 = tagList.func_150306_c(i);
                for (int j = 0; j < 6; ++j) {
                    mbb.collisionBoxes[i][j] = Float.intBitsToFloat(ia2[j]);
                }
            }
            return mbb;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            int[] ia = new int[6];
            for (int j = 0; j < 6; ++j) {
                ia[j] = Float.floatToIntBits(this.selectBox[j]);
            }
            nbt.func_74783_a("SelectBox", ia);
            NBTTagList tagList = new NBTTagList();
            for (int i = 0; i < this.collisionBoxes.length; ++i) {
                int[] ia2 = new int[6];
                for (int j = 0; j < 6; ++j) {
                    ia2[j] = Float.floatToIntBits(this.collisionBoxes[i][j]);
                }
                tagList.func_74742_a((NBTBase)new NBTTagIntArray(ia2));
            }
            nbt.func_74782_a("CollisionBoxes", (NBTBase)tagList);
            return nbt;
        }
    }
}

