/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.block;

import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import jp.ngt.mcte.block.MiniatureBlockState;
import jp.ngt.mcte.block.TileEntityMiniature;
import jp.ngt.mcte.world.MCTEWorld;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.NGTObjectRenderer;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.ngtlib.world.IBlockAccessNGT;
import jp.ngt.ngtlib.world.NGTWorld;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderMiniature
extends TileEntitySpecialRenderer<TileEntityMiniature> {
    private static final int TOTAL_PASS = 5;
    private static final int[] BLOCK_TEX_ALPHA = new int[5];
    public static RenderMiniature INSTANCE = new RenderMiniature();

    private RenderMiniature() {
    }

    private void renderMiniatureAt(TileEntityMiniature tile, double par2, double par4, double par6, float par8) {
        if (tile.blocksObject == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8256);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2884);
        GL11.glTranslatef((float)((float)par2 + 0.5f), (float)((float)par4 + 0.5f), (float)((float)par6 + 0.5f));
        switch (tile.attachSide) {
            case 0: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
        for (int i = 0; i < 5; ++i) {
            this.renderWithPass(tile, par8, i);
        }
        tile.getMBState().setPrevMotion(tile.getMBState().getMotion());
        GL11.glDisable((int)32826);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderWithPass(TileEntityMiniature tile, float par8, int mPass) {
        if (tile.getMBState().getMotionType() == 0 && mPass > 0) {
            return;
        }
        GL11.glPushMatrix();
        RenderMiniature.setupMotionAndScale(tile.getMBState(), tile.getRotation(), tile.scale, tile.offsetX, tile.offsetY, tile.offsetZ, mPass);
        if (mPass > 0) {
            GL11.glAlphaFunc((int)516, (float)0.0625f);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        float x = (float)tile.blocksObject.xSize * 0.5f;
        float z = (float)tile.blocksObject.zSize * 0.5f;
        GL11.glTranslatef((float)(-x), (float)0.0f, (float)(-z));
        MCTEWorld world = tile.getDummyWorld();
        if (world != null) {
            int pass = MinecraftForgeClient.getRenderPass();
            if (pass >= 0) {
                this.renderEntityAndBlock(tile, world, par8, pass, mPass);
            } else {
                this.renderEntityAndBlock(tile, world, par8, 0, 0);
                this.renderEntityAndBlock(tile, world, par8, 1, 0);
            }
        }
        if (mPass > 0) {
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
    }

    private void renderEntityAndBlock(TileEntityMiniature tile, MCTEWorld world, float partialTick, int pass, int mPass) {
        NGTObjectRenderer.INSTANCE.renderTileEntities((NGTWorld)world, partialTick, pass);
        NGTObjectRenderer.INSTANCE.renderEntities((NGTWorld)world, partialTick, pass);
        this.renderBlocks(world, tile, partialTick, pass, mPass);
    }

    public static void setupMotionAndScale(MiniatureBlockState state, float rotation, float scale, float offsetX, float offsetY, float offsetZ, int pass) {
        byte type = state.getMotionType();
        float ro = 0.0f;
        float tr = 0.0f;
        float speed = state.mm.rotationSpeed;
        float dif = (float)pass / 5.0f * speed * speed / 1440.0f;
        float motion = state.getMotion() - dif;
        if (type == 1) {
            ro = motion;
        } else if (type == 2) {
            tr = (NGTMath.sin((float)motion) + 1.0f) * 0.5f * state.getTranslationScale() + state.getTranslationOffset();
        } else if (type == 3) {
            ro = NGTMath.sin((float)motion) * 0.5f * state.getTranslationScale() + state.getTranslationOffset();
        }
        GL11.glRotatef((float)(rotation + ro), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)offsetX, (float)(offsetY + tr), (float)offsetZ);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
    }

    private void renderBlocks(MCTEWorld world, TileEntityMiniature tile, float par3, int pass, int mPass) {
        boolean smoothing;
        if (tile.glLists == null) {
            tile.glLists = new GLObject[2];
        }
        GLHelper.disableLighting();
        int i = tile.func_145831_w().func_175626_b(tile.func_174877_v(), 0);
        GLHelper.setBrightness((int)i);
        if (mPass == 0) {
            this.func_147499_a(TextureMap.field_110575_b);
        } else {
            if (BLOCK_TEX_ALPHA[mPass] <= 0) {
                RenderMiniature.BLOCK_TEX_ALPHA[mPass] = this.getAlphaTex(mPass);
            }
            GlStateManager.func_179144_i((int)BLOCK_TEX_ALPHA[mPass]);
        }
        boolean bl = smoothing = NGTUtilClient.getMinecraft().field_71474_y.field_74348_k != 0;
        if (smoothing) {
            GL11.glShadeModel((int)7425);
        }
        if (!GLHelper.isValid((GLObject)tile.glLists[pass])) {
            tile.glLists[pass] = GLHelper.generateGLList((GLObject)tile.glLists[pass]);
            GLHelper.startCompile((GLObject)tile.glLists[pass]);
            NGTObjectRenderer.INSTANCE.renderNGTObject((IBlockAccessNGT)world, tile.blocksObject, false, tile.mode.id, pass);
            GLHelper.endCompile();
        } else if (world.updated) {
            GLHelper.startCompile((GLObject)tile.glLists[pass]);
            NGTObjectRenderer.INSTANCE.renderNGTObject((IBlockAccessNGT)world, tile.blocksObject, false, tile.mode.id, pass);
            GLHelper.endCompile();
            world.updated = false;
        } else {
            GLHelper.callList((GLObject)tile.glLists[pass]);
        }
        if (smoothing) {
            GL11.glShadeModel((int)7424);
        }
        GLHelper.enableLighting();
        NGTUtilClient.getMinecraft().field_71460_t.func_180436_i();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int getAlphaTex(int mPass) {
        int w = GLHelper.getBlockTextureWidth();
        int h = GLHelper.getBlockTextureHeight();
        IntBuffer buffer = GLHelper.getBlockTexture((int)w, (int)h);
        BufferedImage image = new BufferedImage(w, h, 2);
        for (int i = 0; i < buffer.capacity(); ++i) {
            float alpha = (float)(5 - mPass) / 5.0f;
            int color = buffer.get(i);
            int a = NGTMath.floor((float)(alpha * 255.0f));
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            color = a << 24 | r << 16 | g << 8 | b;
            image.getRaster().getDataBuffer().setElem(i, color);
        }
        int texId = TextureUtil.func_110996_a();
        TextureUtil.func_110987_a((int)texId, (BufferedImage)image);
        return texId;
    }

    @Deprecated
    public void clear() {
        for (int i = 0; i < BLOCK_TEX_ALPHA.length; ++i) {
            RenderMiniature.BLOCK_TEX_ALPHA[i] = 0;
        }
    }

    public void render(TileEntityMiniature tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.renderMiniatureAt(tile, x, y, z, partialTicks);
    }

    public boolean isGlobalRenderer(TileEntityMiniature tile) {
        return true;
    }
}

