/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.block;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.mcte.block.MiniatureBlockState;
import jp.ngt.mcte.block.RSPortSet;
import jp.ngt.mcte.item.ItemMiniature;
import jp.ngt.mcte.world.MCTEWorld;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.block.TileEntityPlaceable;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.util.NGTUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMiniature
extends TileEntityPlaceable
implements ITickable {
    public NGTObject blocksObject;
    public float scale;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public ItemMiniature.MiniatureMode mode;
    public byte attachSide;
    private MiniatureBlockState state;
    public final RSPortSet port = new RSPortSet();
    private AxisAlignedBB selectBox;
    private List<AxisAlignedBB> collisionBoxes;
    private MCTEWorld dummyWorld;
    @SideOnly(value=Side.CLIENT)
    public GLObject[] glLists;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.blocksObject = ItemMiniature.getNGTObject(nbt);
        this.scale = ItemMiniature.getScale(nbt);
        this.offsetX = nbt.func_74760_g("OffsetX");
        this.offsetY = nbt.func_74760_g("OffsetY");
        this.offsetZ = nbt.func_74760_g("OffsetZ");
        this.mode = ItemMiniature.MiniatureMode.values()[nbt.func_74771_c("Mode")];
        this.attachSide = nbt.func_74764_b("AttachSide") ? nbt.func_74771_c("AttachSide") : (byte)1;
        if (nbt.func_74764_b("MBState")) {
            this.state = MiniatureBlockState.readFromNBT(nbt.func_74775_l("MBState"), (Object)this);
        } else {
            this.state = MiniatureBlockState.create(this);
            this.state.lightValue = nbt.func_74771_c("LightValue");
        }
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_175664_x(this.func_174877_v());
        }
        this.dummyWorld = null;
        this.updateAABB();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        ItemMiniature.setScale(this.scale, nbt);
        if (this.blocksObject != null) {
            ItemMiniature.setNGTObject(this.blocksObject, nbt);
        }
        nbt.func_74776_a("OffsetX", this.offsetX);
        nbt.func_74776_a("OffsetY", this.offsetY);
        nbt.func_74776_a("OffsetZ", this.offsetZ);
        nbt.func_74774_a("Mode", (byte)this.mode.id);
        nbt.func_74774_a("AttachSide", this.attachSide);
        nbt.func_74782_a("MBState", (NBTBase)this.state.writeToNBT());
        return nbt;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.getDummyWorld().func_72835_b();
            if (this.getDummyWorld().needsSync()) {
                this.sendPacket();
            }
        }
    }

    public MCTEWorld getDummyWorld() {
        if (this.dummyWorld == null && this.blocksObject != null) {
            BlockPos pos = this.func_174877_v();
            this.dummyWorld = new MCTEWorld(this.func_145831_w(), this.blocksObject, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return this.dummyWorld;
    }

    public void setBlockState(NGTObject par1, float par2, float x, float y, float z, ItemMiniature.MiniatureMode par6) {
        this.blocksObject = par1;
        this.scale = par2;
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        this.mode = par6;
        this.sendPacket();
        this.func_70296_d();
    }

    public MiniatureBlockState getMBState() {
        return this.state != null ? this.state : MiniatureBlockState.create(this);
    }

    public void setMBState(MiniatureBlockState par1) {
        this.state = par1;
    }

    public AxisAlignedBB getSelectBox(int x, int y, int z) {
        if (this.selectBox == null) {
            if (this.state == null) {
                AxisAlignedBB aabb = new AxisAlignedBB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5);
                aabb.func_72317_d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                return aabb;
            }
            AxisAlignedBB aabb = this.state.getSelectBox();
            this.rotateAABB(aabb);
            aabb.func_72317_d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            this.selectBox = aabb;
        }
        return this.selectBox;
    }

    public List<AxisAlignedBB> getCollisionBoxes(int x, int y, int z) {
        if (this.collisionBoxes == null) {
            if (this.state == null) {
                ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
                AxisAlignedBB aabb = new AxisAlignedBB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5);
                aabb.func_72317_d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                list.add(aabb);
                return list;
            }
            List<AxisAlignedBB> list = this.state.getCollisionBoxes();
            this.collisionBoxes = new ArrayList<AxisAlignedBB>();
            for (AxisAlignedBB aabb : list) {
                AxisAlignedBB aabb2 = this.rotateAABB(aabb);
                aabb2 = aabb2.func_72317_d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                this.collisionBoxes.add(aabb2);
            }
        }
        return this.collisionBoxes;
    }

    private AxisAlignedBB rotateAABB(AxisAlignedBB aabb) {
        Vec3 vecMin = new Vec3(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        Vec3 vecMax = new Vec3(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        float f0 = this.getRotation();
        switch (this.attachSide) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                f0 *= -1.0f;
                break;
            }
            case 3: {
                f0 *= -1.0f;
                break;
            }
            case 4: {
                f0 *= -1.0f;
                break;
            }
            case 5: {
                f0 *= -1.0f;
            }
        }
        f0 = (float)NGTMath.floor((float)((f0 + 45.0f) / 90.0f)) * 90.0f;
        float yaw = NGTMath.toRadians((float)f0);
        vecMin = vecMin.rotateAroundY(yaw);
        vecMax = vecMax.rotateAroundY(yaw);
        switch (this.attachSide) {
            case 0: {
                float ro = NGTMath.toRadians((float)180.0f);
                vecMin = vecMin.rotateAroundZ(ro);
                vecMax = vecMax.rotateAroundZ(ro);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                float ro = NGTMath.toRadians((float)-90.0f);
                vecMin = vecMin.rotateAroundX(ro);
                vecMax = vecMax.rotateAroundX(ro);
                break;
            }
            case 3: {
                float ro = NGTMath.toRadians((float)90.0f);
                vecMin = vecMin.rotateAroundX(ro);
                vecMax = vecMax.rotateAroundX(ro);
                break;
            }
            case 4: {
                float ro = NGTMath.toRadians((float)90.0f);
                vecMin = vecMin.rotateAroundZ(ro);
                vecMax = vecMax.rotateAroundZ(ro);
                break;
            }
            case 5: {
                float ro = NGTMath.toRadians((float)-90.0f);
                vecMin = vecMin.rotateAroundZ(ro);
                vecMax = vecMax.rotateAroundZ(ro);
            }
        }
        double minX = vecMin.getX() < vecMax.getX() ? vecMin.getX() : vecMax.getX();
        double minY = vecMin.getY() < vecMax.getY() ? vecMin.getY() : vecMax.getY();
        double minZ = vecMin.getZ() < vecMax.getZ() ? vecMin.getZ() : vecMax.getZ();
        double maxX = vecMin.getX() > vecMax.getX() ? vecMin.getX() : vecMax.getX();
        double maxY = vecMin.getY() > vecMax.getY() ? vecMin.getY() : vecMax.getY();
        double maxZ = vecMin.getZ() > vecMax.getZ() ? vecMin.getZ() : vecMax.getZ();
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void setRotation(float par1, boolean synch) {
        super.setRotation(par1, synch);
        this.updateAABB();
    }

    private void updateAABB() {
        this.selectBox = null;
        this.collisionBoxes = null;
    }

    public void onChunkUnload() {
        if (this.func_145831_w().field_72995_K) {
            this.deleteGLList();
        }
    }

    public void func_145843_s() {
        if (this.func_145831_w().field_72995_K) {
            this.deleteGLList();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void deleteGLList() {
        if (this.glLists != null) {
            GLHelper.deleteGLList((GLObject)this.glLists[0]);
            GLHelper.deleteGLList((GLObject)this.glLists[1]);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass >= 0;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        double d0 = NGTUtil.getChunkLoadDistanceSq() * 0.5;
        if (this.blocksObject != null) {
            if (d0 < (double)this.blocksObject.xSize) {
                d0 = this.blocksObject.xSize;
            }
            if (d0 < (double)this.blocksObject.ySize) {
                d0 = this.blocksObject.ySize;
            }
            if (d0 < (double)this.blocksObject.zSize) {
                d0 = this.blocksObject.zSize;
            }
        }
        return d0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.blocksObject == null) {
            return super.getRenderBoundingBox();
        }
        if (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            return INFINITE_EXTENT_AABB;
        }
        double sc = this.scale;
        double x0 = (double)this.blocksObject.xSize * sc * 0.5;
        double y0 = (double)this.blocksObject.ySize * sc;
        double z0 = (double)this.blocksObject.zSize * sc * 0.5;
        BlockPos pos = this.func_174877_v();
        double px = (double)pos.func_177958_n() + 0.5;
        double py = pos.func_177956_o();
        double pz = (double)pos.func_177952_p() + 0.5;
        return new AxisAlignedBB(px - x0, py, pz - z0, px + x0, py + y0, pz + z0);
    }
}

