/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.editor;

import java.util.ArrayList;
import java.util.Arrays;
import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.block.BlockMinesweeper;
import jp.ngt.mcte.block.TileEntityMinesweeper;
import jp.ngt.mcte.editor.EditorManager;
import jp.ngt.mcte.editor.EditorTransform;
import jp.ngt.mcte.editor.EntityEditor;
import jp.ngt.mcte.editor.WorldSnapshot;
import jp.ngt.mcte.editor.filter.Repeatable;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.AABBInt;
import jp.ngt.ngtlib.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Editor {
    public static final byte EditType_Replace = 6;
    public static final byte EditType_Clone = 7;
    public static final byte EditType_Minesweeper = 9;
    public static final byte EditType_Miniature = 10;
    public static final byte EditMode_0 = 0;
    public static final byte EditMode_1 = 1;
    public static final byte EditMode_VisibleBox_0 = 2;
    public static final byte EditMode_VisibleBox_1 = 3;
    public static final byte EditMode_Max = 3;
    private final EntityEditor editorEntity;
    private WorldSnapshot clipboard;
    private Stack<WorldSnapshot> history = new Stack(MCTE.numberOfUndo);

    public Editor(EntityEditor par1) {
        this.editorEntity = par1;
    }

    public static EntityEditor getNewEditor(World world, EntityPlayer player, int x, int y, int z) {
        if (world.field_72995_K) {
            return null;
        }
        EntityEditor entity = new EntityEditor(world, player, x, y, z);
        Editor editor = new Editor(entity);
        EditorManager.INSTANCE.add(player.func_70005_c_(), editor);
        return entity;
    }

    public EntityEditor getEntity() {
        return this.editorEntity;
    }

    public World getWorld() {
        return this.getEntity().func_130014_f_();
    }

    public AABBInt getSelectBox() {
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        int[] start = this.getEntity().getPos(EntityEditor.START_POS);
        int[] end = this.getEntity().getPos(EntityEditor.END_POS);
        if (start[0] == 0 && start[1] == 0 && start[2] == 0 || end[0] == 0 && end[1] == 0 && end[2] == 0) {
            return null;
        }
        minX = start[0] < end[0] ? start[0] : end[0];
        maxX = start[0] < end[0] ? end[0] : start[0];
        minY = start[1] < end[1] ? start[1] : end[1];
        maxY = start[1] < end[1] ? end[1] : start[1];
        minZ = start[2] < end[2] ? start[2] : end[2];
        maxZ = start[2] < end[2] ? end[2] : start[2];
        return new AABBInt(minX, minY, minZ, ++maxX, ++maxY, ++maxZ);
    }

    public AABBInt getPasteBox() {
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        byte b = this.getEntity().getEditMode();
        if (b != 2 && b != 3) {
            NGTLog.debug((String)"[MCTE](Edit) Not paste mode");
            return null;
        }
        RayTraceResult target = this.getEntity().getTarget(true);
        if (target == null) {
            NGTLog.debug((String)"[MCTE](Edit) MovingObjectPosition not found");
            return null;
        }
        int[] box = this.getEntity().getPos(EntityEditor.PASTE_BOX);
        if (this.clipboard.getSize() != box[0] * box[1] * box[2]) {
            this.getEntity().updateBlockList(null);
            NGTLog.debug((String)"[MCTE](Edit) Illegal block list size");
            return null;
        }
        minX = target.func_178782_a().func_177958_n();
        minY = target.func_178782_a().func_177956_o();
        minZ = target.func_178782_a().func_177952_p();
        maxX = minX + box[0];
        maxY = minY + box[1];
        maxZ = minZ + box[2];
        return new AABBInt(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean editBlocks(byte editType, float par2) {
        World world = this.getWorld();
        if (!this.getEntity().isSelectEnd()) {
            NGTLog.debug((String)"[MCTE](Edit) Not select end");
            return false;
        }
        if (world.field_72995_K) {
            NGTLog.debug((String)"[MCTE](Edit) Can't edit in Client");
            return false;
        }
        AABBInt box = this.getSelectBox();
        if (box == null) {
            return false;
        }
        if (editType == 9 && box.maxY - box.minY != 1) {
            return false;
        }
        if (editType == 6 || editType == 9) {
            this.record(box);
        }
        ArrayList list = new ArrayList();
        Repeatable repeator = null;
        if (editType == 6) {
            repeator = (rbox, index, rep, rx, ry, rz) -> {
                Block block0 = this.getEntity().getSlotBlock(0);
                Block block1 = this.getEntity().getSlotBlock(1);
                if (block0 != null && block1 != null) {
                    boolean flag1;
                    int meta0 = this.getEntity().getSlotBlockMetadata(0);
                    int meta1 = this.getEntity().getSlotBlockMetadata(1);
                    boolean flag0 = BlockUtil.getBlock((IBlockAccess)world, (int)rx, (int)ry, (int)rz) == block0;
                    boolean bl = flag1 = BlockUtil.getMetadata((IBlockAccess)world, (int)rx, (int)ry, (int)rz) == meta0;
                    if (flag0 && flag1) {
                        this.setBlock(rx, ry, rz, block1, meta1, true);
                    }
                }
            };
        } else if (editType == 7) {
            repeator = (rbox, index, rep, rx, ry, rz) -> {
                if (this.getEntity().hasCloneBox()) {
                    BlockSet blockSet = this.getBlockSet(rx, ry, rz);
                    int[] box1 = this.getEntity().getCloneBox();
                    for (int l = 1; l < box1[3] + 1; ++l) {
                        int x = rx + box1[0] * l;
                        int y = ry + box1[1] * l;
                        int z = rz + box1[2] * l;
                        this.setBlock(x, y, z, blockSet, true);
                    }
                }
            };
        } else if (editType == 9) {
            repeator = (rbox, index, rep, rx, ry, rz) -> {
                int random = world.field_73012_v.nextInt((int)par2);
                byte meta = random == 0 ? BlockMinesweeper.MinesweeperType.MINE.id : BlockMinesweeper.MinesweeperType.NONE.id;
                this.setBlock(rx, ry, rz, MCTE.minesweeper, meta, true);
                TileEntityMinesweeper tile = (TileEntityMinesweeper)BlockUtil.getTileEntity((IBlockAccess)world, (int)rx, (int)ry, (int)rz);
                tile.setCenter(box.minX, box.minZ);
                tile.setSize(box.maxX - box.minX, box.maxZ - box.minZ);
            };
        }
        if (repeator != null) {
            this.repeat(box, repeator, 1);
        }
        if (editType == 10) {
            NGTObject object = this.copy(this.getSelectBox(), "notSync").convertNGTO();
            this.getEntity().dropMiniature(object, par2);
        }
        return true;
    }

    public void transformBlocks(EditorTransform type) {
        BlockSet[] blocks = new BlockSet[this.clipboard.getSize()];
        int[] box = this.getEntity().getPos(EntityEditor.PASTE_BOX);
        int xSize = box[0];
        int ySize = box[1];
        int zSize = box[2];
        int xSize2 = xSize;
        int ySize2 = ySize;
        int zSize2 = zSize;
        if (type == EditorTransform.Transform_RotateX) {
            ySize = zSize2;
            zSize = ySize2;
        } else if (type == EditorTransform.Transform_RotateY) {
            xSize = zSize2;
            zSize = xSize2;
        } else if (type == EditorTransform.Transform_RotateZ) {
            xSize = ySize2;
            ySize = xSize2;
        }
        int xSizeF = xSize;
        int ySizeF = ySize;
        int zSizeF = zSize;
        AABBInt box2 = new AABBInt(xSize2, ySize2, zSize2);
        box2.repeat((i, j, k, count) -> {
            BlockSet set = this.clipboard.getBlocks().get(count);
            IBlockState state = set.toBlockState();
            int x1 = i;
            int y1 = j;
            int z1 = k;
            if (type == EditorTransform.Transform_RotateX) {
                y1 = zSize2 - k - 1;
                z1 = j;
            } else if (type == EditorTransform.Transform_RotateY) {
                z1 = xSize2 - i - 1;
                x1 = k;
                state = state.func_185907_a(Rotation.COUNTERCLOCKWISE_90);
            } else if (type == EditorTransform.Transform_RotateZ) {
                x1 = ySize2 - j - 1;
                y1 = i;
            } else if (type == EditorTransform.Transform_MirrorX) {
                x1 = xSize2 - i - 1;
                state = state.func_185902_a(Mirror.FRONT_BACK);
            } else if (type == EditorTransform.Transform_MirrorY) {
                y1 = ySize2 - j - 1;
            } else if (type == EditorTransform.Transform_MirrorZ) {
                z1 = zSize2 - k - 1;
                state = state.func_185902_a(Mirror.LEFT_RIGHT);
            }
            int index2 = x1 * ySizeF * zSizeF + y1 * zSizeF + z1;
            blocks[index2] = new BlockSet(set.block, set.block.func_176201_c(state), set.nbt);
        });
        this.clipboard = new WorldSnapshot(Arrays.asList(blocks), new AABBInt(xSize, ySize, zSize));
        this.getEntity().setPos(EntityEditor.PASTE_BOX, xSize, ySize, zSize);
        this.getEntity().updateBlockList(this.clipboard.convertNGTO());
    }

    public BlockSet getFillItem() {
        ItemStack stack;
        Object block = this.getEntity().getSlotBlock(0);
        int meta = this.getEntity().getSlotBlockMetadata(0);
        if (block == Blocks.field_150350_a && (stack = this.getEntity().getPlayer().field_71071_by.func_70448_g()) != null) {
            block = stack.func_77973_b() == Items.field_151131_as ? Blocks.field_150355_j : (stack.func_77973_b() == Items.field_151129_at ? Blocks.field_150353_l : Block.func_149634_a((Item)stack.func_77973_b()));
            meta = stack.func_77952_i();
        }
        if (block != null) {
            return new BlockSet(block, meta);
        }
        return BlockSet.AIR;
    }

    public BlockSet getBlockSet(int x, int y, int z) {
        return BlockSet.getBlockSet((World)this.getWorld(), (int)x, (int)y, (int)z, (boolean)true);
    }

    public void setBlock(int px, int py, int pz, Block block, int metadata, boolean syncClient) {
        this.setBlock(px, py, pz, new BlockSet(block, metadata), syncClient);
    }

    public void setBlock(int px, int py, int pz, BlockSet blockSet, boolean syncClient) {
        TileEntity tile;
        World world = this.getWorld();
        int meta = blockSet.metadata;
        if (blockSet.block instanceof BlockLeaves && (meta < 4 || meta > 7)) {
            meta = (meta & 3) + 4;
        }
        int flag = syncClient ? 2 : 0;
        BlockUtil.setBlock((World)world, (int)px, (int)py, (int)pz, (Block)blockSet.block, (int)meta, (int)flag);
        if (blockSet.block != Blocks.field_150350_a) {
            world.func_175664_x(new BlockPos(px, py, pz));
        }
        if (blockSet.block.hasTileEntity(blockSet.block.func_176203_a(meta)) && (tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)px, (int)py, (int)pz)) != null) {
            this.setTileEntityData(tile, blockSet.nbt, px, py, pz);
        }
    }

    private void setTileEntityData(TileEntity tile, NBTTagCompound nbt, int x, int y, int z) {
        int prevX = 0;
        int prevY = 0;
        int prevZ = 0;
        if (nbt != null) {
            NBTTagCompound nbt0 = nbt.func_74737_b();
            prevX = nbt0.func_74762_e("x");
            prevY = nbt0.func_74762_e("y");
            prevZ = nbt0.func_74762_e("z");
            nbt0.func_74768_a("x", x);
            nbt0.func_74768_a("y", y);
            nbt0.func_74768_a("z", z);
            tile.func_145839_a(nbt0);
        }
        if (tile instanceof TileEntityCustom) {
            ((TileEntityCustom)tile).setPos(x, y, z, prevX, prevY, prevZ);
        } else {
            tile.func_174878_a(new BlockPos(x, y, z));
        }
    }

    public WorldSnapshot copy(AABBInt box, String options) {
        this.clipboard = new WorldSnapshot(this, box, options);
        this.getEntity().setPos(EntityEditor.PASTE_BOX, box.maxX - box.minX, box.maxY - box.minY, box.maxZ - box.minZ);
        if (!options.contains("notSync")) {
            this.getEntity().updateBlockList(this.clipboard.convertNGTO());
        }
        return this.clipboard;
    }

    public void loadData(NGTObject ngto) {
        this.clipboard = new WorldSnapshot(ngto);
    }

    public void paste(AABBInt box, String options) {
        this.clipboard.setBlocks(this, box.minX, box.minY, box.minZ, options);
    }

    public void delete(AABBInt box, String options) {
        this.fill(box, BlockSet.AIR, options);
    }

    public void fill(AABBInt box, BlockSet blockSet, String options) {
        this.repeat(box, (box2, index, rep, x, y, z) -> {
            IBlockState state;
            if (options.contains("IgnoreWater") && (state = this.getWorld().func_180495_p(new BlockPos(x, y, z))).func_185904_a().func_76224_d()) {
                return;
            }
            this.setBlock(x, y, z, blockSet, true);
        }, 1);
        this.updateBlocks(box);
    }

    public void updateBlocks(AABBInt box) {
        int minCX = box.minX >> 4;
        int minCY = box.minY >> 4;
        int minCZ = box.minZ >> 4;
        int maxCX = (box.maxX >> 4) + 1;
        int maxCY = (box.maxY >> 4) + 1;
        int maxCZ = (box.maxZ >> 4) + 1;
        this.getWorld().func_147458_c(minCX << 4, minCY << 4, minCZ << 4, maxCX << 4, maxCY << 4, maxCZ << 4);
    }

    public void repeat(AABBInt box, Repeatable repeater, int rep) {
        int i = 0;
        while (i < rep) {
            int i2 = i++;
            box.repeat((x, y, z, count) -> repeater.processing(box, count, i2, x, y, z));
        }
    }

    public void record(AABBInt box) {
        this.history.push((Object)new WorldSnapshot(this, box, ""));
    }

    public void undo() {
        WorldSnapshot snapshot = (WorldSnapshot)this.history.pop();
        if (snapshot != null) {
            snapshot.restore(this);
        }
    }
}

