/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.block.MiniatureBlockState;
import jp.ngt.mcte.editor.EditEntry;
import jp.ngt.mcte.editor.Editor;
import jp.ngt.mcte.editor.EditorManager;
import jp.ngt.mcte.item.ItemEditor;
import jp.ngt.mcte.item.ItemMiniature;
import jp.ngt.mcte.network.PacketEditorBlockData;
import jp.ngt.mcte.network.PacketRenderBlocks;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.item.ItemUtil;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.world.NGTWorld;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEditor
extends Entity
implements IInventory {
    private static final byte XZ_MASK_BIT = 9;
    private static final int XZ_OFFSET = 256;
    public static final DataParameter<String> PLAYER = EntityDataManager.func_187226_a(EntityEditor.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<BlockPos> START_POS = EntityDataManager.func_187226_a(EntityEditor.class, (DataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<BlockPos> END_POS = EntityDataManager.func_187226_a(EntityEditor.class, (DataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<BlockPos> PASTE_BOX = EntityDataManager.func_187226_a(EntityEditor.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<BlockPos> CLONE_BOX = EntityDataManager.func_187226_a(EntityEditor.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Byte> MODE = EntityDataManager.func_187226_a(EntityEditor.class, (DataSerializer)DataSerializers.field_187191_a);
    private EntityPlayer player;
    private ItemStack[] slots = ItemUtil.getEmptyArray((int)2);
    public int fillMode = 0;
    private List<EditEntry> entries = Collections.synchronizedList(new ArrayList());
    @SideOnly(value=Side.CLIENT)
    public NGTObject blocksForRenderer;
    @SideOnly(value=Side.CLIENT)
    public World dummyWorld;
    @SideOnly(value=Side.CLIENT)
    public GLObject displayList;
    @SideOnly(value=Side.CLIENT)
    private boolean needsUpdate;

    public EntityEditor(World world) {
        super(world);
        this.field_70158_ak = true;
    }

    protected EntityEditor(World world, EntityPlayer player, int x, int y, int z) {
        this(world);
        this.setPlayer(player);
        this.setPos(START_POS, x, y, z);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(PLAYER, (Object)"");
        this.func_184212_Q().func_187214_a(START_POS, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(END_POS, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(PASTE_BOX, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(CLONE_BOX, (Object)new BlockPos(256, 0, 256));
        this.func_184212_Q().func_187214_a(MODE, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getPlayer() != null) {
            this.field_70165_t = this.getPlayer().field_70165_t;
            this.field_70163_u = this.getPlayer().field_70163_u;
            this.field_70161_v = this.getPlayer().field_70161_v;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getPlayer() == null || this.getPlayer().field_70128_L) {
                this.func_70106_y();
            }
            if (!this.entries.isEmpty()) {
                for (EditEntry entry : this.entries) {
                    entry.edit();
                }
                this.entries.clear();
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            GLHelper.deleteGLList((GLObject)this.displayList);
        } else {
            EditorManager.INSTANCE.remove(this);
        }
    }

    public void post(EditEntry entry) {
        this.entries.add(entry);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double par1, double par3, double par5, float par7, float par8, int par9, boolean par10) {
    }

    public RayTraceResult getTarget(boolean selectSide) {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            byte mode = this.getEditMode();
            boolean flag = mode == 0 || mode == 2;
            return ItemEditor.getTarget(player, flag, selectSide);
        }
        return null;
    }

    public EntityPlayer getPlayer() {
        if (this.player == null) {
            String name = (String)this.func_184212_Q().func_187225_a(PLAYER);
            this.player = this.field_70170_p.func_72924_a(name);
        }
        return this.player;
    }

    public void setPlayer(EntityPlayer par1) {
        this.player = par1;
        this.func_184212_Q().func_187227_b(PLAYER, (Object)par1.func_70005_c_());
    }

    public int[] getPos(DataParameter<BlockPos> type) {
        return BlockUtil.toArray((BlockPos)((BlockPos)this.func_184212_Q().func_187225_a(type)));
    }

    public void setPos(DataParameter<BlockPos> type, int x, int y, int z) {
        if (type == START_POS) {
            this.func_184212_Q().func_187227_b(END_POS, (Object)new BlockPos(0, 0, 0));
        }
        this.func_184212_Q().func_187227_b(type, (Object)new BlockPos(x, y, z));
    }

    public boolean isSelectEnd() {
        int[] start = this.getPos(START_POS);
        int[] end = this.getPos(END_POS);
        return start[1] > 0 && end[1] > 0;
    }

    public int[] getCloneBox() {
        int[] ia = this.getPos(CLONE_BOX);
        int mask = 511;
        int x = (ia[0] & mask) - 256;
        int z = (ia[2] & mask) - 256;
        int r = (ia[0] >> 9) + (ia[2] >> 9 << 4);
        return new int[]{x, ia[1], z, r};
    }

    public void setCloneBox(int x, int y, int z, int r) {
        r = MathHelper.func_76125_a((int)r, (int)0, (int)255);
        x = MathHelper.func_76125_a((int)x, (int)-256, (int)255) + 256 + ((r & 0xF) << 9);
        z = MathHelper.func_76125_a((int)z, (int)-256, (int)255) + 256 + (r >> 4 << 9);
        this.setPos(CLONE_BOX, x, y, z);
    }

    public boolean hasCloneBox() {
        int[] ia = this.getCloneBox();
        return ia[3] > 0;
    }

    public byte getEditMode() {
        return (Byte)this.func_184212_Q().func_187225_a(MODE);
    }

    public void setEditMode(byte par1) {
        this.func_184212_Q().func_187227_b(MODE, (Object)par1);
    }

    public Block getSlotBlock(int index) {
        ItemStack stack = this.slots[index];
        if (stack == null) {
            return Blocks.field_150350_a;
        }
        return Block.func_149634_a((Item)stack.func_77973_b());
    }

    public int getSlotBlockMetadata(int index) {
        ItemStack stack = this.slots[index];
        return stack == null ? 0 : stack.func_77952_i();
    }

    public void dropMiniature(NGTObject par1, float par2) {
        ItemStack stack = ItemMiniature.createMiniatureItem(par1, par2, 0.0f, 0.0f, 0.0f, ItemMiniature.MiniatureMode.miniature, MiniatureBlockState.create((ItemStack)null));
        this.func_70099_a(stack, 1.0f);
    }

    public void updateBlockList(NGTObject ngto) {
        MCTE.NETWORK_WRAPPER.sendToAll((IMessage)new PacketRenderBlocks(this, ngto));
    }

    protected void func_145775_I() {
    }

    @SideOnly(value=Side.CLIENT)
    public void setUpdate(boolean par1) {
        this.needsUpdate = par1;
        if (par1) {
            this.dummyWorld = new NGTWorld(NGTUtil.getClientWorld(), this.blocksForRenderer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldUpdate() {
        return this.needsUpdate;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.slots[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (!this.slots[par1].func_190926_b()) {
            if (this.slots[par1].func_190916_E() <= par2) {
                ItemStack itemstack = this.slots[par1];
                this.slots[par1] = ItemStack.field_190927_a;
                return itemstack;
            }
            ItemStack itemstack = this.slots[par1].func_77979_a(par2);
            if (this.slots[par1].func_190916_E() == 0) {
                this.slots[par1] = ItemStack.field_190927_a;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (!this.slots[par1].func_190926_b()) {
            ItemStack itemstack = this.slots[par1];
            this.slots[par1] = ItemStack.field_190927_a;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int par1, ItemStack par2) {
        this.slots[par1] = par2;
        if (!par2.func_190926_b() && par2.func_190916_E() > this.func_70297_j_()) {
            par2.func_190920_e(this.func_70297_j_());
        }
    }

    public String func_70005_c_() {
        return "Inventory_Editor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int id, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.slots) {
            if (stack.func_190926_b() || stack.func_190916_E() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void importBlocks(File file, float scale) {
        NGTObject obj = NGTObject.importFromFile((File)file, (float)scale);
        if (obj != null) {
            MCTE.NETWORK_WRAPPER.sendToServer((IMessage)new PacketEditorBlockData(this, obj.writeToNBT()));
        }
    }

    public void importBlocksFromNBT(NBTTagCompound nbt) {
        NGTObject ngto = NGTObject.readFromNBT((NBTTagCompound)nbt);
        Editor editor = EditorManager.INSTANCE.getEditor(this.getPlayer());
        if (ngto != null && editor != null) {
            editor.loadData(ngto);
            this.setPos(PASTE_BOX, ngto.xSize, ngto.ySize, ngto.zSize);
            this.updateBlockList(ngto);
        }
    }
}

