/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.editor;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.mcte.editor.Editor;
import jp.ngt.mcte.editor.filter.Repeatable;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.AABBInt;
import jp.ngt.ngtlib.world.NGTWorld;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;

public class WorldSnapshot {
    public static final String IGNORE_AIR = "IgnoreAir";
    public static final String IGNORE_WATER = "IgnoreWater";
    private final List<BlockSet> blockList = new ArrayList<BlockSet>();
    private final List<Entity> entityList = new ArrayList<Entity>();
    private final AABBInt origBox;
    private final boolean hasOrigPos;

    public WorldSnapshot(NGTObject ngto) {
        this.blockList.addAll(ngto.blockList);
        this.origBox = new AABBInt(ngto.origX, ngto.origY, ngto.origZ, ngto.origX + ngto.xSize, ngto.origY + ngto.ySize, ngto.origZ + ngto.zSize);
        this.hasOrigPos = false;
    }

    public WorldSnapshot(List<BlockSet> list, AABBInt box) {
        this.blockList.addAll(list);
        this.origBox = box;
        this.hasOrigPos = false;
    }

    public WorldSnapshot(Editor editor, AABBInt box, String options) {
        this.save(editor, box, options);
        this.origBox = box;
        this.hasOrigPos = true;
    }

    private void save(Editor editor, AABBInt box, String options) {
        NGTLog.startTimer();
        editor.repeat(box, (box2, index, rep, x, y, z) -> {
            IBlockState state;
            BlockSet blockSet = editor.getBlockSet(x, y, z);
            if (options.contains(IGNORE_WATER) && (state = blockSet.toBlockState()).func_185904_a().func_76224_d()) {
                blockSet = BlockSet.AIR;
            }
            this.blockList.add(blockSet);
        }, 1);
        List list = editor.getWorld().func_72839_b((Entity)editor.getEntity(), new AxisAlignedBB((double)box.minX, (double)box.minY, (double)box.minZ, (double)box.maxX, (double)box.maxY, (double)box.maxZ));
        this.entityList.addAll(list);
        NGTLog.stopTimer((String)"save snapshot");
    }

    public void restore(Editor editor) {
        if (this.hasOrigPos) {
            for (BlockSet blockSet : this.blockList) {
                editor.setBlock(blockSet.x, blockSet.y, blockSet.z, blockSet, false);
            }
            editor.updateBlocks(this.origBox);
        }
    }

    public void setBlocks(Editor editor, int x, int y, int z, String options) {
        Repeatable repeater = (rbox, index, rep, rx, ry, rz) -> {
            BlockSet blockSet = this.blockList.get(index);
            if (options.contains(IGNORE_AIR) && blockSet.block == Blocks.field_150350_a) {
                return;
            }
            editor.setBlock(rx, ry, rz, blockSet, true);
        };
        AABBInt box = new AABBInt(x, y, z, x + this.origBox.sizeX(), y + this.origBox.sizeY(), z + this.origBox.sizeZ());
        editor.repeat(box, repeater, 2);
        editor.updateBlocks(box);
    }

    public NGTObject convertNGTO() {
        NBTTagList tagList = NGTWorld.writeEntitiesToNBT(this.entityList);
        return NGTObject.createNGTO(this.blockList, (NBTTagList)tagList, (int)this.origBox.sizeX(), (int)this.origBox.sizeY(), (int)this.origBox.sizeZ(), (int)this.origBox.minX, (int)this.origBox.minY, (int)this.origBox.minZ);
    }

    public int getSize() {
        return this.blockList.size();
    }

    public List<BlockSet> getBlocks() {
        return this.blockList;
    }

    public List<Entity> getEntities() {
        return this.entityList;
    }
}

