/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.editor.filter;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.mcte.editor.filter.CfgParameter;
import jp.ngt.ngtlib.io.NGTText;

public class Config {
    private static final char SEPARATOR = '=';
    public final Map<String, CfgParameter> parameters = new LinkedHashMap<String, CfgParameter>();

    private void addParameter(String name, CfgParameter par) {
        this.parameters.put(name, par);
    }

    public void addInt(String name, int value, int min, int max) {
        this.addParameter(name, new CfgParameter.CfgParameterInt(value, min, max));
    }

    public int getInt(String name) {
        if (this.parameters.containsKey(name)) {
            return (Integer)this.parameters.get(name).getValue();
        }
        throw new IllegalArgumentException("Value Not Found");
    }

    public void setInt(String name, int value) {
        if (this.parameters.containsKey(name)) {
            this.parameters.get(name).setValue(value);
        }
    }

    public void addFloat(String name, float value, float min, float max) {
        this.addParameter(name, new CfgParameter.CfgParameterFloat(value, min, max));
    }

    public float getFloat(String name) {
        if (this.parameters.containsKey(name)) {
            return ((Float)this.parameters.get(name).getValue()).floatValue();
        }
        throw new IllegalArgumentException("Value Not Found");
    }

    public void setFloat(String name, float value) {
        if (this.parameters.containsKey(name)) {
            this.parameters.get(name).setValue(Float.valueOf(value));
        }
    }

    public void addBoolean(String name, boolean value) {
        this.addParameter(name, new CfgParameter.CfgParameterBoolean(value));
    }

    public boolean getBoolean(String name) {
        if (this.parameters.containsKey(name)) {
            return (Boolean)this.parameters.get(name).getValue();
        }
        throw new IllegalArgumentException("Value Not Found");
    }

    public void setBoolean(String name, boolean value) {
        if (this.parameters.containsKey(name)) {
            this.parameters.get(name).setValue(value);
        }
    }

    public void addString(String name, String value, String ... list) {
        this.addParameter(name, new CfgParameter.CfgParameterString(value, list));
    }

    public String getString(String name) {
        if (this.parameters.containsKey(name)) {
            return (String)this.parameters.get(name).getValue();
        }
        throw new IllegalArgumentException("Value Not Found");
    }

    public String[] getStringList(String name) {
        CfgParameter param;
        if (this.parameters.containsKey(name) && (param = this.parameters.get(name)) instanceof CfgParameter.CfgParameterString) {
            return ((CfgParameter.CfgParameterString)param).paramList;
        }
        return new String[0];
    }

    public void setString(String name, String value) {
        if (this.parameters.containsKey(name)) {
            this.parameters.get(name).setValue(value);
        }
    }

    public void load(File file) {
        try {
            this.load(NGTText.readText((File)file, (String)""));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(List<String> list) {
        for (String s : list) {
            int sepIndex = s.indexOf(61);
            if (sepIndex < 0) continue;
            String key = s.substring(0, sepIndex);
            String value = s.substring(sepIndex + 1, s.length());
            if (!this.parameters.containsKey(key)) continue;
            this.parameters.get(key).setRawValue(value);
        }
    }

    public void save(File file) {
        NGTText.writeToText((File)file, (String[])this.export());
    }

    public String[] export() {
        String[] sa = new String[this.parameters.size()];
        int index = 0;
        for (Map.Entry<String, CfgParameter> entry : this.parameters.entrySet()) {
            Object value = entry.getValue().getValue();
            sa[index] = entry.getKey() + '=' + value.toString();
            ++index;
        }
        return sa;
    }
}

