/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.editor.filter;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.editor.Editor;
import jp.ngt.mcte.editor.EditorManager;
import jp.ngt.mcte.editor.EntityEditor;
import jp.ngt.mcte.editor.filter.Config;
import jp.ngt.mcte.editor.filter.EditFilterBase;
import jp.ngt.mcte.editor.filter.EditFilterCopy;
import jp.ngt.mcte.editor.filter.EditFilterCustom;
import jp.ngt.mcte.editor.filter.EditFilterCut;
import jp.ngt.mcte.editor.filter.EditFilterDelete;
import jp.ngt.mcte.editor.filter.EditFilterDeleteEntity;
import jp.ngt.mcte.editor.filter.EditFilterFill;
import jp.ngt.mcte.editor.filter.EditFilterFillSurface;
import jp.ngt.mcte.editor.filter.EditFilterPaste;
import jp.ngt.mcte.editor.filter.EditFilterPerlinNoise;
import jp.ngt.mcte.editor.filter.EditFilterRandom;
import jp.ngt.mcte.network.PacketFilter;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTText;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class FilterManager {
    public static final FilterManager INSTANCE = new FilterManager();
    public static final String FILTER_PATH = "mcte/filter/";
    private Map<String, Class<? extends EditFilterBase>> filterClasses = new HashMap<String, Class<? extends EditFilterBase>>();
    @SideOnly(value=Side.CLIENT)
    private Map<String, EditFilterBase> filters;

    private FilterManager() {
        this.filterClasses.put("Copy", EditFilterCopy.class);
        this.filterClasses.put("Cut", EditFilterCut.class);
        this.filterClasses.put("Delete", EditFilterDelete.class);
        this.filterClasses.put("DeleteEntity", EditFilterDeleteEntity.class);
        this.filterClasses.put("Fill", EditFilterFill.class);
        this.filterClasses.put("FillSurface", EditFilterFillSurface.class);
        this.filterClasses.put("Paste", EditFilterPaste.class);
        this.filterClasses.put("PerlinNoise", EditFilterPerlinNoise.class);
        this.filterClasses.put("Random", EditFilterRandom.class);
    }

    public EditFilterBase getFilterInstance(String name) {
        try {
            Class<? extends EditFilterBase> clazz = this.filterClasses.get(name);
            if (clazz == null) {
                return null;
            }
            Constructor<? extends EditFilterBase> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void loadFilters() {
        this.filters = new LinkedHashMap<String, EditFilterBase>();
        this.initFilter(new EditFilterCopy());
        this.initFilter(new EditFilterCut());
        this.initFilter(new EditFilterDelete());
        this.initFilter(new EditFilterDeleteEntity());
        this.initFilter(new EditFilterFill());
        this.initFilter(new EditFilterFillSurface());
        this.initFilter(new EditFilterPaste());
        this.initFilter(new EditFilterPerlinNoise());
        this.initFilter(new EditFilterRandom());
        File filterFolder = new File((File)NGTFileLoader.getModsDir().get(0), FILTER_PATH);
        try {
            List list = NGTFileLoader.findFileInDirectory((File)filterFolder, file -> file.getName().endsWith(".js"));
            for (File file2 : list) {
                this.initFilter(new EditFilterCustom(NGTText.readText((File)file2, (boolean)false, (String)"")));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initFilter(EditFilterBase filter) {
        File file = filter.getCfgFile();
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Config cfg = new Config();
        filter.init(cfg);
        cfg.load(file);
        filter.save();
        this.filters.put(filter.getFilterName(), filter);
    }

    @SideOnly(value=Side.CLIENT)
    public Collection<EditFilterBase> getFilters() {
        return this.filters.values();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean execFilter(EntityPlayer player, EntityEditor editor, String name) {
        if (!editor.isSelectEnd()) {
            return false;
        }
        EditFilterBase filter = this.filters.get(name);
        String[] sa = filter.getCfg().export();
        StringBuilder builder = new StringBuilder();
        for (String s : sa) {
            builder.append(s).append(",");
        }
        String script = "";
        if (filter instanceof EditFilterCustom) {
            script = ((EditFilterCustom)filter).getScriptText();
        }
        MCTE.NETWORK_WRAPPER.sendToServer((IMessage)new PacketFilter(player, name, builder.toString(), script));
        return true;
    }

    public void execFilter(EntityPlayer player, String name, String data, String script) {
        EditFilterBase filter = this.getFilterInstance(name);
        if (filter == null) {
            filter = new EditFilterCustom(script);
        }
        Config cfg = new Config();
        filter.init(cfg);
        List<String> list = Arrays.asList(data.split(","));
        cfg.load(list);
        Editor editor = EditorManager.INSTANCE.getEditor(player);
        if (editor != null) {
            filter.edit(editor);
        }
    }
}

