/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.gui;

import java.io.File;
import java.io.IOException;
import jp.ngt.mcte.block.MiniatureBlockState;
import jp.ngt.mcte.item.ItemMiniature;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.gui.GuiScreenCustom;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.network.PacketNBT;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiItemMiniature
extends GuiScreenCustom {
    private final EntityPlayer player;
    private final ItemStack miniatureItem;
    private GuiButton buttonDone;
    private GuiButton buttonMode;
    private GuiButton enableAABB;
    private GuiTextField fieldScale;
    private GuiTextField fieldOffsetX;
    private GuiTextField fieldOffsetY;
    private GuiTextField fieldOffsetZ;
    private GuiTextField fieldName;
    private GuiTextField fieldLightValue;
    private GuiTextField fieldAABB;
    private GuiTextField fieldMoveOption;
    private boolean enabledFieldAABB;
    private float scale;
    private float offsetX;
    private float offsetY;
    private float offsetZ;
    private MiniatureBlockState state;
    private NGTObject ngto;
    private ItemMiniature.MiniatureMode mode;

    public GuiItemMiniature(EntityPlayer par1) {
        this.player = par1;
        this.miniatureItem = par1.field_71071_by.func_70448_g();
        if (this.miniatureItem.func_77942_o()) {
            NBTTagCompound nbt = this.miniatureItem.func_77978_p();
            float[] fa = ItemMiniature.getOffset(nbt);
            this.offsetX = fa[0];
            this.offsetY = fa[1];
            this.offsetZ = fa[2];
            this.scale = ItemMiniature.getScale(nbt);
            this.ngto = ItemMiniature.getNGTObject(nbt);
            this.mode = ItemMiniature.getMode(nbt);
            this.state = ItemMiniature.getMiniatureBlockState(nbt, this.miniatureItem);
        } else {
            this.scale = 1.0f;
            this.mode = ItemMiniature.MiniatureMode.miniature;
            this.state = MiniatureBlockState.create(this.miniatureItem);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int hw = this.field_146294_l / 2;
        this.field_146292_n.clear();
        this.buttonDone = new GuiButton(0, hw - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.buttonDone.field_146124_l = this.ngto != null;
        this.field_146292_n.add(this.buttonDone);
        this.field_146292_n.add(new GuiButton(1, hw + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        int h = 40;
        this.field_146292_n.add(new GuiButton(100, hw - 120, h, 80, 20, I18n.func_135052_a((String)"gui.mcte.miniature.select", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(101, hw - 120, h + 20, 80, 20, I18n.func_135052_a((String)"gui.mcte.miniature.export", (Object[])new Object[0])));
        this.buttonMode = new GuiButton(102, hw - 120, h + 40, 80, 20, I18n.func_135052_a((String)("gui.mcte.miniature." + this.mode.toString()), (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonMode);
        this.enableAABB = new GuiButton(103, hw - 182, h + 120, 20, 20, "");
        this.field_146292_n.add(this.enableAABB);
        int i2 = 40;
        this.fieldScale = this.setTextField(hw + i2, h, 80, 20, String.valueOf(this.scale));
        this.fieldOffsetX = this.setTextField(hw + i2, h + 20, 80, 20, String.valueOf(this.offsetX));
        this.fieldOffsetY = this.setTextField(hw + i2, h + 40, 80, 20, String.valueOf(this.offsetY));
        this.fieldOffsetZ = this.setTextField(hw + i2, h + 60, 80, 20, String.valueOf(this.offsetZ));
        this.fieldLightValue = this.setTextField(hw + i2, h + 80, 80, 20, String.valueOf(this.state.lightValue));
        String name = this.miniatureItem.func_82833_r();
        this.fieldName = this.setTextField(hw - 120, h + 70, 100, 20, name);
        this.enabledFieldAABB = this.state.hasCustomAABB();
        this.fieldAABB = this.setTextField(hw - 160, h + 120, 340, 20, this.state.getAabbAsJson());
        this.fieldAABB.func_146184_c(this.enabledFieldAABB);
        this.fieldMoveOption = this.setTextField(hw - 160, h + 140, 340, 20, this.state.getMotionAsJson());
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.sendPacket();
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 100) {
            this.selectFile();
        } else if (button.field_146127_k == 101) {
            this.exportFile();
        } else if (button.field_146127_k == 102) {
            ItemMiniature.MiniatureMode[] array = ItemMiniature.MiniatureMode.values();
            int i = this.mode.id;
            if (++i >= array.length) {
                i = 0;
            }
            this.mode = array[i];
            this.buttonMode.field_146126_j = I18n.func_135052_a((String)("gui.mcte.miniature." + this.mode.toString()), (Object[])new Object[0]);
        } else if (button.field_146127_k == 103) {
            this.enabledFieldAABB ^= true;
            this.fieldAABB.func_146184_c(this.enabledFieldAABB);
            this.state.setCustomAABB(this.enabledFieldAABB);
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        try {
            this.scale = this.getFloat(this.fieldScale.func_146179_b());
            this.offsetX = this.getFloat(this.fieldOffsetX.func_146179_b());
            this.offsetY = this.getFloat(this.fieldOffsetY.func_146179_b());
            this.offsetZ = this.getFloat(this.fieldOffsetZ.func_146179_b());
            this.state.lightValue = this.getByte(this.fieldLightValue.func_146179_b());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private float getFloat(String s) {
        float f = Float.parseFloat(s);
        if (f == Float.NaN) {
            throw new NumberFormatException();
        }
        return f;
    }

    private byte getByte(String s) {
        byte b = Byte.parseByte(s);
        if (b < 0 || b > 15) {
            throw new NumberFormatException();
        }
        return b;
    }

    private void selectFile() {
        File file = NGTFileLoader.selectFile((FileType[])new FileType[]{FileType.NGTO, FileType.MQO, FileType.OBJ});
        if (file != null) {
            NGTObject obj;
            this.ngto = obj = NGTObject.importFromFile((File)file, (float)this.scale);
            this.buttonDone.field_146124_l = true;
        }
    }

    private void exportFile() {
        if (this.ngto == null) {
            return;
        }
        File file = NGTFileLoader.saveFile((FileType[])new FileType[]{FileType.NGTO, FileType.OBJ});
        if (file != null) {
            this.ngto.exportToFile(file);
        }
    }

    private void sendPacket() {
        if (this.ngto != null) {
            String name;
            this.state.setAABB(this.fieldAABB.func_146179_b());
            this.state.setMotion(this.fieldMoveOption.func_146179_b());
            this.state.name = name = this.fieldName.func_146179_b();
            ItemStack stack = ItemMiniature.createMiniatureItem(this.ngto, this.scale, this.offsetX, this.offsetY, this.offsetZ, this.mode, this.state);
            String s = ChatAllowedCharacters.func_71565_a((String)name);
            if (s.length() <= 30) {
                stack.func_151001_c(s);
            }
            PacketNBT.sendToServer((EntityPlayer)this.player, (ItemStack)stack);
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
        int hw = this.field_146294_l / 2;
        int i2 = hw + 5;
        int i3 = 45;
        this.func_73731_b(this.field_146289_q, "Scale", i2, i3, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "OffsetX", i2, i3 + 20, 0xFF0000);
        this.func_73731_b(this.field_146289_q, "OffsetY", i2, i3 + 40, 65280);
        this.func_73731_b(this.field_146289_q, "OffsetZ", i2, i3 + 60, 255);
        this.func_73731_b(this.field_146289_q, "Brightness", hw, i3 + 80, 0xFFFFFF);
    }
}

