/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.item;

import jp.ngt.mcte.item.ItemEditor;
import jp.ngt.mcte.item.PainterSetting;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.item.ItemCustom;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPainter
extends ItemCustom {
    public ItemPainter() {
        this.func_77625_d(1);
    }

    protected ActionResult<ItemStack> onItemRightClick(ItemArgHolderBase.ItemArgHolder holder) {
        holder.getPlayer().func_184598_c(holder.getHand());
        return holder.success();
    }

    protected ActionResult<ItemStack> onItemUse(ItemArgHolderBase.ItemArgHolder holder, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = holder.getItemStack();
        World world = holder.getWorld();
        EntityPlayer player = holder.getPlayer();
        BlockPos pos = holder.getBlockPos();
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                int meta = block.func_176201_c(state);
                ItemStack stack = new ItemStack(block, 1, meta);
                NGTLog.sendChatMessage((ICommandSender)player, (String)(stack.func_82833_r() + "(" + Block.field_149771_c.func_177774_c((Object)block) + ", " + meta + ")"), (Object[])new Object[0]);
                if (block.hasTileEntity(state)) {
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile != null) {
                        NGTLog.sendChatMessage((ICommandSender)player, (String)tile.getClass().toString(), (Object[])new Object[0]);
                    } else {
                        NGTLog.sendChatMessage((ICommandSender)player, (String)"No TileEntity", (Object[])new Object[0]);
                    }
                }
            } else {
                this.onUsingTick(itemStack, (EntityLivingBase)player, 0);
            }
        }
        return holder.success();
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        if (!living.func_130014_f_().field_72995_K && living instanceof EntityPlayer) {
            PainterSetting setting = PainterSetting.getPainterSettingFromItem(stack);
            RayTraceResult target = ItemEditor.getTarget((EntityPlayer)living, setting.drawMode == 0, false);
            if (target != null && setting != null) {
                BlockPos pos = target.func_178782_a();
                this.placeBlocks(setting, living.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
    }

    private void placeBlocks(PainterSetting setting, World world, int x, int y, int z) {
        int size = setting.size - 1;
        for (int i = -size; i <= size; ++i) {
            for (int j = -size; j <= size; ++j) {
                for (int k = -size; k <= size; ++k) {
                    boolean flag2;
                    int x0 = x + i;
                    int y0 = y + j;
                    int z0 = z + k;
                    if (i * i + j * j + k * k > size * size) continue;
                    Block targetBlock = BlockUtil.getBlock((IBlockAccess)world, (int)x0, (int)y0, (int)z0);
                    int targetMetadata = BlockUtil.getMetadata((IBlockAccess)world, (int)x0, (int)y0, (int)z0);
                    boolean flag1 = setting.fill && targetBlock == Blocks.field_150350_a;
                    boolean bl = flag2 = setting.rewrite && targetBlock != Blocks.field_150357_h && (setting.rewriteBlock.block == Blocks.field_150350_a || setting.rewriteBlock.block == targetBlock && setting.rewriteBlock.metadata == targetMetadata);
                    if (!flag1 && !flag2) continue;
                    BlockUtil.setBlock((World)world, (int)x0, (int)y0, (int)z0, (Block)setting.fillBlock.block, (int)setting.fillBlock.metadata, (int)2);
                }
            }
        }
    }

    public int func_77626_a(ItemStack itemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1) {
        return EnumAction.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

