/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.item;

import java.util.HashMap;
import java.util.Map;
import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.block.MiniatureBlockState;
import jp.ngt.mcte.block.RenderMiniature;
import jp.ngt.mcte.item.ItemMiniature;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.item.IItemRendererCustom;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.NGTObjectRenderer;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.ngtlib.world.IBlockAccessNGT;
import jp.ngt.ngtlib.world.NGTWorld;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderItemMiniature
implements IItemRendererCustom {
    public static final RenderItemMiniature INSTANCE = new RenderItemMiniature();
    private Map<ItemStack, RenderProp> propMap = new HashMap<ItemStack, RenderProp>();

    private RenderItemMiniature() {
    }

    public void renderItem(ItemStack itemStack) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        this.renderItem(itemStack, 0);
        GL11.glPopMatrix();
    }

    public void renderItem(ItemStack item, int renderType) {
        if (!item.func_77942_o()) {
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)0.0f, (float)-0.425f, (float)0.0f);
            Minecraft mc = NGTUtilClient.getMinecraft();
            mc.func_175602_ab().func_175016_a(Blocks.field_150348_b.func_176223_P(), mc.field_71439_g.func_70013_c());
            GL11.glPopMatrix();
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8256);
        GL11.glEnable((int)32826);
        RenderProp prop = this.propMap.get(item);
        if (prop == null) {
            NGTObject ngto = ItemMiniature.getNGTObject(item.func_77978_p());
            if (ngto == null) {
                return;
            }
            prop = new RenderProp(ngto, item);
            this.propMap.put(item, prop);
        }
        GL11.glTranslatef((float)prop.offsetX, (float)prop.offsetY, (float)prop.offsetZ);
        RenderMiniature.setupMotionAndScale(prop.mbState, 0.0f, prop.scale, prop.offsetX, prop.offsetY, prop.offsetZ, 0);
        GL11.glTranslatef((float)(-prop.corX), (float)0.0f, (float)(-prop.corZ));
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass >= 0 && renderType == 0) {
            this.renderWithProp(prop, pass);
        } else {
            ForgeHooksClient.setRenderPass((int)0);
            this.renderWithProp(prop, 0);
            ForgeHooksClient.setRenderPass((int)1);
            this.renderWithProp(prop, 1);
            ForgeHooksClient.setRenderPass((int)pass);
        }
        GLHelper.setLightmapMaxBrightness();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderWithProp(RenderProp prop, int pass) {
        NGTObjectRenderer.INSTANCE.renderTileEntities(prop.world, 0.0f, pass);
        NGTObjectRenderer.INSTANCE.renderEntities(prop.world, 0.0f, pass);
        this.renderBlocks(prop, 0.0f, pass);
    }

    private void renderBlocks(RenderProp prop, float par3, int pass) {
        boolean smoothing;
        if (prop.glLists == null) {
            prop.glLists = new GLObject[2];
        }
        NGTUtilClient.getMinecraft().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        boolean bl = smoothing = NGTUtilClient.getMinecraft().field_71474_y.field_74348_k != 0;
        if (smoothing) {
            GL11.glShadeModel((int)7425);
        }
        if (!GLHelper.isValid((GLObject)prop.glLists[pass])) {
            prop.glLists[pass] = GLHelper.generateGLList((GLObject)prop.glLists[pass]);
            GLHelper.startCompile((GLObject)prop.glLists[pass]);
            NGTObjectRenderer.INSTANCE.renderNGTObject((IBlockAccessNGT)prop.world, prop.ngto, true, prop.mode, pass);
            GLHelper.endCompile();
        } else {
            GLHelper.callList((GLObject)prop.glLists[pass]);
        }
        if (smoothing) {
            GL11.glShadeModel((int)7424);
        }
        GLHelper.enableLighting();
        NGTUtilClient.getMinecraft().field_71460_t.func_180436_i();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderArmor(ItemStack item) {
        if (item == null) {
            return;
        }
        if (item.func_77973_b() == MCTE.itemMiniature) {
            float f1 = 0.625f;
            GL11.glScalef((float)f1, (float)f1, (float)f1);
            this.renderItem(item, 1);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        GL11.glPushMatrix();
        GL11.glRotatef((float)(-player.field_70761_aq), (float)0.0f, (float)1.0f, (float)0.0f);
        if (player.func_70093_af()) {
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
        this.renderArmor(player.field_71071_by.func_70440_f(2));
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Specials.Pre event) {
        EntityLivingBase entity = event.getEntity();
        if (event.getRenderer() instanceof RenderBiped && entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            GL11.glPushMatrix();
            float f2 = living.field_70761_aq;
            float f3 = living.field_70759_as;
            if (living.func_184218_aH() && living.func_184187_bx() instanceof EntityLivingBase) {
                EntityLivingBase rider = (EntityLivingBase)living.func_184187_bx();
                f2 = rider.field_70761_aq;
                float f4 = NGTMath.wrapAngle((float)(f3 - f2));
                f4 = f4 < -85.0f ? -85.0f : (f4 >= 85.0f ? 85.0f : f4);
                f2 = f3 - f4;
                if (f4 * f4 > 2500.0f) {
                    f2 += f4 * 0.2f;
                }
            }
            float f13 = living.field_70125_A;
            GL11.glTranslatef((float)((float)event.getX()), (float)((float)event.getY()), (float)((float)event.getZ()));
            GL11.glRotatef((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
            if (living.field_70725_aQ > 0) {
                float f33 = ((float)living.field_70725_aQ - 1.0f) / 20.0f * 1.6f;
                if ((f33 = (float)Math.sqrt(f33)) > 1.0f) {
                    f33 = 1.0f;
                }
                GL11.glRotatef((float)(f33 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            float f5 = 0.0625f;
            GL11.glEnable((int)32826);
            GL11.glPushMatrix();
            if (entity.func_70093_af()) {
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
            this.renderArmor(living.func_184582_a(EntityEquipmentSlot.CHEST));
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private class RenderProp {
        public NGTObject ngto;
        public MiniatureBlockState mbState;
        public float offsetX;
        public float offsetY;
        public float offsetZ;
        public float scale;
        public int mode;
        public NGTWorld world;
        public GLObject[] glLists;
        public float corX;
        public float corZ;
        public float scaleInInventory;

        public RenderProp(NGTObject par1, ItemStack item) {
            this.ngto = par1;
            this.world = new NGTWorld(NGTUtil.getClientWorld(), par1);
            this.corX = (float)par1.xSize * 0.5f;
            this.corZ = (float)par1.zSize * 0.5f;
            NBTTagCompound nbt = item.func_77978_p();
            this.mbState = ItemMiniature.getMiniatureBlockState(nbt, item);
            float[] fa = ItemMiniature.getOffset(nbt);
            this.offsetX = fa[0];
            this.offsetY = fa[1];
            this.offsetZ = fa[2];
            this.scale = ItemMiniature.getScale(nbt);
            this.mode = ItemMiniature.getMode((NBTTagCompound)nbt).id;
            int i0 = par1.xSize > par1.ySize ? (par1.xSize > par1.zSize ? par1.xSize : par1.zSize) : (par1.ySize > par1.zSize ? par1.ySize : par1.zSize);
            this.scaleInInventory = 1.0f / (float)i0;
        }
    }
}

