/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.network;

import io.netty.buffer.ByteBuf;
import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.editor.EditEntry;
import jp.ngt.mcte.editor.Editor;
import jp.ngt.mcte.editor.EditorManager;
import jp.ngt.mcte.editor.EditorTransform;
import jp.ngt.mcte.editor.EntityEditor;
import jp.ngt.mcte.network.PacketExportData;
import jp.ngt.ngtlib.block.NGTObject;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketEditor
implements IMessage,
IMessageHandler<PacketEditor, IMessage> {
    private String playerName;
    private String type;
    private int[] start;
    private int[] end;
    private int[] clone;

    public PacketEditor() {
    }

    public PacketEditor(EntityEditor par1, String par2, int[] par4, int[] par5, int[] par6) {
        this.playerName = par1.getPlayer().func_70005_c_();
        this.type = par2;
        this.start = par4;
        this.end = par5;
        this.clone = par6;
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.playerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.type);
        buffer.writeInt(this.start[0]);
        buffer.writeInt(this.start[1]);
        buffer.writeInt(this.start[2]);
        buffer.writeInt(this.end[0]);
        buffer.writeInt(this.end[1]);
        buffer.writeInt(this.end[2]);
        buffer.writeInt(this.clone[0]);
        buffer.writeInt(this.clone[1]);
        buffer.writeInt(this.clone[2]);
        buffer.writeInt(this.clone[3]);
    }

    public void fromBytes(ByteBuf buffer) {
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.type = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.start = new int[3];
        this.start[0] = buffer.readInt();
        this.start[1] = buffer.readInt();
        this.start[2] = buffer.readInt();
        this.end = new int[3];
        this.end[0] = buffer.readInt();
        this.end[1] = buffer.readInt();
        this.end[2] = buffer.readInt();
        this.clone = new int[4];
        this.clone[0] = buffer.readInt();
        this.clone[1] = buffer.readInt();
        this.clone[2] = buffer.readInt();
        this.clone[3] = buffer.readInt();
    }

    public IMessage onMessage(final PacketEditor message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        final Editor editor = EditorManager.INSTANCE.getEditor(message.playerName);
        if (editor != null) {
            EntityEditor entityEditor = editor.getEntity();
            entityEditor.setPos(EntityEditor.START_POS, message.start[0], message.start[1], message.start[2]);
            entityEditor.setPos(EntityEditor.END_POS, message.end[0], message.end[1], message.end[2]);
            entityEditor.setCloneBox(message.clone[0], message.clone[1], message.clone[2], message.clone[3]);
            if (message.type.equals("replace")) {
                entityEditor.post(new EditEntry(){

                    @Override
                    public void edit() {
                        editor.editBlocks((byte)6, 0.0f);
                    }
                });
            } else if (message.type.equals("clone")) {
                entityEditor.post(new EditEntry(){

                    @Override
                    public void edit() {
                        editor.editBlocks((byte)7, 0.0f);
                    }
                });
            } else if (message.type.startsWith("miniature")) {
                entityEditor.post(new EditEntry(){

                    @Override
                    public void edit() {
                        String[] sa = message.type.split(":");
                        float rate = Float.parseFloat(sa[1]);
                        editor.editBlocks((byte)10, rate);
                    }
                });
            } else if (message.type.startsWith("transform")) {
                String[] sa = message.type.split(":");
                int type = Integer.parseInt(sa[1]);
                editor.transformBlocks(EditorTransform.values()[type]);
            } else if (message.type.startsWith("export")) {
                String[] sa = message.type.split(" ");
                NGTObject ngto = editor.copy(editor.getSelectBox(), "").convertNGTO();
                MCTE.NETWORK_WRAPPER.sendTo((IMessage)new PacketExportData(sa[1], ngto), ctx.getServerHandler().field_147369_b);
            }
        }
        return null;
    }
}

