/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import jp.ngt.ngtlib.math.Complex;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;

public class ChunkProviderScript
implements IChunkGenerator {
    private final Random rand;
    private final World worldObj;
    private final boolean mapFeaturesEnabled;
    protected static final double RANGE = 1.0E-5;

    public ChunkProviderScript(World par1, long par2, boolean par3) {
        this.rand = new Random(par2);
        this.worldObj = par1;
        this.mapFeaturesEnabled = par3;
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)Biomes.field_76771_b);
        }
        chunk.func_76603_b();
        return chunk;
    }

    protected void setBlocksInChunk(int par1, int par2, ChunkPrimer par3) {
        int x = par1 << 4;
        int z = par2 << 4;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 128; ++k) {
                    double d0 = (double)k / 128.0;
                    double m = this.mandelbox(x + i, k, z + j);
                    if (!(m >= 0.5)) continue;
                    par3.func_177855_a(i, k, j, Blocks.field_150348_b.func_176223_P());
                }
            }
        }
    }

    public void func_185931_b(int x, int z) {
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return new ArrayList<Biome.SpawnListEntry>();
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    protected double mandelbrot(int x, int z, Complex cz) {
        double limitSq = 100.0;
        int maxCount = 512;
        double r = (double)x * 1.0E-5;
        double i = (double)z * 1.0E-5;
        Complex c = new Complex(r, i);
        for (int count = 0; count < maxCount; ++count) {
            if (!((cz = cz.multiply(cz).add(c)).absSq() >= limitSq)) continue;
            return (double)count / (double)maxCount;
        }
        return 1.0;
    }

    protected double mandelbox(int x, int y, int z) {
        double x2 = (double)x * 1.0E-5;
        double y2 = (double)y * 1.0E-5;
        double z2 = (double)z * 1.0E-5;
        double limit = 5.0;
        double r = 0.5;
        double s = 1.5;
        int maxCount = 256;
        Vec3d vc = new Vec3d(x2, y2, z2);
        Vec3d vz = new Vec3d(0.0, 0.0, 0.0);
        for (int count = 0; count < maxCount; ++count) {
            double xd = vz.field_72450_a;
            double yd = vz.field_72448_b;
            double zd = vz.field_72449_c;
            if (xd > 1.0) {
                xd = 2.0 - xd;
            } else if (xd < -1.0) {
                xd = -2.0 - xd;
            }
            if (yd > 1.0) {
                yd = 2.0 - yd;
            } else if (yd < -1.0) {
                yd = -2.0 - yd;
            }
            if (zd > 1.0) {
                zd = 2.0 - zd;
            } else if (yd < -1.0) {
                zd = -2.0 - zd;
            }
            vz = new Vec3d(xd, yd, zd);
            double len = vz.func_72433_c();
            if (len > 0.0) {
                double l2 = len;
                if (len < r) {
                    l2 = len / (r * r);
                } else if (len < 1.0) {
                    l2 = 1.0 / len;
                }
                vz = vz.func_186678_a(l2 / len);
            }
            if (!((vz = vz.func_186678_a(s).func_178787_e(vc)).func_72433_c() > limit)) continue;
            return (double)count / (double)maxCount;
        }
        return 1.0;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

