/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.world;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.math.AABBInt;
import jp.ngt.rtm.entity.train.util.Formation;
import jp.ngt.rtm.entity.train.util.FormationManager;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.WorldSavedData;

public class StructureManager {
    private static final String SAVE_NAME = "mcte_structures";
    private static final String STRUCTURE_PATH = "mcte/structure/";
    private static final ResourceLocation[] SAMPLES = new ResourceLocation[]{new ResourceLocation("mcte", "structures/chino.ngto"), new ResourceLocation("mcte", "structures/hoppo.ngto")};
    private final World world;
    private final List<Template> templates = new ArrayList<Template>();
    private StructureData data;

    public StructureManager(World par1) {
        this.world = par1;
        this.loadStructures();
    }

    private void loadStructures() {
        File folder = new File((File)NGTFileLoader.getModsDir().get(0), STRUCTURE_PATH);
        folder.mkdirs();
        try {
            List list = NGTFileLoader.findFileInDirectory((File)folder, file -> file.getName().endsWith(".ngto"));
            for (File file2 : list) {
                NGTObject ngto = NGTObject.importFromFile((File)file2, (float)1.0f);
                this.templates.add(ngto.toTemplate(this.world));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.templates.isEmpty()) {
            this.loadSample(folder);
        }
    }

    private void loadSample(File folder) {
        for (int i = 0; i < SAMPLES.length; ++i) {
            try {
                NGTObject sample = NGTObject.load((InputStream)NGTFileLoader.getInputStream((ResourceLocation)SAMPLES[i]));
                sample.exportToFile(new File(folder, "sample_" + i + ".ngto"));
                this.templates.add(sample.toTemplate(this.world));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void init(World world) {
        StructureData data = (StructureData)world.func_72943_a(StructureData.class, SAVE_NAME);
        if (data == null) {
            data = new StructureData(SAVE_NAME);
            world.func_72823_a(SAVE_NAME, (WorldSavedData)data);
        }
        this.data = data;
    }

    public void setBlocksInChunk(int par1, int par2, ChunkPrimer par3) {
        int chunkX = par1 << 4;
        int chunkZ = par2 << 4;
        boolean flag = par1 % 2 + par2 % 2 == 1;
        IBlockState state = flag ? Blocks.field_150348_b.func_176223_P() : Blocks.field_150322_A.func_176223_P();
        AABBInt aabb = new AABBInt(16, 1, 16);
        aabb.repeat((x, y, z, count) -> par3.func_177855_a(x, y, z, state));
    }

    public void populate(int par1, int par2) {
        if (this.templates.isEmpty()) {
            return;
        }
        int chunkX = par1 << 4;
        int chunkZ = par2 << 4;
        Rotation rotation = Rotation.values()[this.world.field_73012_v.nextInt(Rotation.values().length)];
        Mirror mirror = Mirror.values()[this.world.field_73012_v.nextInt(Mirror.values().length)];
        ChunkPos chunkPos = new ChunkPos(par1, par2);
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror).func_186218_a(chunkPos);
        TemplateManager tm = this.world.func_72860_G().func_186340_h();
        Template template = this.templates.get(this.world.field_73012_v.nextInt(this.templates.size()));
        BlockPos center = new BlockPos(chunkX + template.func_186259_a().func_177958_n() / 2, 1, chunkZ + template.func_186259_a().func_177952_p() / 2);
        template.func_186260_a(this.world, center, settings);
    }

    public class StructureConfig {
    }

    public class StructureData
    extends WorldSavedData {
        public StructureData(String name) {
            super(name);
        }

        public void func_76184_a(NBTTagCompound nbt) {
            NBTTagList tagList = nbt.func_150295_c("CustomStructures", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound nBTTagCompound = tagList.func_150305_b(i);
            }
        }

        public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
            NBTTagList tagList = new NBTTagList();
            for (Formation formation : FormationManager.getInstance().getFormations().values()) {
                NBTTagCompound tag = new NBTTagCompound();
                formation.writeToNBT(tag, false);
                tagList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("CustomStructures", (NBTBase)tagList);
            return nbt;
        }
    }
}

