/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.world;

import jp.ngt.mcte.gui.GuiCreatePictorialWorld;
import jp.ngt.mcte.world.ChunkManagerPictorialCustom;
import jp.ngt.mcte.world.ChunkProviderPictorialCustom;
import jp.ngt.mcte.world.GenLayerPictorialCustom;
import jp.ngt.mcte.world.WorldData;
import jp.ngt.ngtlib.io.NGTLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldTypePictorial
extends WorldType {
    public static WorldType PICTORIAL;

    public static void init() {
        PICTORIAL = new WorldTypePictorial("pictorial");
    }

    public WorldTypePictorial(String name) {
        super(name);
    }

    public BiomeProvider getBiomeProvider(World world) {
        WorldData worldData = WorldData.getWorldData(world, world.func_72912_H().func_82571_y());
        if (worldData == null || !worldData.getWorldGenerator().hasBiomesData()) {
            NGTLog.debug((String)"set default ChunkManager");
            return new BiomeProvider(world.func_72912_H());
        }
        return new ChunkManagerPictorialCustom(world, worldData);
    }

    public IChunkGenerator getChunkGenerator(World world, String generatorOptions) {
        WorldData worldData = WorldData.getWorldData(world, generatorOptions);
        if (worldData == null || !worldData.getWorldGenerator().hasTerrainData()) {
            NGTLog.debug((String)"set default ChunkGenerator");
            return new ChunkGeneratorOverworld(world, world.func_72905_C(), world.func_72912_H().func_76089_r(), generatorOptions);
        }
        return new ChunkProviderPictorialCustom(world, world.func_72905_C(), world.func_72912_H().func_76089_r(), worldData);
    }

    public int getMinimumSpawnHeight(World world) {
        return (int)this.getHorizon(world) + 1;
    }

    public double getHorizon(World world) {
        WorldData worldData = WorldData.getWorldData(world, world.func_72912_H().func_82571_y());
        if (worldData != null) {
            return worldData.seaLevel;
        }
        return 63.0;
    }

    public boolean isCustomizable() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onCustomizeButton(Minecraft instance, GuiCreateWorld guiCreateWorld) {
        instance.func_147108_a((GuiScreen)new GuiCreatePictorialWorld(guiCreateWorld));
    }

    public GenLayer getBiomeLayer(long worldSeed, GenLayer parentLayer, ChunkGeneratorSettings chunkSettings) {
        return new GenLayerPictorialCustom(worldSeed);
    }
}

