/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.ngt.ngtlib.event.TickProcessEntry;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public final class TickProcessQueue {
    private static final TickProcessQueue INSTANCE_SERVER = new TickProcessQueue();
    private static final TickProcessQueue INSTANCE_CLIENT = new TickProcessQueue();
    private final List<TickProcessEntry> entries = Collections.synchronizedList(new ArrayList());
    private final List<TickProcessEntry> succeededEntries = new ArrayList<TickProcessEntry>();
    private final List<TickProcessEntry> newEntries = new ArrayList<TickProcessEntry>();

    private TickProcessQueue() {
    }

    public static TickProcessQueue getInstance(Side side) {
        return side == Side.SERVER ? INSTANCE_SERVER : INSTANCE_CLIENT;
    }

    public void add(TickProcessEntry entry) {
        this.newEntries.add(entry);
    }

    public void add(TickProcessEntry entry, int delay) {
        this.newEntries.add(new DelayProcessEntry(entry, delay));
    }

    public void add(TickProcessEntry entry, int maxRetry, int interval) {
        this.newEntries.add(new RetryProcessEntry(entry, maxRetry, interval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick(World world) {
        List<TickProcessEntry> list = this.entries;
        synchronized (list) {
            this.entries.addAll(this.newEntries);
            this.newEntries.clear();
            if (!this.entries.isEmpty()) {
                for (TickProcessEntry entry : this.entries) {
                    if (entry == null || !entry.process(world)) continue;
                    this.succeededEntries.add(entry);
                }
                if (!this.succeededEntries.isEmpty()) {
                    this.entries.removeAll(this.succeededEntries);
                    this.succeededEntries.clear();
                }
            }
        }
    }

    private class RetryProcessEntry
    implements TickProcessEntry {
        private final TickProcessEntry entry;
        private final int maxRetry;
        private final int interval;
        private int count;

        public RetryProcessEntry(TickProcessEntry par1, int par2, int par3) {
            this.entry = par1;
            this.maxRetry = par2;
            this.interval = par3;
        }

        @Override
        public boolean process(World world) {
            if (this.count % this.interval == 0) {
                if (this.entry.process(world)) {
                    return true;
                }
                if (this.maxRetry <= this.count) {
                    return true;
                }
            }
            ++this.count;
            return false;
        }
    }

    private class DelayProcessEntry
    implements TickProcessEntry {
        private final TickProcessEntry entry;
        private final int delay;
        private int count;

        public DelayProcessEntry(TickProcessEntry par1, int par2) {
            this.entry = par1;
            this.delay = par2;
        }

        @Override
        public boolean process(World world) {
            if (this.delay <= this.count) {
                return this.entry.process(world);
            }
            ++this.count;
            return false;
        }
    }
}

