/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.io;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.ngt.ngtlib.NGTCore;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.TwitterSetting;
import net.minecraft.command.ICommandSender;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.User;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterUtil {
    private File fileDir = NGTCore.proxy.getMinecraftDirectory("ngt");
    private File settingFile = new File(this.fileDir, "twitter.json");
    private static final TwitterUtil INSTANCE = new TwitterUtil();
    private Twitter twitter;
    private Twitter twitterAuthTemp;
    private boolean waitingAuth;

    private TwitterUtil() {
    }

    @Nullable
    public static TwitterUtil getInstance() {
        if (TwitterUtil.INSTANCE.twitter == null) {
            if (TwitterUtil.INSTANCE.waitingAuth) {
                return null;
            }
            try {
                INSTANCE.init();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return INSTANCE;
    }

    public void init() throws IOException, TwitterException, URISyntaxException {
        TwitterSetting setting = TwitterSetting.load(this.settingFile);
        if (!setting.isValid()) {
            this.showAuthDialog(setting);
        } else {
            this.setOAuthKey(setting);
        }
    }

    private void showAuthDialog(TwitterSetting setting) throws IOException, URISyntaxException, TwitterException {
        RequestToken requestToken = this.geRequestToken(setting);
        this.openDialog(setting, requestToken.getAuthorizationURL());
    }

    private RequestToken geRequestToken(TwitterSetting setting) throws TwitterException {
        if (this.twitterAuthTemp == null) {
            this.twitterAuthTemp = TwitterFactory.getSingleton();
            this.twitterAuthTemp.setOAuthConsumer(setting.consumerKey, setting.consumerSecret);
        }
        return this.twitterAuthTemp.getOAuthRequestToken();
    }

    private void setOAuthKey(TwitterSetting setting) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setDebugEnabled(true).setOAuthConsumerKey(setting.consumerKey).setOAuthConsumerSecret(setting.consumerSecret).setOAuthAccessToken(setting.accessToken).setOAuthAccessTokenSecret(setting.accessTokenSecret);
        this.twitter = new TwitterFactory(cb.build()).getInstance();
        NGTLog.debug("[Twitter] OAuth finished.");
    }

    private void openDialog(final TwitterSetting setting, final String url) throws IOException, URISyntaxException {
        this.waitingAuth = true;
        NGTLog.debug("[Twitter] Open dialog.");
        final JFrame frame = new JFrame("OAuth");
        frame.setDefaultCloseOperation(0);
        frame.setSize(320, 180);
        frame.setLocationByPlatform(true);
        frame.setResizable(false);
        JButton buttonOpenLink = new JButton("Open Authentication Link");
        buttonOpenLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (IOException | URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        buttonOpenLink.setAlignmentX(0.5f);
        final JTextField field = new JTextField();
        field.setAlignmentX(0.5f);
        JButton buttonOK = new JButton("OK");
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String s = field.getText();
                if (TwitterUtil.this.setPIN(setting, s)) {
                    frame.dispose();
                }
            }
        });
        buttonOK.setAlignmentX(0.5f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(buttonOpenLink);
        panel.add(field);
        panel.add(buttonOK);
        frame.getContentPane().add(panel);
        frame.setVisible(true);
    }

    private boolean setPIN(TwitterSetting setting, String pin) {
        if (pin == null || pin.isEmpty()) {
            NGTLog.debug("[Twitter] Invalid PIN.");
            return false;
        }
        this.waitingAuth = false;
        NGTLog.debug("[Twitter] Set PIN : " + pin);
        try {
            RequestToken requestToken = this.geRequestToken(setting);
            AccessToken accessToken = this.twitter.getOAuthAccessToken(requestToken, pin);
            setting.accessToken = accessToken.getToken();
            setting.accessTokenSecret = accessToken.getTokenSecret();
            setting.save(this.settingFile);
            this.setOAuthKey(setting);
        }
        catch (TwitterException e) {
            e.printStackTrace();
        }
        return true;
    }

    public List<Status> getTweetWithKeyword(String keyword, int count) {
        if (keyword.startsWith("@")) {
            return this.getTweetWithId(keyword, count);
        }
        Query query = new Query();
        query.setQuery(keyword);
        query.setCount(count);
        try {
            QueryResult result = this.twitter.search(query);
            return result.getTweets();
        }
        catch (TwitterException e) {
            e.printStackTrace();
            return new ArrayList<Status>();
        }
    }

    public List<Status> getTweetWithId(String keyword, int count) {
        try {
            User user = this.twitter.showUser(keyword);
            return this.twitter.getUserTimeline(user.getId());
        }
        catch (TwitterException e) {
            e.printStackTrace();
            return new ArrayList<Status>();
        }
    }

    public void outputTweetWithTag(String tag, int count, ICommandSender sender) {
        List<Status> list = this.getTweetWithKeyword("#" + tag, count);
        NGTLog.sendChatMessage(sender, "Find tweet : " + list.size(), new Object[0]);
        for (Status tweet : list) {
            String str = tweet.getText().replaceAll("\n", "");
            String user = tweet.getUser().getName();
            NGTLog.sendChatMessage(sender, "[" + user + "]" + str, new Object[0]);
        }
    }
}

