/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.item.craft;

import jp.ngt.ngtlib.item.ItemUtil;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedRecipes55
implements IRecipe {
    public final int recipeWidth;
    public final int recipeHeight;
    public final ItemStack[] recipeItems;
    private ItemStack recipeOutput;
    private boolean hasNBT;
    private ResourceLocation name;

    public ShapedRecipes55(int w, int h, ItemStack[] stacks, ItemStack output) {
        this.recipeWidth = w;
        this.recipeHeight = h;
        this.recipeItems = stacks;
        this.recipeOutput = output;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public boolean func_77569_a(InventoryCrafting inventory, World world) {
        for (int i = 0; i <= 5 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 5 - this.recipeHeight; ++j) {
                if (this.checkMatch(inventory, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inventory, int width, int height, boolean par4) {
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                ItemStack itemstack1;
                int i1 = k - width;
                int j1 = l - height;
                ItemStack itemstack = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    itemstack = par4 ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((itemstack1 = inventory.func_70463_b(k, l)) == null && itemstack == null || this.itemMatches(itemstack, itemstack1)) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting par1) {
        ItemStack itemstack = this.func_77571_b().func_77946_l();
        if (this.hasNBT) {
            for (int i = 0; i < par1.func_70302_i_(); ++i) {
                ItemStack itemstack1 = par1.func_70301_a(i);
                if (itemstack1 == null || !itemstack1.func_77942_o()) continue;
                itemstack.func_77982_d(itemstack1.func_77978_p().func_74737_b());
            }
        }
        return itemstack;
    }

    public ItemStack[] getRecipeItems() {
        ItemStack[] items = new ItemStack[25];
        for (int i = 0; i < 5 && i < this.recipeHeight; ++i) {
            for (int j = 0; j < 5 && j < this.recipeWidth; ++j) {
                items[i * 5 + j] = this.recipeItems[i * this.recipeWidth + j];
            }
        }
        return items;
    }

    private boolean itemMatches(ItemStack target, ItemStack inInventory) {
        if (inInventory == null && target != null || inInventory != null && target == null) {
            return false;
        }
        if (target.func_77973_b() == Items.field_151100_aR) {
            return ItemUtil.isItemEqual(target, inInventory);
        }
        int[] ids0 = OreDictionary.getOreIDs((ItemStack)target);
        int[] ids1 = OreDictionary.getOreIDs((ItemStack)inInventory);
        if (ids0.length > 0 && ids1.length > 0) {
            for (int i = 0; i < ids0.length; ++i) {
                for (int j = 0; j < ids1.length; ++j) {
                    if (ids0[i] != ids1[j]) continue;
                    return true;
                }
            }
        } else {
            return ItemUtil.isItemEqual(target, inInventory);
        }
        return false;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList list = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            list.add((Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return list;
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }
}

