/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.math;

import jp.ngt.ngtlib.math.ILine;
import jp.ngt.ngtlib.math.LinePosPool;
import jp.ngt.ngtlib.math.NGTMath;

public final class BezierCurve
implements ILine {
    public static final int QUANTIZE = 32;
    public final double[] sp;
    public final double[] cpS;
    public final double[] cpE;
    public final double[] ep;
    private float[] normalizedParameters;
    private final double length;
    private final int split;

    public BezierCurve(double p1, double p2, double p3, double p4, double p5, double p6, double p7, double p8) {
        this.sp = new double[]{p1, p2};
        this.cpS = new double[]{p3, p4};
        this.cpE = new double[]{p5, p6};
        this.ep = new double[]{p7, p8};
        this.length = this.calcLength();
        this.split = (int)(this.length * 32.0);
    }

    @Override
    public double[] getPoint(int par1, int par2) {
        return this.getPointFromParameter(this.getHomogenizedParameter(par1, par2));
    }

    private double[] getPointFromParameter(double par1) {
        double t = par1 < 0.0 ? 0.0 : (par1 > 1.0 ? 1.0 : par1);
        double tp = 1.0 - t;
        double d0 = t * t * t;
        double d1 = 3.0 * t * t * tp;
        double d2 = 3.0 * t * tp * tp;
        double d3 = tp * tp * tp;
        double x = d0 * this.ep[0] + d1 * this.cpE[0] + d2 * this.cpS[0] + d3 * this.sp[0];
        double y = d0 * this.ep[1] + d1 * this.cpE[1] + d2 * this.cpS[1] + d3 * this.sp[1];
        return LinePosPool.get(x, y);
    }

    @Override
    public int getNearlestPoint(int par1, double par2, double par3) {
        int i = 0;
        double pd = Double.MAX_VALUE;
        for (int j = 0; j < par1; ++j) {
            double dy;
            double[] point = this.getPoint(par1, j);
            double dx = par2 - point[1];
            double distance = dx * dx + (dy = par3 - point[0]) * dy;
            if (!(distance < pd)) continue;
            pd = distance;
            i = j;
        }
        return pd < Double.MAX_VALUE ? i : -1;
    }

    @Override
    public double getSlope(int par1, int par2) {
        return this.getSlopeFromParameter(this.getHomogenizedParameter(par1, par2));
    }

    private double getSlopeFromParameter(double par1) {
        double t = par1 < 0.0 ? 0.0 : (par1 > 1.0 ? 1.0 : par1);
        double tp = 1.0 - t;
        double d0 = t * t;
        double d1 = 2.0 * t * tp;
        double d2 = tp * tp;
        double dx = 3.0 * (d0 * (this.ep[0] - this.cpE[0]) + d1 * (this.cpE[0] - this.cpS[0]) + d2 * (this.cpS[0] - this.sp[0]));
        double dy = 3.0 * (d0 * (this.ep[1] - this.cpE[1]) + d1 * (this.cpE[1] - this.cpS[1]) + d2 * (this.cpS[1] - this.sp[1]));
        return Math.atan2(dy, dx);
    }

    private float getHomogenizedParameter(int n, int par2) {
        if (n < 4) {
            return 0.0f;
        }
        if (par2 <= 0) {
            return 0.0f;
        }
        if (par2 >= n) {
            return 1.0f;
        }
        if (this.normalizedParameters == null) {
            this.initNP();
        }
        int i0 = NGTMath.floor((float)par2 * (float)this.split / (float)n);
        return this.normalizedParameters[i0];
    }

    private void initNP() {
        int i;
        this.normalizedParameters = new float[this.split];
        float ni = 1.0f / (float)this.split;
        float[] dd = new float[this.split + 1];
        float tt = 0.0f;
        double[] p = this.sp;
        double[] q = new double[2];
        dd[0] = 0.0f;
        for (i = 1; i < this.split + 1; ++i) {
            q = this.getPointFromParameter(tt += ni);
            dd[i] = dd[i - 1] + (float)this.getDistance(p[0], q[0], p[1], q[1]);
            p = q;
        }
        i = 1;
        while (i < this.split + 1) {
            int n = i++;
            dd[n] = dd[n] / dd[this.split];
        }
        for (i = 0; i < this.split; ++i) {
            float t = (float)i / (float)this.split;
            int k = 0;
            for (k = 0; !(k >= this.split - 1 || dd[k] <= t && t <= dd[k + 1]); ++k) {
            }
            float x = (t - dd[k]) / (dd[k + 1] - dd[k]);
            this.normalizedParameters[i] = x = ((float)k * (1.0f - x) + (float)(1 + k) * x) * (1.0f / (float)this.split);
        }
    }

    @Override
    public double getLength() {
        return this.length;
    }

    private double calcLength() {
        double x0 = this.sp[0] - this.ep[0];
        double y0 = this.sp[1] - this.ep[1];
        double l0 = Math.sqrt(x0 * x0 + y0 * y0);
        int n = NGTMath.floor(l0 * 2.0);
        float ni = 1.0f / (float)n;
        float tt = 0.0f;
        double[] p = this.sp;
        double[] q = new double[2];
        double[] dd = new double[n + 1];
        dd[0] = 0.0;
        for (int i = 1; i < n + 1; ++i) {
            q = this.getPointFromParameter(tt += ni);
            dd[i] = dd[i - 1] + this.getDistance(p[0], q[0], p[1], q[1]);
            p = q;
        }
        return dd[n];
    }

    private double getDistance(double par1, double par2, double par3, double par4) {
        double xDis = Math.abs(par1 - par2);
        double yDis = Math.abs(par3 - par4);
        return Math.sqrt(xDis * xDis + yDis * yDis);
    }
}

