/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.math;

import java.util.Random;
import net.minecraft.util.math.MathHelper;

public final class NGTMath {
    public static final Random RANDOM = new Random();
    public static final float PI;
    private static final double TO_RAD;
    private static final double TO_DEG;
    private static final double[] RAND_TABLE;
    private static int RAND_COUNT;

    public static float toDegrees(float par1) {
        return par1 * (float)TO_DEG;
    }

    public static float toRadians(float par1) {
        return par1 * (float)TO_RAD;
    }

    public static double toDegrees(double par1) {
        return par1 * TO_DEG;
    }

    public static double toRadians(double par1) {
        return par1 * TO_RAD;
    }

    public static double normalizeAngle(double par1) {
        double d0;
        for (d0 = par1; d0 >= 360.0; d0 -= 360.0) {
        }
        while (d0 < 0.0) {
            d0 += 360.0;
        }
        return d0;
    }

    public static double getGaussian(Random random, double sd) {
        double z = Math.sqrt(-2.0 * StrictMath.log(random.nextDouble())) * Math.sin(Math.PI * 2 * random.nextDouble());
        return sd * z;
    }

    public static int getRandomInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        RAND_COUNT = (RAND_COUNT + 1) % RAND_TABLE.length;
        return (int)((float)RAND_TABLE[RAND_COUNT] * (float)n);
    }

    public static int getIntFromString(String par1, int par2, int par3, int par4) {
        if (par1 == null) {
            return par4;
        }
        try {
            int num = Integer.valueOf(par1);
            if (num < par2) {
                return par2;
            }
            if (num > par3) {
                return par3;
            }
            return num;
        }
        catch (NumberFormatException e) {
            return par4;
        }
    }

    public static float getFloatFromString(String par1, float par2, float par3, float par4) {
        if (par1 == null) {
            return par4;
        }
        try {
            float num = Float.valueOf(par1).floatValue();
            if (num < par2) {
                return par2;
            }
            if (num > par3) {
                return par3;
            }
            return num;
        }
        catch (NumberFormatException e) {
            return par4;
        }
    }

    public static double pow(double par1, int par2) {
        if (par2 <= 0) {
            return 1.0;
        }
        double d0 = 1.0;
        for (int i = 0; i < par2; ++i) {
            d0 *= par1;
        }
        return d0;
    }

    public static double getAngle(double sX, double sY, double eX, double eY) {
        double dX = eX - sX;
        double dY = eY - sY;
        return Math.atan(dY / dX);
    }

    public static float getAngleD(double sX, double sY, double eX, double eY) {
        return (float)NGTMath.toDegrees(NGTMath.getAngle(sX, sY, eX, eY));
    }

    public static boolean compare(double p1, double p2, int p3) {
        long i1;
        long i0 = Math.round(p1 *= NGTMath.pow(10.0, p3));
        return i0 == (i1 = Math.round(p2 *= NGTMath.pow(10.0, p3)));
    }

    public static float getSin(float par1) {
        return MathHelper.func_76126_a((float)par1);
    }

    public static float getSinD(float par1) {
        return MathHelper.func_76126_a((float)NGTMath.toRadians(par1));
    }

    public static float getCos(float par1) {
        return MathHelper.func_76134_b((float)par1);
    }

    public static float getCosD(float par1) {
        return MathHelper.func_76134_b((float)NGTMath.toRadians(par1));
    }

    public static float getAtan2(double y, double x) {
        return (float)MathHelper.func_181159_b((double)y, (double)x);
    }

    public static float getAtan2D(double y, double x) {
        return NGTMath.toDegrees(NGTMath.getAtan2(y, x));
    }

    public static float sin(float par1) {
        return MathHelper.func_76126_a((float)NGTMath.toRadians(par1));
    }

    public static float cos(float par1) {
        return MathHelper.func_76134_b((float)NGTMath.toRadians(par1));
    }

    public static Random getRandom() {
        return RANDOM;
    }

    public static float wrapAngle(float par1) {
        return MathHelper.func_76142_g((float)par1);
    }

    public static int floor(float par1) {
        return MathHelper.func_76141_d((float)par1);
    }

    public static int floor(double par1) {
        return MathHelper.func_76128_c((double)par1);
    }

    public static double firstSqrt(double value) {
        return NGTMath.sqrtX(value, value, 4);
    }

    private static double sqrtX(double value, double x0, int n) {
        if (n > 0) {
            value = (value + x0 / value) * 0.5;
            return NGTMath.sqrtX(value, x0, --n);
        }
        return value;
    }

    public static double getDistanceSq(double sX, double sY, double eX, double eY) {
        double dx = eX - sX;
        double dy = eY - sY;
        return dx * dx + dy * dy;
    }

    public static double sigmoid(double x, double c) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        double f0 = (x - 0.5) * c;
        double f1 = f0 / Math.sqrt(1.0 + f0 * f0);
        return (f1 + 1.0) * 0.5;
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    static {
        RAND_TABLE = new double[65536];
        RAND_COUNT = 0;
        PI = (float)Math.PI;
        TO_RAD = Math.PI / 180;
        TO_DEG = 57.29577951308232;
        for (int i = 0; i < RAND_TABLE.length; ++i) {
            NGTMath.RAND_TABLE[i] = RANDOM.nextDouble();
        }
    }
}

