/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.math;

import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.util.ObjectPool;
import net.minecraft.util.math.MathHelper;

public final class PooledVec3
extends Vec3 {
    private static ObjectPool<PooledVec3> POOL;

    private PooledVec3(double x, double y, double z) {
        super(x, y, z);
    }

    public static Vec3 create(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    @Override
    public Vec3 rotateAroundX(float par1) {
        float rad = NGTMath.toRadians(par1);
        float f1 = MathHelper.func_76134_b((float)rad);
        float f2 = MathHelper.func_76126_a((float)rad);
        double d0 = this.getX();
        double d1 = this.getY() * (double)f1 + this.getZ() * (double)f2;
        double d2 = this.getZ() * (double)f1 - this.getY() * (double)f2;
        return PooledVec3.create(d0, d1, d2);
    }

    @Override
    public Vec3 rotateAroundY(float par1) {
        float rad = NGTMath.toRadians(par1);
        float f1 = MathHelper.func_76134_b((float)rad);
        float f2 = MathHelper.func_76126_a((float)rad);
        double d0 = this.getX() * (double)f1 + this.getZ() * (double)f2;
        double d1 = this.getY();
        double d2 = this.getZ() * (double)f1 - this.getX() * (double)f2;
        return PooledVec3.create(d0, d1, d2);
    }

    @Override
    public Vec3 rotateAroundZ(float par1) {
        float rad = NGTMath.toRadians(par1);
        float f1 = MathHelper.func_76134_b((float)rad);
        float f2 = MathHelper.func_76126_a((float)rad);
        double d0 = this.getX() * (double)f1 + this.getY() * (double)f2;
        double d1 = this.getY() * (double)f1 - this.getX() * (double)f2;
        double d2 = this.getZ();
        return PooledVec3.create(d0, d1, d2);
    }

    @Override
    public Vec3 add(double x, double y, double z) {
        return PooledVec3.create(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    @Override
    public Vec3 multi(double num) {
        return PooledVec3.create(this.getX() * num, this.getY() * num, this.getZ() * num);
    }

    @Override
    public Vec3 crossProduct(Vec3 par1) {
        return PooledVec3.create(this.getY() * par1.getZ() - this.getZ() * par1.getY(), this.getZ() * par1.getX() - this.getX() * par1.getZ(), this.getX() * par1.getY() - this.getY() * par1.getX());
    }

    @Override
    public Vec3 normalize() {
        double d1 = 1.0 / this.length();
        return PooledVec3.create(this.getX() * d1, this.getY() * d1, this.getZ() * d1);
    }

    static {
        int size = 32;
        PooledVec3[] array1 = new PooledVec3[32];
        PooledVec3[] array2 = new PooledVec3[32];
        for (int i = 0; i < 32; ++i) {
            array1[i] = new PooledVec3(0.0, 0.0, 0.0);
            array2[i] = new PooledVec3(0.0, 0.0, 0.0);
        }
        POOL = new ObjectPool<PooledVec3>(new PooledVec3[][]{array1, array2});
    }
}

