/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.network;

import io.netty.buffer.ByteBuf;
import jp.ngt.ngtlib.NGTCore;
import jp.ngt.ngtlib.network.PacketCustom;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketNBT
extends PacketCustom {
    private static final byte Type_Entity = 0;
    private static final byte Type_TileEntity = 1;
    private static final byte Type_PlayerItem = 2;
    public NBTTagCompound nbtData;

    public PacketNBT() {
    }

    private PacketNBT(Entity entity, boolean toClient) {
        super(entity);
        NBTTagCompound nbt = new NBTTagCompound();
        entity.func_189511_e(nbt);
        this.initPacket(entity, nbt, toClient);
    }

    private PacketNBT(TileEntity tileEntity, NBTTagCompound nbt, boolean toClient) {
        super(tileEntity);
        this.initPacket(tileEntity, nbt, toClient);
    }

    private PacketNBT(TileEntity tileEntity, boolean toClient) {
        super(tileEntity);
        NBTTagCompound nbt = new NBTTagCompound();
        tileEntity.func_189515_b(nbt);
        this.initPacket(tileEntity, nbt, toClient);
    }

    private PacketNBT(EntityPlayer player, ItemStack stack) {
        super((Entity)player);
        this.nbtData = new NBTTagCompound();
        this.nbtData.func_74782_a("TagData", (NBTBase)stack.func_77978_p());
        this.nbtData.func_74757_a("ToClient", false);
        this.nbtData.func_74774_a("DataType", (byte)2);
    }

    private void initPacket(Entity entity, NBTTagCompound nbt, boolean toClient) {
        this.nbtData = nbt;
        this.nbtData.func_74757_a("ToClient", toClient);
        this.nbtData.func_74774_a("DataType", (byte)0);
    }

    private void initPacket(TileEntity tileEntity, NBTTagCompound nbt, boolean toClient) {
        this.nbtData = nbt;
        this.nbtData.func_74757_a("ToClient", toClient);
        this.nbtData.func_74774_a("DataType", (byte)1);
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.nbtData);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.nbtData = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    protected boolean onGetPacket(World world) {
        ItemStack stack;
        Entity entity;
        if (world == null) {
            return false;
        }
        byte type = this.nbtData.func_74771_c("DataType");
        if (type == 0) {
            Entity entity2 = this.getEntity(world);
            if (entity2 != null) {
                entity2.func_70020_e(this.nbtData);
                return true;
            }
        } else if (type == 1) {
            TileEntity tileEntity = this.getTileEntity(world);
            if (tileEntity != null) {
                tileEntity.func_145839_a(this.nbtData);
                if (!world.field_72995_K) {
                    tileEntity.func_70296_d();
                }
                return true;
            }
        } else if (type == 2 && (entity = this.getEntity(world)) instanceof EntityPlayer && (stack = ((EntityPlayer)entity).field_71071_by.func_70448_g()) != null) {
            int index = ((EntityPlayer)entity).field_71071_by.field_70461_c;
            NBTTagCompound data = this.nbtData.func_74775_l("TagData");
            stack.func_77982_d(data);
            if (entity instanceof EntityPlayerMP) {
                this.updateCurrentItem((EntityPlayerMP)entity);
            }
            return true;
        }
        return false;
    }

    private void updateCurrentItem(EntityPlayerMP player) {
        Slot slot = player.field_71069_bz.func_75147_a((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c);
        player.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(player.field_71069_bz.field_75152_c, slot.field_75222_d, player.field_71071_by.func_70448_g()));
    }

    public static void sendToServer(Entity entity) {
        NGTCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketNBT(entity, false));
    }

    public static void sendToServer(EntityPlayer player, ItemStack item) {
        NGTCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketNBT(player, item));
    }

    public static void sendToServer(TileEntity entity) {
        NGTCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketNBT(entity, false));
    }

    public static void sendToServer(TileEntity entity, NBTTagCompound nbt) {
        NGTCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketNBT(entity, nbt, false));
    }

    public static void sendToClient(Entity entity) {
        NGTCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketNBT(entity, true));
    }

    public static void sendToClient(TileEntity entity) {
        NGTCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketNBT(entity, true));
    }
}

