/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.ngtlib.world.IBlockAccessNGT;
import jp.ngt.ngtlib.world.NGTWorld;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class NGTObjectRenderer {
    public static final NGTObjectRenderer INSTANCE = new NGTObjectRenderer();

    private NGTObjectRenderer() {
    }

    public void renderNGTObject(IBlockAccessNGT par1, NGTObject par2, boolean changeLightting, int mode, int pass) {
        boolean isSculpture;
        GL11.glPushMatrix();
        if (changeLightting) {
            GLHelper.disableLighting();
        }
        GL11.glEnable((int)3008);
        boolean bl = isSculpture = mode == 1 && par2.xSize == par2.ySize && par2.xSize == par2.zSize;
        if (isSculpture) {
            float f0 = par2.xSize;
            GL11.glScalef((float)f0, (float)f0, (float)f0);
        }
        if (pass == 1) {
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        }
        NGTTessellator tessellator = NGTTessellator.instance;
        BufferBuilder renderer = null;
        if (isSculpture) {
            tessellator.startDrawingQuads();
        } else {
            int bufSize = par2.blockList.size() * 0x280000 >> 12;
            if (bufSize <= 0) {
                bufSize = 4096;
            }
            renderer = new BufferBuilder(bufSize);
            renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        }
        for (int i = 0; i < par2.xSize; ++i) {
            for (int j = 0; j < par2.ySize; ++j) {
                for (int k = 0; k < par2.zSize; ++k) {
                    BlockSet set = par1.getBlockSet(i, j, k);
                    BlockRenderLayer layer = set.block.func_180664_k();
                    boolean renderFlag = false;
                    if (pass == 0) {
                        renderFlag = layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT_MIPPED || layer == BlockRenderLayer.CUTOUT;
                    } else if (pass == 1) {
                        boolean bl2 = renderFlag = layer == BlockRenderLayer.TRANSLUCENT;
                    }
                    if (set.toBlockState().func_185904_a() == Material.field_151579_a || !renderFlag) continue;
                    if (isSculpture) {
                        this.renderBlockAsSculpture(par1, set, par2, i, j, k);
                        continue;
                    }
                    this.renderBlockByRenderer(par1, renderer, set, i, j, k);
                }
            }
        }
        if (isSculpture) {
            tessellator.draw();
        } else {
            renderer.func_178977_d();
            WorldVertexBufferUploader vboUploader = new WorldVertexBufferUploader();
            vboUploader.func_181679_a(renderer);
        }
        if (pass == 1) {
            GL11.glDisable((int)3042);
        }
        if (changeLightting) {
            GLHelper.enableLighting();
        }
        GL11.glPopMatrix();
    }

    private void renderBlockByRenderer(IBlockAccess accessor, BufferBuilder renderer, BlockSet blockSet, int x, int y, int z) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBlockState state = blockSet.block.func_176203_a((int)blockSet.metadata);
        dispatcher.func_175018_a(state, new BlockPos(x, y, z), accessor, renderer);
    }

    private void renderBlockAsSculpture(IBlockAccess accessor, BlockSet set, NGTObject ngto, int x, int y, int z) {
        float maxV;
        float minV;
        float vDif;
        float maxU;
        float minU;
        float uDif;
        TextureAtlasSprite icon;
        GL11.glPushMatrix();
        IBlockState state = set.toBlockState();
        Block block = set.block;
        byte meta = set.metadata;
        float f0 = ngto.xSize;
        float scale = 1.0f / f0;
        float minX = (float)x / f0;
        float minY = (float)y / f0;
        float minZ = (float)z / f0;
        float maxX = minX + scale;
        float maxY = minY + scale;
        float maxZ = minZ + scale;
        NGTTessellator tessellator = NGTTessellator.instance;
        if (state.func_185894_c(accessor, new BlockPos(x, y - 1, z), EnumFacing.DOWN)) {
            icon = this.getIcon(block, meta, 0);
            uDif = icon.func_94212_f() - icon.func_94209_e();
            minU = icon.func_94209_e() + maxX * uDif;
            maxU = icon.func_94209_e() + minX * uDif;
            vDif = icon.func_94210_h() - icon.func_94206_g();
            minV = icon.func_94206_g() + minZ * vDif;
            maxV = icon.func_94206_g() + maxZ * vDif;
            tessellator.setColorOpaque_F(0.5f, 0.5f, 0.5f);
            tessellator.addVertexWithUV(minX, minY, minZ, minU, maxV);
            tessellator.addVertexWithUV(maxX, minY, minZ, maxU, maxV);
            tessellator.addVertexWithUV(maxX, minY, maxZ, maxU, minV);
            tessellator.addVertexWithUV(minX, minY, maxZ, minU, minV);
        }
        if (state.func_185894_c(accessor, new BlockPos(x, y + 1, z), EnumFacing.UP)) {
            icon = this.getIcon(block, meta, 1);
            uDif = icon.func_94212_f() - icon.func_94209_e();
            minU = icon.func_94209_e() + maxX * uDif;
            maxU = icon.func_94209_e() + minX * uDif;
            vDif = icon.func_94210_h() - icon.func_94206_g();
            minV = icon.func_94206_g() + maxZ * vDif;
            maxV = icon.func_94206_g() + minZ * vDif;
            tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
            tessellator.addVertexWithUV(minX, maxY, maxZ, maxU, minV);
            tessellator.addVertexWithUV(maxX, maxY, maxZ, minU, minV);
            tessellator.addVertexWithUV(maxX, maxY, minZ, minU, maxV);
            tessellator.addVertexWithUV(minX, maxY, minZ, maxU, maxV);
        }
        if (state.func_185894_c(accessor, new BlockPos(x, y, z - 1), EnumFacing.NORTH)) {
            icon = this.getIcon(block, meta, 2);
            uDif = icon.func_94212_f() - icon.func_94209_e();
            minU = icon.func_94212_f() - maxX * uDif;
            maxU = icon.func_94212_f() - minX * uDif;
            vDif = icon.func_94210_h() - icon.func_94206_g();
            minV = icon.func_94210_h() - maxY * vDif;
            maxV = icon.func_94210_h() - minY * vDif;
            tessellator.setColorOpaque_F(0.8f, 0.8f, 0.8f);
            tessellator.addVertexWithUV(maxX, maxY, minZ, minU, minV);
            tessellator.addVertexWithUV(maxX, minY, minZ, minU, maxV);
            tessellator.addVertexWithUV(minX, minY, minZ, maxU, maxV);
            tessellator.addVertexWithUV(minX, maxY, minZ, maxU, minV);
        }
        if (state.func_185894_c(accessor, new BlockPos(x, y, z + 1), EnumFacing.SOUTH)) {
            icon = this.getIcon(block, meta, 3);
            uDif = icon.func_94212_f() - icon.func_94209_e();
            minU = icon.func_94209_e() + minX * uDif;
            maxU = icon.func_94209_e() + maxX * uDif;
            vDif = icon.func_94210_h() - icon.func_94206_g();
            minV = icon.func_94210_h() - maxY * vDif;
            maxV = icon.func_94210_h() - minY * vDif;
            tessellator.setColorOpaque_F(0.8f, 0.8f, 0.8f);
            tessellator.addVertexWithUV(minX, maxY, maxZ, minU, minV);
            tessellator.addVertexWithUV(minX, minY, maxZ, minU, maxV);
            tessellator.addVertexWithUV(maxX, minY, maxZ, maxU, maxV);
            tessellator.addVertexWithUV(maxX, maxY, maxZ, maxU, minV);
        }
        if (state.func_185894_c(accessor, new BlockPos(x - 1, y, z), EnumFacing.WEST)) {
            icon = this.getIcon(block, meta, 4);
            uDif = icon.func_94212_f() - icon.func_94209_e();
            minU = icon.func_94209_e() + minZ * uDif;
            maxU = icon.func_94209_e() + maxZ * uDif;
            vDif = icon.func_94210_h() - icon.func_94206_g();
            minV = icon.func_94210_h() - maxY * vDif;
            maxV = icon.func_94210_h() - minY * vDif;
            tessellator.setColorOpaque_F(0.6f, 0.6f, 0.6f);
            tessellator.addVertexWithUV(minX, maxY, minZ, minU, minV);
            tessellator.addVertexWithUV(minX, minY, minZ, minU, maxV);
            tessellator.addVertexWithUV(minX, minY, maxZ, maxU, maxV);
            tessellator.addVertexWithUV(minX, maxY, maxZ, maxU, minV);
        }
        if (state.func_185894_c(accessor, new BlockPos(x + 1, y, z), EnumFacing.EAST)) {
            icon = this.getIcon(block, meta, 5);
            uDif = icon.func_94212_f() - icon.func_94209_e();
            minU = icon.func_94212_f() - maxZ * uDif;
            maxU = icon.func_94212_f() - minZ * uDif;
            vDif = icon.func_94210_h() - icon.func_94206_g();
            minV = icon.func_94210_h() - maxY * vDif;
            maxV = icon.func_94210_h() - minY * vDif;
            tessellator.setColorOpaque_F(0.6f, 0.6f, 0.6f);
            tessellator.addVertexWithUV(maxX, maxY, maxZ, minU, minV);
            tessellator.addVertexWithUV(maxX, minY, maxZ, minU, maxV);
            tessellator.addVertexWithUV(maxX, minY, minZ, maxU, maxV);
            tessellator.addVertexWithUV(maxX, maxY, minZ, maxU, minV);
        }
        GL11.glPopMatrix();
    }

    private TextureAtlasSprite getIcon(Block block, int meta, int side) {
        IBlockState state = block.func_176203_a(meta);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        List list = model.func_188616_a(state, EnumFacing.func_82600_a((int)side), 0L);
        return list.isEmpty() ? model.func_177554_e() : ((BakedQuad)list.get(0)).func_187508_a();
    }

    public void renderTileEntities(NGTWorld par1, float par8, int pass) {
        if (!par1.tileEntityLoaded) {
            this.loadTileEntity(par1);
            par1.tileEntityLoaded = true;
        }
        for (TileEntity tile : par1.getTileEntityList()) {
            BlockPos pos = tile.func_174877_v();
            this.renderTileEntityByRenderer(tile, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), par8, pass);
        }
    }

    private void loadTileEntity(NGTWorld par1) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        for (int i = 0; i < par1.blockObject.xSize; ++i) {
            for (int j = 0; j < par1.blockObject.ySize; ++j) {
                for (int k = 0; k < par1.blockObject.zSize; ++k) {
                    TileEntity tile = par1.func_175625_s(new BlockPos(i, j, k));
                    if (tile == null || TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile) == null) continue;
                    list.add(tile);
                }
            }
        }
        par1.setTileEntityList(list);
    }

    public void renderTileEntityByRenderer(TileEntity tile, double par2, double par4, double par6, float par8, int pass) {
        TileEntitySpecialRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile);
        if (tile.shouldRenderInPass(pass) && renderer != null) {
            try {
                renderer.func_192841_a(tile, par2, par4, par6, par8, 0, 1.0f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CrashReport report = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering TileEntity in Miniature");
                CrashReportCategory category = report.func_85058_a("TileEntity Details");
                tile.func_145828_a(category);
                throw new ReportedException(report);
            }
        }
    }

    public void renderEntities(NGTWorld par1, float par8, int pass) {
        List<Entity> list = par1.getEntityList();
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (entity.field_70128_L) continue;
            this.renderEntityByRenderer(entity, par8, pass);
        }
    }

    public void renderEntityByRenderer(Entity entity, float par8, int pass) {
        if (!entity.shouldRenderInPass(pass)) {
            return;
        }
        double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)par8;
        double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)par8;
        double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)par8;
        float f1 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * par8;
        int i = entity.func_70027_ad() ? 0xF000F0 : entity.func_70070_b();
        GLHelper.setBrightness(i);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        try {
            NGTUtilClient.getMinecraft().func_175598_ae().func_188391_a(entity, d0, d1, d2, f1, par8, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

