/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer;

import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.ModelSolid;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.renderer.media.ElectricBulletinBoard;
import jp.ngt.ngtlib.renderer.media.ImageBase;
import jp.ngt.ngtlib.renderer.media.MediaBase;
import jp.ngt.ngtlib.renderer.model.ModelLoader;
import jp.ngt.ngtlib.renderer.model.PolygonModel;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class NGTRenderer {
    private static final PolygonModel FIRE = ModelLoader.loadModel(new ResourceLocation("ngtlib", "models/fire.mqo"), VecAccuracy.MEDIUM, new Object[0]);
    private static final float FIRE_LEN_DIV = 0.24169186f;
    private static boolean HAS_CAMERA_LIB = true;
    private static boolean HAS_TWITTER_LIB = true;

    public static void renderPole(NGTTessellator tessellator, float r, float length, boolean useTexture) {
        float[][] sp = ModelSolid.SPHERE;
        int l0 = (int)((double)length * 16.0);
        for (int l = 0; l < l0; ++l) {
            for (int i1 = 0; i1 < 16; ++i1) {
                float minU = (float)i1 * 0.0625f;
                float maxU = (float)(i1 + 1) * 0.0625f;
                float minV = (float)l * 0.0625f;
                float maxV = (float)(l + 1) * 0.0625f;
                float l1 = (float)l * 0.0625f;
                int ii0 = 64 + i1;
                int ii1 = 64 + i1;
                int ii2 = 64 + (i1 + 1) % 16;
                int ii3 = 64 + (i1 + 1) % 16;
                NGTRenderer.addVertex(tessellator, useTexture, sp[ii0][0] * r, sp[ii0][1] * r + l1, sp[ii0][2] * r, maxU, maxV);
                NGTRenderer.addVertex(tessellator, useTexture, sp[ii1][0] * r, sp[ii1][1] * r + 0.0625f + l1, sp[ii1][2] * r, maxU, minV);
                NGTRenderer.addVertex(tessellator, useTexture, sp[ii2][0] * r, sp[ii2][1] * r + 0.0625f + l1, sp[ii2][2] * r, minU, minV);
                NGTRenderer.addVertex(tessellator, useTexture, sp[ii3][0] * r, sp[ii3][1] * r + l1, sp[ii3][2] * r, minU, maxV);
                NGTRenderer.addVertex(tessellator, useTexture, sp[ii3][0] * r, sp[ii3][1] * r + l1, sp[ii3][2] * r, maxU, maxV);
                NGTRenderer.addVertex(tessellator, useTexture, sp[ii2][0] * r, sp[ii2][1] * r + 0.0625f + l1, sp[ii2][2] * r, maxU, minV);
                NGTRenderer.addVertex(tessellator, useTexture, sp[ii1][0] * r, sp[ii1][1] * r + 0.0625f + l1, sp[ii1][2] * r, minU, minV);
                NGTRenderer.addVertex(tessellator, useTexture, sp[ii0][0] * r, sp[ii0][1] * r + l1, sp[ii0][2] * r, minU, maxV);
            }
        }
    }

    private static void addVertex(NGTTessellator tessellator, boolean b, float x, float y, float z, float u, float v) {
        if (b) {
            tessellator.addVertexWithUV(x, y, z, u, v);
        } else {
            tessellator.addVertex(x, y, z);
        }
    }

    public static void renderSphere(NGTTessellator tessellator, float r) {
        float[][] sp = ModelSolid.SPHERE;
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        for (int i0 = 0; i0 < 8; ++i0) {
            for (int i1 = 0; i1 < 16; ++i1) {
                minU = (float)i1 * 0.0625f;
                maxU = (float)(i1 + 1) * 0.0625f;
                minV = (float)i0 * 0.125f;
                maxV = (float)(i0 + 1) * 0.125f;
                int ii0 = i0 * 16 + i1;
                int ii1 = (i0 + 1) * 16 + i1;
                int ii2 = (i0 + 1) * 16 + (i1 + 1) % 16;
                int ii3 = i0 * 16 + (i1 + 1) % 16;
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                tessellator.addVertexWithUV(sp[ii0][0] * r, sp[ii0][1] * r, sp[ii0][2] * r, maxU, maxV);
                tessellator.addVertexWithUV(sp[ii1][0] * r, sp[ii1][1] * r, sp[ii1][2] * r, maxU, minV);
                tessellator.addVertexWithUV(sp[ii2][0] * r, sp[ii2][1] * r, sp[ii2][2] * r, minU, minV);
                tessellator.addVertexWithUV(sp[ii3][0] * r, sp[ii3][1] * r, sp[ii3][2] * r, minU, maxV);
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                tessellator.addVertexWithUV(sp[ii3][0] * r, sp[ii3][1] * r, sp[ii3][2] * r, maxU, maxV);
                tessellator.addVertexWithUV(sp[ii2][0] * r, sp[ii2][1] * r, sp[ii2][2] * r, maxU, minV);
                tessellator.addVertexWithUV(sp[ii1][0] * r, sp[ii1][1] * r, sp[ii1][2] * r, minU, minV);
                tessellator.addVertexWithUV(sp[ii0][0] * r, sp[ii0][1] * r, sp[ii0][2] * r, minU, maxV);
            }
        }
    }

    public static void renderFrame(float minX, float minY, float minZ, float width, float height, float depth, int color, int alpha) {
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawing(1);
        tessellator.setColorRGBA_I(color, alpha);
        NGTRenderer.addFrame(tessellator, minX, minY, minZ, width, height, depth);
        tessellator.draw();
    }

    public static void addFrame(NGTTessellator tessellator, float minX, float minY, float minZ, float width, float height, float depth) {
        float maxX = minX + width;
        float maxY = minY + height;
        float maxZ = minZ + depth;
        tessellator.addVertex(minX, minY, minZ);
        tessellator.addVertex(maxX, minY, minZ);
        tessellator.addVertex(minX, minY, maxZ);
        tessellator.addVertex(maxX, minY, maxZ);
        tessellator.addVertex(minX, minY, minZ);
        tessellator.addVertex(minX, minY, maxZ);
        tessellator.addVertex(maxX, minY, minZ);
        tessellator.addVertex(maxX, minY, maxZ);
        tessellator.addVertex(minX, minY, minZ);
        tessellator.addVertex(minX, maxY, minZ);
        tessellator.addVertex(maxX, minY, minZ);
        tessellator.addVertex(maxX, maxY, minZ);
        tessellator.addVertex(minX, minY, maxZ);
        tessellator.addVertex(minX, maxY, maxZ);
        tessellator.addVertex(maxX, minY, maxZ);
        tessellator.addVertex(maxX, maxY, maxZ);
        tessellator.addVertex(minX, maxY, minZ);
        tessellator.addVertex(maxX, maxY, minZ);
        tessellator.addVertex(minX, maxY, maxZ);
        tessellator.addVertex(maxX, maxY, maxZ);
        tessellator.addVertex(minX, maxY, minZ);
        tessellator.addVertex(minX, maxY, maxZ);
        tessellator.addVertex(maxX, maxY, minZ);
        tessellator.addVertex(maxX, maxY, maxZ);
    }

    public static void renderFire(float scaleXY, float scaleZ, int color, int rep) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GLHelper.disableLighting();
        GLHelper.setLightmapMaxBrightness();
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3553);
        scaleZ *= 0.24169186f;
        float alpha = 0.125f;
        float colorR = (float)(color >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(color >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(color & 0xFF) / 255.0f;
        NGTTessellator tessellator = NGTTessellator.instance;
        for (int i = 0; i < rep; ++i) {
            GL11.glPushMatrix();
            float f0 = (float)i / (float)rep;
            float scres = 1.0f - f0;
            GL11.glScalef((float)(scres * scaleXY), (float)(scres * scaleXY), (float)(scres * scaleZ));
            tessellator.startDrawing(4);
            float r2 = (1.0f - colorR) * f0 + colorR;
            float g2 = (1.0f - colorG) * f0 + colorG;
            float b2 = (1.0f - colorB) * f0 + colorB;
            tessellator.setColorRGBA_F(r2, g2, b2, alpha);
            FIRE.tessellateAll(tessellator, false);
            tessellator.draw();
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLHelper.enableLighting();
        GL11.glPopMatrix();
    }

    public static void renderWebCamera(float width, float height, boolean fitAspectRatio, int cameraId) {
        if (HAS_CAMERA_LIB) {
            try {
                MediaBase media = MediaBase.getMedia(MediaBase.MediaType.CAMERA, String.valueOf(cameraId));
                if (media != null) {
                    media.render(width, height, fitAspectRatio);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                HAS_CAMERA_LIB = false;
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
                HAS_CAMERA_LIB = false;
                NGTRenderer.showLibInstallertion();
            }
        }
    }

    public static void renderDesktop(float width, float height, boolean fitAspectRatio) {
        MediaBase media = MediaBase.getMedia(MediaBase.MediaType.CAPTURE, "default");
        if (media != null) {
            media.render(width, height, fitAspectRatio);
        }
    }

    public static void renderPicture(float width, float height, boolean fitAspectRatio, String url) {
        NGTRenderer.renderPicture(width, height, fitAspectRatio, url, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void renderPicture(float width, float height, boolean fitAspectRatio, String url, float minU, float minV, float maxU, float maxV) {
        MediaBase media = MediaBase.getMedia(MediaBase.MediaType.PICTURE, url);
        if (media != null) {
            ((ImageBase)media).setUV(minU, minV, maxU, maxV);
            media.render(width, height, fitAspectRatio);
        }
    }

    public static void renderMap(float width, float height, boolean fitAspectRatio, String pos) {
        MediaBase media = MediaBase.getMedia(MediaBase.MediaType.MAP, pos);
        if (media != null) {
            media.render(width, height, fitAspectRatio);
        }
    }

    public static void renderTweet(float width, float height, boolean fitAspectRatio, String keyword) {
        if (HAS_TWITTER_LIB) {
            try {
                MediaBase media = MediaBase.getMedia(MediaBase.MediaType.TWEET, keyword);
                if (media != null) {
                    media.render(width, height, fitAspectRatio);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                HAS_TWITTER_LIB = false;
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
                HAS_TWITTER_LIB = false;
                NGTRenderer.showLibInstallertion();
            }
        }
    }

    public static void renderEBB(float width, float height, boolean fitAspectRatio, String name, int resolution, int offsetU, int offsetV) {
        MediaBase media = MediaBase.getMedia(MediaBase.MediaType.EBB, name);
        if (media != null) {
            ((ElectricBulletinBoard)media).setParameter(resolution, offsetU, offsetV);
            media.render(width, height, fitAspectRatio);
        }
    }

    private static void showLibInstallertion() {
        TextComponentTranslation component = new TextComponentTranslation(TextFormatting.RED + "Please install library. ->", new Object[0]);
        TextComponentTranslation component2 = new TextComponentTranslation("  \u00a76\u00a7nDownload here", new Object[0]);
        component2.func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://dl.dropboxusercontent.com/s/nqjqg4qur7jriwz/lib_installation.txt")));
        component.func_150257_a((ITextComponent)component2);
        NGTLog.showChatMessage((ITextComponent)component);
    }
}

