/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.PriorityQueue;
import jp.ngt.ngtlib.renderer.IRenderer;
import jp.ngt.ngtlib.renderer.QuadComparator;
import jp.ngt.ngtlib.renderer.TesselatorVertexState;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class NGTTessellator
implements IRenderer {
    public static final NGTTessellator instance = new NGTTessellator();
    private static final int NATIVE_BUFFER_SIZE = 0x600000;
    private static final ByteBuffer byteBuffer = GLAllocation.func_74524_c((int)0x1800000);
    private static final IntBuffer intBuffer = byteBuffer.asIntBuffer();
    private static final FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
    private static final ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
    private int[] rawBuffer;
    private int rawBufferIndex;
    private int rawBufferSize = 0;
    private int vertexCount;
    private float textureU;
    private float textureV;
    private int brightness;
    private int color;
    private int drawMode;
    private boolean hasColor;
    private boolean hasTexture;
    private boolean hasBrightness;
    private boolean hasNormals;
    private boolean isColorDisabled;
    private float xOffset;
    private float yOffset;
    private float zOffset;
    private int normal;
    private boolean isDrawing;

    private NGTTessellator() {
    }

    @Override
    public int draw() {
        if (!this.isDrawing) {
            throw new IllegalStateException("Not tesselating!");
        }
        this.isDrawing = false;
        int offs = 0;
        while (offs < this.vertexCount) {
            int vtc = Math.min(this.vertexCount - offs, 196608);
            intBuffer.clear();
            intBuffer.put(this.rawBuffer, offs << 3, vtc << 3);
            byteBuffer.position(0);
            byteBuffer.limit(vtc << 5);
            offs += vtc;
            if (this.hasTexture) {
                floatBuffer.position(3);
                GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)floatBuffer);
                GL11.glEnableClientState((int)32888);
            }
            if (this.hasBrightness) {
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                shortBuffer.position(14);
                GL11.glTexCoordPointer((int)2, (int)32, (ShortBuffer)shortBuffer);
                GL11.glEnableClientState((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            }
            if (this.hasColor) {
                byteBuffer.position(20);
                GL11.glColorPointer((int)4, (boolean)true, (int)32, (ByteBuffer)byteBuffer);
                GL11.glEnableClientState((int)32886);
            }
            if (this.hasNormals) {
                byteBuffer.position(24);
                GL11.glNormalPointer((int)32, (ByteBuffer)byteBuffer);
                GL11.glEnableClientState((int)32885);
            }
            floatBuffer.position(0);
            GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)floatBuffer);
            GL11.glEnableClientState((int)32884);
            GL11.glDrawArrays((int)this.drawMode, (int)0, (int)vtc);
            GL11.glDisableClientState((int)32884);
            if (this.hasTexture) {
                GL11.glDisableClientState((int)32888);
            }
            if (this.hasBrightness) {
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                GL11.glDisableClientState((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            }
            if (this.hasColor) {
                GL11.glDisableClientState((int)32886);
            }
            if (!this.hasNormals) continue;
            GL11.glDisableClientState((int)32885);
        }
        if (this.rawBufferSize > 131072 && this.rawBufferIndex < this.rawBufferSize << 3) {
            this.rawBufferSize = 65536;
            this.rawBuffer = new int[this.rawBufferSize];
        }
        int i = this.rawBufferIndex << 2;
        this.reset();
        return i;
    }

    public TesselatorVertexState getVertexState(float x, float y, float z) {
        int i;
        int[] aint = new int[this.rawBufferIndex];
        PriorityQueue<Integer> priorityqueue = new PriorityQueue<Integer>(this.rawBufferIndex, new QuadComparator(this.rawBuffer, x + this.xOffset, y + this.yOffset, z + this.zOffset));
        int b0 = 32;
        for (i = 0; i < this.rawBufferIndex; i += b0) {
            priorityqueue.add(i);
        }
        i = 0;
        while (!priorityqueue.isEmpty()) {
            int j = (Integer)priorityqueue.remove();
            for (int k = 0; k < b0; ++k) {
                aint[i + k] = this.rawBuffer[j + k];
            }
            i += b0;
        }
        System.arraycopy(aint, 0, this.rawBuffer, 0, aint.length);
        return new TesselatorVertexState(aint, this.rawBufferIndex, this.vertexCount, this.hasTexture, this.hasBrightness, this.hasNormals, this.hasColor);
    }

    public void setVertexState(TesselatorVertexState state) {
        while (state.getRawBuffer().length > this.rawBufferSize && this.rawBufferSize > 0) {
            this.rawBufferSize <<= 1;
        }
        if (this.rawBufferSize > this.rawBuffer.length) {
            this.rawBuffer = new int[this.rawBufferSize];
        }
        System.arraycopy(state.getRawBuffer(), 0, this.rawBuffer, 0, state.getRawBuffer().length);
        this.rawBufferIndex = state.getRawBufferIndex();
        this.vertexCount = state.getVertexCount();
        this.hasTexture = state.getHasTexture();
        this.hasBrightness = state.getHasBrightness();
        this.hasColor = state.getHasColor();
        this.hasNormals = state.getHasNormals();
    }

    private void reset() {
        this.vertexCount = 0;
        byteBuffer.clear();
        this.rawBufferIndex = 0;
    }

    public void startDrawingQuads() {
        this.startDrawing(7);
    }

    @Override
    public void startDrawing(int par1) {
        if (this.isDrawing) {
            throw new IllegalStateException("Already tesselating!");
        }
        this.isDrawing = true;
        this.reset();
        this.drawMode = par1;
        this.hasNormals = false;
        this.hasColor = false;
        this.hasTexture = false;
        this.hasBrightness = false;
        this.isColorDisabled = false;
    }

    public void setTextureUV(float par1, float par3) {
        this.hasTexture = true;
        this.textureU = par1;
        this.textureV = par3;
    }

    @Override
    public void setBrightness(int par1) {
        this.hasBrightness = true;
        this.brightness = par1;
    }

    public void setColorOpaque_F(float par1, float par2, float par3) {
        this.setColorOpaque((int)(par1 * 255.0f), (int)(par2 * 255.0f), (int)(par3 * 255.0f));
    }

    public void setColorRGBA_F(float par1, float par2, float par3, float par4) {
        this.setColor((int)(par1 * 255.0f), (int)(par2 * 255.0f), (int)(par3 * 255.0f), (int)(par4 * 255.0f));
    }

    public void setColorOpaque(int par1, int par2, int par3) {
        this.setColor(par1, par2, par3, 255);
    }

    @Override
    public void setColor(int r, int g, int b, int a) {
        if (!this.isColorDisabled) {
            if (r > 255) {
                r = 255;
            } else if (r < 0) {
                r = 0;
            }
            if (g > 255) {
                g = 255;
            } else if (g < 0) {
                g = 0;
            }
            if (b > 255) {
                b = 255;
            } else if (b < 0) {
                b = 0;
            }
            if (a > 255) {
                a = 255;
            } else if (a < 0) {
                a = 0;
            }
            this.hasColor = true;
            this.color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? a << 24 | b << 16 | g << 8 | r : r << 24 | g << 16 | b << 8 | a;
        }
    }

    @Override
    public void addVertexWithUV(float x, float y, float z, float u, float v) {
        this.setTextureUV(u, v);
        this.addVertex(x, y, z);
    }

    public void addVertex(float par1, float par3, float par5) {
        if (this.rawBufferIndex >= this.rawBufferSize - 32) {
            if (this.rawBufferSize == 0) {
                this.rawBufferSize = 65536;
                this.rawBuffer = new int[this.rawBufferSize];
            } else {
                this.rawBufferSize *= 2;
                this.rawBuffer = Arrays.copyOf(this.rawBuffer, this.rawBufferSize);
            }
        }
        if (this.hasTexture) {
            this.rawBuffer[this.rawBufferIndex + 3] = Float.floatToRawIntBits(this.textureU);
            this.rawBuffer[this.rawBufferIndex + 4] = Float.floatToRawIntBits(this.textureV);
        }
        if (this.hasBrightness) {
            this.rawBuffer[this.rawBufferIndex + 7] = this.brightness;
        }
        if (this.hasColor) {
            this.rawBuffer[this.rawBufferIndex + 5] = this.color;
        }
        if (this.hasNormals) {
            this.rawBuffer[this.rawBufferIndex + 6] = this.normal;
        }
        this.rawBuffer[this.rawBufferIndex + 0] = Float.floatToRawIntBits(par1 + this.xOffset);
        this.rawBuffer[this.rawBufferIndex + 1] = Float.floatToRawIntBits(par3 + this.yOffset);
        this.rawBuffer[this.rawBufferIndex + 2] = Float.floatToRawIntBits(par5 + this.zOffset);
        this.rawBufferIndex += 8;
        ++this.vertexCount;
    }

    public void setColorOpaque_I(int par1) {
        int j = par1 >> 16 & 0xFF;
        int k = par1 >> 8 & 0xFF;
        int l = par1 & 0xFF;
        this.setColorOpaque(j, k, l);
    }

    public void setColorRGBA_I(int par1, int par2) {
        int k = par1 >> 16 & 0xFF;
        int l = par1 >> 8 & 0xFF;
        int i1 = par1 & 0xFF;
        this.setColor(k, l, i1, par2);
    }

    public void disableColor() {
        this.isColorDisabled = true;
    }

    @Override
    public void setNormal(float par1, float par2, float par3) {
        this.hasNormals = true;
        int b0 = (int)(par1 * 127.0f);
        int b1 = (int)(par2 * 127.0f);
        int b2 = (int)(par3 * 127.0f);
        this.normal = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
    }

    public void resetTranslation() {
        this.xOffset = 0.0f;
        this.yOffset = 0.0f;
        this.zOffset = 0.0f;
    }

    public void setTranslation(float par1, float par3, float par5) {
        this.xOffset = par1;
        this.yOffset = par3;
        this.zOffset = par5;
    }

    public void addTranslation(float par1, float par2, float par3) {
        this.xOffset += par1;
        this.yOffset += par2;
        this.zOffset += par3;
    }
}

