/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.IRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class VBO
extends GLObject
implements IRenderer {
    private static final int NATIVE_BUFFER_SIZE = 0x600000;
    private static final ByteBuffer byteBuffer = GLAllocation.func_74524_c((int)0x1800000);
    private static final IntBuffer intBuffer = byteBuffer.asIntBuffer();
    private static final FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
    private static final ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
    private int[] rawBuffer;
    private int rawBufferIndex;
    private int rawBufferSize = 0;
    private int vertexCount;
    private int drawMode;
    private boolean isDrawing;
    private float textureU;
    private float textureV;
    private int color;
    private int normal;
    private int brightness;
    private boolean hasTexture;
    private boolean hasColor;
    private boolean hasNormals;
    private boolean hasBrightness;
    private int vboId;
    private int vioId;

    public VBO(int id, int size) {
        super(id);
    }

    public void render() {
        int stride = 32;
        GL15.glBindBuffer((int)34963, (int)this.vioId);
        GL11.glEnableClientState((int)32884);
        if (this.hasTexture) {
            GL11.glEnableClientState((int)32888);
        }
        if (this.hasColor) {
            GL11.glEnableClientState((int)32886);
        }
        if (this.hasNormals) {
            GL11.glEnableClientState((int)32885);
        }
        if (this.hasBrightness) {
            GL11.glEnableClientState((int)32888);
        }
        GL15.glBindBuffer((int)34962, (int)this.vboId);
        GL11.glVertexPointer((int)3, (int)5126, (int)stride, (long)0L);
        if (this.hasTexture) {
            GL11.glTexCoordPointer((int)2, (int)5126, (int)stride, (long)12L);
        }
        if (this.hasColor) {
            GL11.glColorPointer((int)4, (int)5120, (int)stride, (long)20L);
        }
        if (this.hasNormals) {
            GL11.glNormalPointer((int)5120, (int)stride, (long)24L);
        }
        if (this.hasBrightness) {
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GL11.glTexCoordPointer((int)2, (int)5122, (int)stride, (long)28L);
        }
        GL11.glDrawElements((int)this.drawMode, (int)this.vertexCount, (int)5125, (long)0L);
        GL15.glBindBuffer((int)34963, (int)0);
        GL15.glBindBuffer((int)34962, (int)0);
        GL11.glDisableClientState((int)32884);
        if (this.hasTexture) {
            GL11.glDisableClientState((int)32888);
        }
        if (this.hasColor) {
            GL11.glDisableClientState((int)32886);
        }
        if (this.hasNormals) {
            GL11.glDisableClientState((int)32885);
        }
        if (this.hasBrightness) {
            GL11.glDisableClientState((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        }
    }

    @Override
    public int draw() {
        if (!this.isDrawing) {
            throw new IllegalStateException("Not tesselating!");
        }
        this.isDrawing = false;
        intBuffer.clear();
        intBuffer.put(this.rawBuffer, 0, this.vertexCount * 8);
        byteBuffer.position(0);
        byteBuffer.limit(this.vertexCount * 8 * 4);
        ByteBuffer vIndexByte = GLAllocation.func_74524_c((int)(this.vertexCount * 4));
        IntBuffer vIndexInt = vIndexByte.asIntBuffer();
        int[] vIndex = new int[this.vertexCount];
        for (int i = 0; i < this.vertexCount; ++i) {
            vIndex[i] = i;
        }
        vIndexInt.put(vIndex);
        vIndexByte.flip();
        this.vboId = GL15.glGenBuffers();
        this.vioId = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vboId);
        GL15.glBufferData((int)34962, (IntBuffer)intBuffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)this.vioId);
        GL15.glBufferData((int)34963, (IntBuffer)vIndexInt, (int)35044);
        GL15.glBindBuffer((int)34963, (int)0);
        return this.rawBufferIndex << 2;
    }

    private void reset() {
        this.vertexCount = 0;
        byteBuffer.clear();
        this.rawBufferIndex = 0;
    }

    @Override
    public void startDrawing(int par1) {
        if (this.isDrawing) {
            throw new IllegalStateException("Already tesselating!");
        }
        this.isDrawing = true;
        this.reset();
        this.drawMode = par1;
        this.hasNormals = false;
        this.hasColor = false;
        this.hasTexture = false;
        this.hasBrightness = false;
    }

    public void setTextureUV(float par1, float par3) {
        this.hasTexture = true;
        this.textureU = par1;
        this.textureV = par3;
    }

    @Override
    public void setBrightness(int par1) {
        this.hasBrightness = true;
        this.brightness = par1;
    }

    @Override
    public void setColor(int r, int g, int b, int a) {
        int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
        int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
        int n3 = b > 255 ? 255 : (b = b < 0 ? 0 : b);
        a = a > 255 ? 255 : (a < 0 ? 0 : a);
        this.hasColor = true;
        this.color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? a << 24 | b << 16 | g << 8 | r : r << 24 | g << 16 | b << 8 | a;
    }

    @Override
    public void addVertexWithUV(float par1, float par3, float par5, float par7, float par9) {
        this.setTextureUV(par7, par9);
        this.addVertex(par1, par3, par5);
    }

    public void addVertex(float par1, float par3, float par5) {
        if (this.rawBufferIndex >= this.rawBufferSize - 32) {
            if (this.rawBufferSize == 0) {
                this.rawBufferSize = 65536;
                this.rawBuffer = new int[this.rawBufferSize];
            } else {
                this.rawBufferSize *= 2;
                this.rawBuffer = Arrays.copyOf(this.rawBuffer, this.rawBufferSize);
            }
        }
        this.rawBuffer[this.rawBufferIndex + 0] = Float.floatToRawIntBits(par1);
        this.rawBuffer[this.rawBufferIndex + 1] = Float.floatToRawIntBits(par3);
        this.rawBuffer[this.rawBufferIndex + 2] = Float.floatToRawIntBits(par5);
        if (this.hasTexture) {
            this.rawBuffer[this.rawBufferIndex + 3] = Float.floatToRawIntBits(this.textureU);
            this.rawBuffer[this.rawBufferIndex + 4] = Float.floatToRawIntBits(this.textureV);
        }
        if (this.hasColor) {
            this.rawBuffer[this.rawBufferIndex + 5] = this.color;
        }
        if (this.hasNormals) {
            this.rawBuffer[this.rawBufferIndex + 6] = this.normal;
        }
        if (this.hasBrightness) {
            this.rawBuffer[this.rawBufferIndex + 7] = this.brightness;
        }
        this.rawBufferIndex += 8;
        ++this.vertexCount;
    }

    public void setColorOpaque_I(int par1) {
        this.setColorRGBA_I(par1, 255);
    }

    public void setColorRGBA_I(int par1, int par2) {
        int k = par1 >> 16 & 0xFF;
        int l = par1 >> 8 & 0xFF;
        int i1 = par1 & 0xFF;
        this.setColor(k, l, i1, par2);
    }

    @Override
    public void setNormal(float par1, float par2, float par3) {
        this.hasNormals = true;
        int b0 = (int)(par1 * 127.0f);
        int b1 = (int)(par2 * 127.0f);
        int b2 = (int)(par3 * 127.0f);
        this.normal = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
    }
}

